/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.sesv2.internal.SesV2ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.sesv2.model.AccountSuspendedException;
import software.amazon.awssdk.services.sesv2.model.AlreadyExistsException;
import software.amazon.awssdk.services.sesv2.model.BadRequestException;
import software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataRequest;
import software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataResponse;
import software.amazon.awssdk.services.sesv2.model.CancelExportJobRequest;
import software.amazon.awssdk.services.sesv2.model.CancelExportJobResponse;
import software.amazon.awssdk.services.sesv2.model.ConcurrentModificationException;
import software.amazon.awssdk.services.sesv2.model.ConflictException;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.CreateContactListRequest;
import software.amazon.awssdk.services.sesv2.model.CreateContactListResponse;
import software.amazon.awssdk.services.sesv2.model.CreateContactRequest;
import software.amazon.awssdk.services.sesv2.model.CreateContactResponse;
import software.amazon.awssdk.services.sesv2.model.CreateCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.CreateCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolRequest;
import software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolResponse;
import software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityPolicyRequest;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityPolicyResponse;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.CreateEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.CreateEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.CreateExportJobRequest;
import software.amazon.awssdk.services.sesv2.model.CreateExportJobResponse;
import software.amazon.awssdk.services.sesv2.model.CreateImportJobRequest;
import software.amazon.awssdk.services.sesv2.model.CreateImportJobResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteContactListRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteContactListResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteContactRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteContactResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityPolicyRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityPolicyResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteSuppressedDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteSuppressedDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.GetAccountRequest;
import software.amazon.awssdk.services.sesv2.model.GetAccountResponse;
import software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsRequest;
import software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsResponse;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsRequest;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsResponse;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.GetContactListRequest;
import software.amazon.awssdk.services.sesv2.model.GetContactListResponse;
import software.amazon.awssdk.services.sesv2.model.GetContactRequest;
import software.amazon.awssdk.services.sesv2.model.GetContactResponse;
import software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolResponse;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpResponse;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignRequest;
import software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignResponse;
import software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportRequest;
import software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportResponse;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesRequest;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesResponse;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.GetEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.GetEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.GetExportJobRequest;
import software.amazon.awssdk.services.sesv2.model.GetExportJobResponse;
import software.amazon.awssdk.services.sesv2.model.GetImportJobRequest;
import software.amazon.awssdk.services.sesv2.model.GetImportJobResponse;
import software.amazon.awssdk.services.sesv2.model.GetMessageInsightsRequest;
import software.amazon.awssdk.services.sesv2.model.GetMessageInsightsResponse;
import software.amazon.awssdk.services.sesv2.model.GetSuppressedDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.GetSuppressedDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.InternalServiceErrorException;
import software.amazon.awssdk.services.sesv2.model.InvalidNextTokenException;
import software.amazon.awssdk.services.sesv2.model.LimitExceededException;
import software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest;
import software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsResponse;
import software.amazon.awssdk.services.sesv2.model.ListContactListsRequest;
import software.amazon.awssdk.services.sesv2.model.ListContactListsResponse;
import software.amazon.awssdk.services.sesv2.model.ListContactsRequest;
import software.amazon.awssdk.services.sesv2.model.ListContactsResponse;
import software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest;
import software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse;
import software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse;
import software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse;
import software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse;
import software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest;
import software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse;
import software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest;
import software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse;
import software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest;
import software.amazon.awssdk.services.sesv2.model.ListExportJobsResponse;
import software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest;
import software.amazon.awssdk.services.sesv2.model.ListImportJobsResponse;
import software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.sesv2.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest;
import software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse;
import software.amazon.awssdk.services.sesv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.sesv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.sesv2.model.MailFromDomainNotVerifiedException;
import software.amazon.awssdk.services.sesv2.model.MessageRejectedException;
import software.amazon.awssdk.services.sesv2.model.NotFoundException;
import software.amazon.awssdk.services.sesv2.model.PutAccountDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountDetailsRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountDetailsResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountSuppressionAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountSuppressionAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountVdmAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountVdmAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSuppressionOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSuppressionOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetVdmOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetVdmOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpInPoolRequest;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpInPoolResponse;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpPoolScalingAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpPoolScalingAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionRequest;
import software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityConfigurationSetAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutSuppressedDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.PutSuppressedDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.SendBulkEmailRequest;
import software.amazon.awssdk.services.sesv2.model.SendBulkEmailResponse;
import software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailRequest;
import software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailResponse;
import software.amazon.awssdk.services.sesv2.model.SendEmailRequest;
import software.amazon.awssdk.services.sesv2.model.SendEmailResponse;
import software.amazon.awssdk.services.sesv2.model.SendingPausedException;
import software.amazon.awssdk.services.sesv2.model.SesV2Exception;
import software.amazon.awssdk.services.sesv2.model.TagResourceRequest;
import software.amazon.awssdk.services.sesv2.model.TagResourceResponse;
import software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.TooManyRequestsException;
import software.amazon.awssdk.services.sesv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.sesv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateContactListRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateContactListResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateContactRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateContactResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateEmailIdentityPolicyRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateEmailIdentityPolicyResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.transform.BatchGetMetricDataRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CancelExportJobRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateContactListRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateContactRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateCustomVerificationEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateDedicatedIpPoolRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateDeliverabilityTestReportRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateEmailIdentityPolicyRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateExportJobRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateImportJobRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteContactListRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteContactRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteCustomVerificationEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteDedicatedIpPoolRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteEmailIdentityPolicyRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteSuppressedDestinationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetAccountRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetBlacklistReportsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetConfigurationSetEventDestinationsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetContactListRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetContactRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetCustomVerificationEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDedicatedIpPoolRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDedicatedIpRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDedicatedIpsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDeliverabilityDashboardOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDeliverabilityTestReportRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDomainDeliverabilityCampaignRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDomainStatisticsReportRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetEmailIdentityPoliciesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetExportJobRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetImportJobRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetMessageInsightsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetSuppressedDestinationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListConfigurationSetsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListContactListsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListContactsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListCustomVerificationEmailTemplatesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListDedicatedIpPoolsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListDeliverabilityTestReportsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListDomainDeliverabilityCampaignsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListEmailIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListEmailTemplatesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListExportJobsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListImportJobsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListSuppressedDestinationsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutAccountDedicatedIpWarmupAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutAccountDetailsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutAccountSendingAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutAccountSuppressionAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutAccountVdmAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetDeliveryOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetReputationOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetSendingOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetSuppressionOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetTrackingOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetVdmOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutDedicatedIpInPoolRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutDedicatedIpPoolScalingAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutDedicatedIpWarmupAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutDeliverabilityDashboardOptionRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutEmailIdentityConfigurationSetAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutEmailIdentityDkimAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutEmailIdentityDkimSigningAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutEmailIdentityFeedbackAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutEmailIdentityMailFromAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutSuppressedDestinationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.SendBulkEmailRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.SendCustomVerificationEmailRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.SendEmailRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.TestRenderEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UpdateConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UpdateContactListRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UpdateContactRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UpdateCustomVerificationEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UpdateEmailIdentityPolicyRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UpdateEmailTemplateRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link SesV2AsyncClient}.
 *
 * @see SesV2AsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultSesV2AsyncClient implements SesV2AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSesV2AsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSesV2AsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Retrieves batches of metric data collected based on your sending activity.
     * </p>
     * <p>
     * You can execute this operation no more than 16 times per second, and with at most 160 queries from the batches
     * per second (cumulative).
     * </p>
     *
     * @param batchGetMetricDataRequest
     *        Represents a request to retrieve a batch of metric data.
     * @return A Java Future containing the result of the BatchGetMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>InternalServiceErrorException The request couldn't be processed because an error occurred with the
     *         Amazon SES API v2.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.BatchGetMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/BatchGetMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetMetricDataResponse> batchGetMetricData(BatchGetMetricDataRequest batchGetMetricDataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetMetricDataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetMetricDataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetMetricDataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetMetricDataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetMetricDataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetMetricDataRequest, BatchGetMetricDataResponse>()
                            .withOperationName("BatchGetMetricData").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetMetricDataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetMetricDataRequest));
            CompletableFuture<BatchGetMetricDataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels an export job.
     * </p>
     *
     * @param cancelExportJobRequest
     *        Represents a request to cancel an export job using the export job ID.
     * @return A Java Future containing the result of the CancelExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CancelExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CancelExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelExportJobResponse> cancelExportJob(CancelExportJobRequest cancelExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelExportJobRequest, CancelExportJobResponse>()
                            .withOperationName("CancelExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelExportJobRequest));
            CompletableFuture<CancelExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a configuration set. <i>Configuration sets</i> are groups of rules that you can apply to the emails that
     * you send. You apply a configuration set to an email by specifying the name of the configuration set when you call
     * the Amazon SES API v2. When you apply a configuration set to an email, all of the rules in that configuration set
     * are applied to the email.
     * </p>
     *
     * @param createConfigurationSetRequest
     *        A request to create a configuration set.
     * @return A Java Future containing the result of the CreateConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConfigurationSetResponse> createConfigurationSet(
            CreateConfigurationSetRequest createConfigurationSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConfigurationSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConfigurationSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConfigurationSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConfigurationSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateConfigurationSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateConfigurationSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConfigurationSetRequest, CreateConfigurationSetResponse>()
                            .withOperationName("CreateConfigurationSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateConfigurationSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createConfigurationSetRequest));
            CompletableFuture<CreateConfigurationSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create an event destination. <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and
     * complaints. <i>Event destinations</i> are places that you can send information about these events to. For
     * example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints,
     * or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     * <p>
     * A single configuration set can include more than one event destination.
     * </p>
     *
     * @param createConfigurationSetEventDestinationRequest
     *        A request to add an event destination to a configuration set.
     * @return A Java Future containing the result of the CreateConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateConfigurationSetEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConfigurationSetEventDestinationResponse> createConfigurationSetEventDestination(
            CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConfigurationSetEventDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createConfigurationSetEventDestinationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConfigurationSetEventDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConfigurationSetEventDestinationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateConfigurationSetEventDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateConfigurationSetEventDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConfigurationSetEventDestinationRequest, CreateConfigurationSetEventDestinationResponse>()
                            .withOperationName("CreateConfigurationSetEventDestination").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateConfigurationSetEventDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createConfigurationSetEventDestinationRequest));
            CompletableFuture<CreateConfigurationSetEventDestinationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a contact, which is an end-user who is receiving the email, and adds them to a contact list.
     * </p>
     *
     * @param createContactRequest
     * @return A Java Future containing the result of the CreateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateContact" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateContactResponse> createContact(CreateContactRequest createContactRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContactRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateContactResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateContactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateContactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateContactRequest, CreateContactResponse>()
                            .withOperationName("CreateContact").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateContactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createContactRequest));
            CompletableFuture<CreateContactResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a contact list.
     * </p>
     *
     * @param createContactListRequest
     * @return A Java Future containing the result of the CreateContactList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateContactList" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateContactListResponse> createContactList(CreateContactListRequest createContactListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContactListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContactListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContactList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateContactListResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateContactListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateContactListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateContactListRequest, CreateContactListResponse>()
                            .withOperationName("CreateContactList").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateContactListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createContactListRequest));
            CompletableFuture<CreateContactListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createCustomVerificationEmailTemplateRequest
     *        Represents a request to create a custom verification email template.
     * @return A Java Future containing the result of the CreateCustomVerificationEmailTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCustomVerificationEmailTemplateResponse> createCustomVerificationEmailTemplate(
            CreateCustomVerificationEmailTemplateRequest createCustomVerificationEmailTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCustomVerificationEmailTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCustomVerificationEmailTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomVerificationEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCustomVerificationEmailTemplateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateCustomVerificationEmailTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCustomVerificationEmailTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCustomVerificationEmailTemplateRequest, CreateCustomVerificationEmailTemplateResponse>()
                            .withOperationName("CreateCustomVerificationEmailTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCustomVerificationEmailTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCustomVerificationEmailTemplateRequest));
            CompletableFuture<CreateCustomVerificationEmailTemplateResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are
     * associated with your Amazon Web Services account. You can associate a pool with a configuration set. When you
     * send an email that uses that configuration set, the message is sent from one of the addresses in the associated
     * pool.
     * </p>
     *
     * @param createDedicatedIpPoolRequest
     *        A request to create a new dedicated IP pool.
     * @return A Java Future containing the result of the CreateDedicatedIpPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateDedicatedIpPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDedicatedIpPool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDedicatedIpPoolResponse> createDedicatedIpPool(
            CreateDedicatedIpPoolRequest createDedicatedIpPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDedicatedIpPoolRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDedicatedIpPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDedicatedIpPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDedicatedIpPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDedicatedIpPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDedicatedIpPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDedicatedIpPoolRequest, CreateDedicatedIpPoolResponse>()
                            .withOperationName("CreateDedicatedIpPool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDedicatedIpPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDedicatedIpPoolRequest));
            CompletableFuture<CreateDedicatedIpPoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a new predictive inbox placement test. Predictive inbox placement tests can help you predict how your
     * messages will be handled by various email providers around the world. When you perform a predictive inbox
     * placement test, you provide a sample message that contains the content that you plan to send to your customers.
     * Amazon SES then sends that message to special email addresses spread across several major email providers. After
     * about 24 hours, the test is complete, and you can use the <code>GetDeliverabilityTestReport</code> operation to
     * view the results of the test.
     * </p>
     *
     * @param createDeliverabilityTestReportRequest
     *        A request to perform a predictive inbox placement test. Predictive inbox placement tests can help you
     *        predict how your messages will be handled by various email providers around the world. When you perform a
     *        predictive inbox placement test, you provide a sample message that contains the content that you plan to
     *        send to your customers. We send that message to special email addresses spread across several major email
     *        providers around the world. The test takes about 24 hours to complete. When the test is complete, you can
     *        use the <code>GetDeliverabilityTestReport</code> operation to view the results of the test.
     * @return A Java Future containing the result of the CreateDeliverabilityTestReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccountSuspendedException The message can't be sent because the account's ability to send email has
     *         been permanently restricted.</li>
     *         <li>SendingPausedException The message can't be sent because the account's ability to send email is
     *         currently paused.</li>
     *         <li>MessageRejectedException The message can't be sent because it contains invalid content.</li>
     *         <li>MailFromDomainNotVerifiedException The message can't be sent because the sending domain isn't
     *         verified.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateDeliverabilityTestReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDeliverabilityTestReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeliverabilityTestReportResponse> createDeliverabilityTestReport(
            CreateDeliverabilityTestReportRequest createDeliverabilityTestReportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDeliverabilityTestReportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createDeliverabilityTestReportRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeliverabilityTestReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeliverabilityTestReportResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeliverabilityTestReportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDeliverabilityTestReportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDeliverabilityTestReportRequest, CreateDeliverabilityTestReportResponse>()
                            .withOperationName("CreateDeliverabilityTestReport").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDeliverabilityTestReportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDeliverabilityTestReportRequest));
            CompletableFuture<CreateDeliverabilityTestReportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts the process of verifying an email identity. An <i>identity</i> is an email address or domain that you use
     * when you send email. Before you can use an identity to send email, you first have to verify it. By verifying an
     * identity, you demonstrate that you're the owner of the identity, and that you've given Amazon SES API v2
     * permission to send email from the identity.
     * </p>
     * <p>
     * When you verify an email address, Amazon SES sends an email to the address. Your email address is verified as
     * soon as you follow the link in the verification email.
     * </p>
     * <p>
     * When you verify a domain without specifying the <code>DkimSigningAttributes</code> object, this operation
     * provides a set of DKIM tokens. You can convert these tokens into CNAME records, which you then add to the DNS
     * configuration for your domain. Your domain is verified when Amazon SES detects these records in the DNS
     * configuration for your domain. This verification method is known as <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.
     * </p>
     * <p>
     * Alternatively, you can perform the verification process by providing your own public-private key pair. This
     * verification method is known as Bring Your Own DKIM (BYODKIM). To use BYODKIM, your call to the
     * <code>CreateEmailIdentity</code> operation has to include the <code>DkimSigningAttributes</code> object. When you
     * specify this object, you provide a selector (a component of the DNS record name that identifies the public key to
     * use for DKIM authentication) and a private key.
     * </p>
     * <p>
     * When you verify a domain, this operation provides a set of DKIM tokens, which you can convert into CNAME tokens.
     * You add these CNAME tokens to the DNS configuration for your domain. Your domain is verified when Amazon SES
     * detects these records in the DNS configuration for your domain. For some DNS providers, it can take 72 hours or
     * more to complete the domain verification process.
     * </p>
     * <p>
     * Additionally, you can associate an existing configuration set with the email identity that you're verifying.
     * </p>
     *
     * @param createEmailIdentityRequest
     *        A request to begin the verification process for an email identity (an email address or domain).
     * @return A Java Future containing the result of the CreateEmailIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateEmailIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEmailIdentityResponse> createEmailIdentity(
            CreateEmailIdentityRequest createEmailIdentityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEmailIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEmailIdentityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEmailIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEmailIdentityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEmailIdentityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEmailIdentityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEmailIdentityRequest, CreateEmailIdentityResponse>()
                            .withOperationName("CreateEmailIdentity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEmailIdentityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEmailIdentityRequest));
            CompletableFuture<CreateEmailIdentityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates the specified sending authorization policy for the given identity (an email address or a domain).
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createEmailIdentityPolicyRequest
     *        Represents a request to create a sending authorization policy for an identity. Sending authorization is an
     *        Amazon SES feature that enables you to authorize other senders to use your identities. For information,
     *        see the <a href=
     *        "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html"
     *        >Amazon SES Developer Guide</a>.
     * @return A Java Future containing the result of the CreateEmailIdentityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateEmailIdentityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailIdentityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEmailIdentityPolicyResponse> createEmailIdentityPolicy(
            CreateEmailIdentityPolicyRequest createEmailIdentityPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEmailIdentityPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEmailIdentityPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEmailIdentityPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEmailIdentityPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEmailIdentityPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEmailIdentityPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEmailIdentityPolicyRequest, CreateEmailIdentityPolicyResponse>()
                            .withOperationName("CreateEmailIdentityPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEmailIdentityPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEmailIdentityPolicyRequest));
            CompletableFuture<CreateEmailIdentityPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createEmailTemplateRequest
     *        Represents a request to create an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the CreateEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEmailTemplateResponse> createEmailTemplate(
            CreateEmailTemplateRequest createEmailTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEmailTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEmailTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEmailTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEmailTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEmailTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEmailTemplateRequest, CreateEmailTemplateResponse>()
                            .withOperationName("CreateEmailTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEmailTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEmailTemplateRequest));
            CompletableFuture<CreateEmailTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an export job for a data source and destination.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createExportJobRequest
     *        Represents a request to create an export job from a data source to a data destination.
     * @return A Java Future containing the result of the CreateExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateExportJobResponse> createExportJob(CreateExportJobRequest createExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateExportJobRequest, CreateExportJobResponse>()
                            .withOperationName("CreateExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createExportJobRequest));
            CompletableFuture<CreateExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an import job for a data destination.
     * </p>
     *
     * @param createImportJobRequest
     *        Represents a request to create an import job from a data source for a data destination.
     * @return A Java Future containing the result of the CreateImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateImportJobResponse> createImportJob(CreateImportJobRequest createImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateImportJobRequest, CreateImportJobResponse>()
                            .withOperationName("CreateImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createImportJobRequest));
            CompletableFuture<CreateImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete an existing configuration set.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     *
     * @param deleteConfigurationSetRequest
     *        A request to delete a configuration set.
     * @return A Java Future containing the result of the DeleteConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfigurationSetResponse> deleteConfigurationSet(
            DeleteConfigurationSetRequest deleteConfigurationSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConfigurationSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConfigurationSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfigurationSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfigurationSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConfigurationSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConfigurationSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfigurationSetRequest, DeleteConfigurationSetResponse>()
                            .withOperationName("DeleteConfigurationSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConfigurationSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConfigurationSetRequest));
            CompletableFuture<DeleteConfigurationSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete an event destination.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis
     * Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     *
     * @param deleteConfigurationSetEventDestinationRequest
     *        A request to delete an event destination from a configuration set.
     * @return A Java Future containing the result of the DeleteConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteConfigurationSetEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfigurationSetEventDestinationResponse> deleteConfigurationSetEventDestination(
            DeleteConfigurationSetEventDestinationRequest deleteConfigurationSetEventDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConfigurationSetEventDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteConfigurationSetEventDestinationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfigurationSetEventDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfigurationSetEventDestinationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteConfigurationSetEventDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConfigurationSetEventDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfigurationSetEventDestinationRequest, DeleteConfigurationSetEventDestinationResponse>()
                            .withOperationName("DeleteConfigurationSetEventDestination").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConfigurationSetEventDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConfigurationSetEventDestinationRequest));
            CompletableFuture<DeleteConfigurationSetEventDestinationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a contact from a contact list.
     * </p>
     *
     * @param deleteContactRequest
     * @return A Java Future containing the result of the DeleteContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteContact" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteContactResponse> deleteContact(DeleteContactRequest deleteContactRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContactRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteContactResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteContactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteContactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteContactRequest, DeleteContactResponse>()
                            .withOperationName("DeleteContact").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteContactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteContactRequest));
            CompletableFuture<DeleteContactResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a contact list and all of the contacts on that list.
     * </p>
     *
     * @param deleteContactListRequest
     * @return A Java Future containing the result of the DeleteContactList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteContactList" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteContactListResponse> deleteContactList(DeleteContactListRequest deleteContactListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContactListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContactListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContactList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteContactListResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteContactListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteContactListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteContactListRequest, DeleteContactListResponse>()
                            .withOperationName("DeleteContactList").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteContactListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteContactListRequest));
            CompletableFuture<DeleteContactListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteCustomVerificationEmailTemplateRequest
     *        Represents a request to delete an existing custom verification email template.
     * @return A Java Future containing the result of the DeleteCustomVerificationEmailTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCustomVerificationEmailTemplateResponse> deleteCustomVerificationEmailTemplate(
            DeleteCustomVerificationEmailTemplateRequest deleteCustomVerificationEmailTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCustomVerificationEmailTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCustomVerificationEmailTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomVerificationEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCustomVerificationEmailTemplateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteCustomVerificationEmailTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCustomVerificationEmailTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomVerificationEmailTemplateRequest, DeleteCustomVerificationEmailTemplateResponse>()
                            .withOperationName("DeleteCustomVerificationEmailTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCustomVerificationEmailTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCustomVerificationEmailTemplateRequest));
            CompletableFuture<DeleteCustomVerificationEmailTemplateResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a dedicated IP pool.
     * </p>
     *
     * @param deleteDedicatedIpPoolRequest
     *        A request to delete a dedicated IP pool.
     * @return A Java Future containing the result of the DeleteDedicatedIpPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteDedicatedIpPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteDedicatedIpPool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDedicatedIpPoolResponse> deleteDedicatedIpPool(
            DeleteDedicatedIpPoolRequest deleteDedicatedIpPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDedicatedIpPoolRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDedicatedIpPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDedicatedIpPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDedicatedIpPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDedicatedIpPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDedicatedIpPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDedicatedIpPoolRequest, DeleteDedicatedIpPoolResponse>()
                            .withOperationName("DeleteDedicatedIpPool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDedicatedIpPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDedicatedIpPoolRequest));
            CompletableFuture<DeleteDedicatedIpPoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an email identity. An identity can be either an email address or a domain name.
     * </p>
     *
     * @param deleteEmailIdentityRequest
     *        A request to delete an existing email identity. When you delete an identity, you lose the ability to send
     *        email from that identity. You can restore your ability to send email by completing the verification
     *        process for the identity again.
     * @return A Java Future containing the result of the DeleteEmailIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteEmailIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEmailIdentityResponse> deleteEmailIdentity(
            DeleteEmailIdentityRequest deleteEmailIdentityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEmailIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEmailIdentityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEmailIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEmailIdentityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEmailIdentityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEmailIdentityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEmailIdentityRequest, DeleteEmailIdentityResponse>()
                            .withOperationName("DeleteEmailIdentity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEmailIdentityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEmailIdentityRequest));
            CompletableFuture<DeleteEmailIdentityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified sending authorization policy for the given identity (an email address or a domain). This
     * API returns successfully even if a policy with the specified name does not exist.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteEmailIdentityPolicyRequest
     *        Represents a request to delete a sending authorization policy for an identity. Sending authorization is an
     *        Amazon SES feature that enables you to authorize other senders to use your identities. For information,
     *        see the <a href=
     *        "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html"
     *        >Amazon SES Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteEmailIdentityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteEmailIdentityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailIdentityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEmailIdentityPolicyResponse> deleteEmailIdentityPolicy(
            DeleteEmailIdentityPolicyRequest deleteEmailIdentityPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEmailIdentityPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEmailIdentityPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEmailIdentityPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEmailIdentityPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEmailIdentityPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEmailIdentityPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEmailIdentityPolicyRequest, DeleteEmailIdentityPolicyResponse>()
                            .withOperationName("DeleteEmailIdentityPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEmailIdentityPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEmailIdentityPolicyRequest));
            CompletableFuture<DeleteEmailIdentityPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an email template.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteEmailTemplateRequest
     *        Represents a request to delete an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEmailTemplateResponse> deleteEmailTemplate(
            DeleteEmailTemplateRequest deleteEmailTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEmailTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEmailTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEmailTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEmailTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEmailTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEmailTemplateRequest, DeleteEmailTemplateResponse>()
                            .withOperationName("DeleteEmailTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEmailTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEmailTemplateRequest));
            CompletableFuture<DeleteEmailTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes an email address from the suppression list for your account.
     * </p>
     *
     * @param deleteSuppressedDestinationRequest
     *        A request to remove an email address from the suppression list for your account.
     * @return A Java Future containing the result of the DeleteSuppressedDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteSuppressedDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteSuppressedDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSuppressedDestinationResponse> deleteSuppressedDestination(
            DeleteSuppressedDestinationRequest deleteSuppressedDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSuppressedDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSuppressedDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSuppressedDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSuppressedDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSuppressedDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSuppressedDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSuppressedDestinationRequest, DeleteSuppressedDestinationResponse>()
                            .withOperationName("DeleteSuppressedDestination").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSuppressedDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSuppressedDestinationRequest));
            CompletableFuture<DeleteSuppressedDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Obtain information about the email-sending status and capabilities of your Amazon SES account in the current
     * Amazon Web Services Region.
     * </p>
     *
     * @param getAccountRequest
     *        A request to obtain information about the email-sending capabilities of your Amazon SES account.
     * @return A Java Future containing the result of the GetAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetAccount" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccountResponse> getAccount(GetAccountRequest getAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAccountResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccountRequest, GetAccountResponse>().withOperationName("GetAccount")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAccountRequest));
            CompletableFuture<GetAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieve a list of the blacklists that your dedicated IP addresses appear on.
     * </p>
     *
     * @param getBlacklistReportsRequest
     *        A request to retrieve a list of the blacklists that your dedicated IP addresses appear on.
     * @return A Java Future containing the result of the GetBlacklistReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetBlacklistReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetBlacklistReports" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBlacklistReportsResponse> getBlacklistReports(
            GetBlacklistReportsRequest getBlacklistReportsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBlacklistReportsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBlacklistReportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBlacklistReports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBlacklistReportsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBlacklistReportsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBlacklistReportsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBlacklistReportsRequest, GetBlacklistReportsResponse>()
                            .withOperationName("GetBlacklistReports").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBlacklistReportsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBlacklistReportsRequest));
            CompletableFuture<GetBlacklistReportsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get information about an existing configuration set, including the dedicated IP pool that it's associated with,
     * whether or not it's enabled for sending email, and more.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     *
     * @param getConfigurationSetRequest
     *        A request to obtain information about a configuration set.
     * @return A Java Future containing the result of the GetConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetConfigurationSetResponse> getConfigurationSet(
            GetConfigurationSetRequest getConfigurationSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConfigurationSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getConfigurationSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConfigurationSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConfigurationSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetConfigurationSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConfigurationSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConfigurationSetRequest, GetConfigurationSetResponse>()
                            .withOperationName("GetConfigurationSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetConfigurationSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getConfigurationSetRequest));
            CompletableFuture<GetConfigurationSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieve a list of event destinations that are associated with a configuration set.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis
     * Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     *
     * @param getConfigurationSetEventDestinationsRequest
     *        A request to obtain information about the event destinations for a configuration set.
     * @return A Java Future containing the result of the GetConfigurationSetEventDestinations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetConfigurationSetEventDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSetEventDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConfigurationSetEventDestinationsResponse> getConfigurationSetEventDestinations(
            GetConfigurationSetEventDestinationsRequest getConfigurationSetEventDestinationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConfigurationSetEventDestinationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getConfigurationSetEventDestinationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConfigurationSetEventDestinations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConfigurationSetEventDestinationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetConfigurationSetEventDestinationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConfigurationSetEventDestinationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConfigurationSetEventDestinationsRequest, GetConfigurationSetEventDestinationsResponse>()
                            .withOperationName("GetConfigurationSetEventDestinations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetConfigurationSetEventDestinationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getConfigurationSetEventDestinationsRequest));
            CompletableFuture<GetConfigurationSetEventDestinationsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a contact from a contact list.
     * </p>
     *
     * @param getContactRequest
     * @return A Java Future containing the result of the GetContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetContact" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetContactResponse> getContact(GetContactRequest getContactRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getContactRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContactResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetContactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContactRequest, GetContactResponse>().withOperationName("GetContact")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetContactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getContactRequest));
            CompletableFuture<GetContactResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns contact list metadata. It does not return any information about the contacts present in the list.
     * </p>
     *
     * @param getContactListRequest
     * @return A Java Future containing the result of the GetContactList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetContactList" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetContactListResponse> getContactList(GetContactListRequest getContactListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getContactListRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContactListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContactList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContactListResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetContactListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContactListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContactListRequest, GetContactListResponse>()
                            .withOperationName("GetContactList").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetContactListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getContactListRequest));
            CompletableFuture<GetContactListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the custom email verification template for the template name you specify.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getCustomVerificationEmailTemplateRequest
     *        Represents a request to retrieve an existing custom verification email template.
     * @return A Java Future containing the result of the GetCustomVerificationEmailTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCustomVerificationEmailTemplateResponse> getCustomVerificationEmailTemplate(
            GetCustomVerificationEmailTemplateRequest getCustomVerificationEmailTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCustomVerificationEmailTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCustomVerificationEmailTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCustomVerificationEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCustomVerificationEmailTemplateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetCustomVerificationEmailTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCustomVerificationEmailTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCustomVerificationEmailTemplateRequest, GetCustomVerificationEmailTemplateResponse>()
                            .withOperationName("GetCustomVerificationEmailTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCustomVerificationEmailTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCustomVerificationEmailTemplateRequest));
            CompletableFuture<GetCustomVerificationEmailTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated
     * with, as well information about the automatic warm-up process for the address.
     * </p>
     *
     * @param getDedicatedIpRequest
     *        A request to obtain more information about a dedicated IP address.
     * @return A Java Future containing the result of the GetDedicatedIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDedicatedIp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDedicatedIpResponse> getDedicatedIp(GetDedicatedIpRequest getDedicatedIpRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDedicatedIpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDedicatedIpRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDedicatedIp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDedicatedIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDedicatedIpResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDedicatedIpResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDedicatedIpRequest, GetDedicatedIpResponse>()
                            .withOperationName("GetDedicatedIp").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDedicatedIpRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDedicatedIpRequest));
            CompletableFuture<GetDedicatedIpResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieve information about the dedicated pool.
     * </p>
     *
     * @param getDedicatedIpPoolRequest
     *        A request to obtain more information about a dedicated IP pool.
     * @return A Java Future containing the result of the GetDedicatedIpPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDedicatedIpPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIpPool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDedicatedIpPoolResponse> getDedicatedIpPool(GetDedicatedIpPoolRequest getDedicatedIpPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDedicatedIpPoolRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDedicatedIpPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDedicatedIpPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDedicatedIpPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDedicatedIpPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDedicatedIpPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDedicatedIpPoolRequest, GetDedicatedIpPoolResponse>()
                            .withOperationName("GetDedicatedIpPool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDedicatedIpPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDedicatedIpPoolRequest));
            CompletableFuture<GetDedicatedIpPoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the dedicated IP addresses that are associated with your Amazon Web Services account.
     * </p>
     *
     * @param getDedicatedIpsRequest
     *        A request to obtain more information about dedicated IP pools.
     * @return A Java Future containing the result of the GetDedicatedIps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDedicatedIps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDedicatedIpsResponse> getDedicatedIps(GetDedicatedIpsRequest getDedicatedIpsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDedicatedIpsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDedicatedIpsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDedicatedIps");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDedicatedIpsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDedicatedIpsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDedicatedIpsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDedicatedIpsRequest, GetDedicatedIpsResponse>()
                            .withOperationName("GetDedicatedIps").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDedicatedIpsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDedicatedIpsRequest));
            CompletableFuture<GetDedicatedIpsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieve information about the status of the Deliverability dashboard for your account. When the Deliverability
     * dashboard is enabled, you gain access to reputation, deliverability, and other metrics for the domains that you
     * use to send email. You also gain the ability to perform predictive inbox placement tests.
     * </p>
     * <p>
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees
     * that you accrue by using Amazon SES and other Amazon Web Services services. For more information about the
     * features and cost of a Deliverability dashboard subscription, see <a
     * href="http://aws.amazon.com/ses/pricing/">Amazon SES Pricing</a>.
     * </p>
     *
     * @param getDeliverabilityDashboardOptionsRequest
     *        Retrieve information about the status of the Deliverability dashboard for your Amazon Web Services
     *        account. When the Deliverability dashboard is enabled, you gain access to reputation, deliverability, and
     *        other metrics for your domains. You also gain the ability to perform predictive inbox placement tests.</p>
     *        <p>
     *        When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other
     *        fees that you accrue by using Amazon SES and other Amazon Web Services services. For more information
     *        about the features and cost of a Deliverability dashboard subscription, see <a
     *        href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.
     * @return A Java Future containing the result of the GetDeliverabilityDashboardOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li> <li>
     *         LimitExceededException There are too many instances of the specified resource type.</li> <li>
     *         BadRequestException The input you provided is invalid.</li> <li>SdkException Base class for all
     *         exceptions that can be thrown by the SDK (both service and client). Can be used for catch all scenarios.
     *         </li> <li>SdkClientException If any client side error occurs such as an IO related failure, failure to
     *         get credentials, etc.</li> <li>SesV2Exception Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDeliverabilityDashboardOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityDashboardOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeliverabilityDashboardOptionsResponse> getDeliverabilityDashboardOptions(
            GetDeliverabilityDashboardOptionsRequest getDeliverabilityDashboardOptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeliverabilityDashboardOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getDeliverabilityDashboardOptionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeliverabilityDashboardOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeliverabilityDashboardOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetDeliverabilityDashboardOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeliverabilityDashboardOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeliverabilityDashboardOptionsRequest, GetDeliverabilityDashboardOptionsResponse>()
                            .withOperationName("GetDeliverabilityDashboardOptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDeliverabilityDashboardOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDeliverabilityDashboardOptionsRequest));
            CompletableFuture<GetDeliverabilityDashboardOptionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieve the results of a predictive inbox placement test.
     * </p>
     *
     * @param getDeliverabilityTestReportRequest
     *        A request to retrieve the results of a predictive inbox placement test.
     * @return A Java Future containing the result of the GetDeliverabilityTestReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDeliverabilityTestReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityTestReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeliverabilityTestReportResponse> getDeliverabilityTestReport(
            GetDeliverabilityTestReportRequest getDeliverabilityTestReportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeliverabilityTestReportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeliverabilityTestReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeliverabilityTestReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeliverabilityTestReportResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeliverabilityTestReportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeliverabilityTestReportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeliverabilityTestReportRequest, GetDeliverabilityTestReportResponse>()
                            .withOperationName("GetDeliverabilityTestReport").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDeliverabilityTestReportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDeliverabilityTestReportRequest));
            CompletableFuture<GetDeliverabilityTestReportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the
     * campaign sent email by using a domain that the Deliverability dashboard is enabled for.
     * </p>
     *
     * @param getDomainDeliverabilityCampaignRequest
     *        Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only
     *        if the campaign sent email by using a domain that the Deliverability dashboard is enabled for (
     *        <code>PutDeliverabilityDashboardOption</code> operation).
     * @return A Java Future containing the result of the GetDomainDeliverabilityCampaign operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDomainDeliverabilityCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainDeliverabilityCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDomainDeliverabilityCampaignResponse> getDomainDeliverabilityCampaign(
            GetDomainDeliverabilityCampaignRequest getDomainDeliverabilityCampaignRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDomainDeliverabilityCampaignRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getDomainDeliverabilityCampaignRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDomainDeliverabilityCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDomainDeliverabilityCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDomainDeliverabilityCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDomainDeliverabilityCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDomainDeliverabilityCampaignRequest, GetDomainDeliverabilityCampaignResponse>()
                            .withOperationName("GetDomainDeliverabilityCampaign").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDomainDeliverabilityCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDomainDeliverabilityCampaignRequest));
            CompletableFuture<GetDomainDeliverabilityCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieve inbox placement and engagement rates for the domains that you use to send email.
     * </p>
     *
     * @param getDomainStatisticsReportRequest
     *        A request to obtain deliverability metrics for a domain.
     * @return A Java Future containing the result of the GetDomainStatisticsReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDomainStatisticsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainStatisticsReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDomainStatisticsReportResponse> getDomainStatisticsReport(
            GetDomainStatisticsReportRequest getDomainStatisticsReportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDomainStatisticsReportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDomainStatisticsReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDomainStatisticsReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDomainStatisticsReportResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDomainStatisticsReportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDomainStatisticsReportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDomainStatisticsReportRequest, GetDomainStatisticsReportResponse>()
                            .withOperationName("GetDomainStatisticsReport").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDomainStatisticsReportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDomainStatisticsReportRequest));
            CompletableFuture<GetDomainStatisticsReportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides information about a specific identity, including the identity's verification status, sending
     * authorization policies, its DKIM authentication status, and its custom Mail-From settings.
     * </p>
     *
     * @param getEmailIdentityRequest
     *        A request to return details about an email identity.
     * @return A Java Future containing the result of the GetEmailIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetEmailIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetEmailIdentityResponse> getEmailIdentity(GetEmailIdentityRequest getEmailIdentityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEmailIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEmailIdentityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEmailIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEmailIdentityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEmailIdentityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEmailIdentityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEmailIdentityRequest, GetEmailIdentityResponse>()
                            .withOperationName("GetEmailIdentity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEmailIdentityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEmailIdentityRequest));
            CompletableFuture<GetEmailIdentityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the requested sending authorization policies for the given identity (an email address or a domain). The
     * policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a
     * time.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getEmailIdentityPoliciesRequest
     *        A request to return the policies of an email identity.
     * @return A Java Future containing the result of the GetEmailIdentityPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetEmailIdentityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailIdentityPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEmailIdentityPoliciesResponse> getEmailIdentityPolicies(
            GetEmailIdentityPoliciesRequest getEmailIdentityPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEmailIdentityPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEmailIdentityPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEmailIdentityPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEmailIdentityPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEmailIdentityPoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEmailIdentityPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEmailIdentityPoliciesRequest, GetEmailIdentityPoliciesResponse>()
                            .withOperationName("GetEmailIdentityPolicies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEmailIdentityPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEmailIdentityPoliciesRequest));
            CompletableFuture<GetEmailIdentityPoliciesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays the template object (which includes the subject line, HTML part and text part) for the template you
     * specify.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getEmailTemplateRequest
     *        Represents a request to display the template object (which includes the subject line, HTML part and text
     *        part) for the template you specify.
     * @return A Java Future containing the result of the GetEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetEmailTemplateResponse> getEmailTemplate(GetEmailTemplateRequest getEmailTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEmailTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEmailTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEmailTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEmailTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEmailTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEmailTemplateRequest, GetEmailTemplateResponse>()
                            .withOperationName("GetEmailTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEmailTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEmailTemplateRequest));
            CompletableFuture<GetEmailTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides information about an export job.
     * </p>
     *
     * @param getExportJobRequest
     *        Represents a request to retrieve information about an export job using the export job ID.
     * @return A Java Future containing the result of the GetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetExportJobResponse> getExportJob(GetExportJobRequest getExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getExportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetExportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetExportJobRequest, GetExportJobResponse>()
                            .withOperationName("GetExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getExportJobRequest));
            CompletableFuture<GetExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides information about an import job.
     * </p>
     *
     * @param getImportJobRequest
     *        Represents a request for information about an import job using the import job ID.
     * @return A Java Future containing the result of the GetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetImportJobResponse> getImportJob(GetImportJobRequest getImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImportJobRequest, GetImportJobResponse>()
                            .withOperationName("GetImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getImportJobRequest));
            CompletableFuture<GetImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides information about a specific message, including the from address, the subject, the recipient address,
     * email tags, as well as events associated with the message.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getMessageInsightsRequest
     *        A request to return information about a message.
     * @return A Java Future containing the result of the GetMessageInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetMessageInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetMessageInsights" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMessageInsightsResponse> getMessageInsights(GetMessageInsightsRequest getMessageInsightsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMessageInsightsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMessageInsightsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMessageInsights");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMessageInsightsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMessageInsightsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMessageInsightsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMessageInsightsRequest, GetMessageInsightsResponse>()
                            .withOperationName("GetMessageInsights").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMessageInsightsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMessageInsightsRequest));
            CompletableFuture<GetMessageInsightsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a specific email address that's on the suppression list for your account.
     * </p>
     *
     * @param getSuppressedDestinationRequest
     *        A request to retrieve information about an email address that's on the suppression list for your account.
     * @return A Java Future containing the result of the GetSuppressedDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetSuppressedDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetSuppressedDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSuppressedDestinationResponse> getSuppressedDestination(
            GetSuppressedDestinationRequest getSuppressedDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSuppressedDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSuppressedDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSuppressedDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSuppressedDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSuppressedDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSuppressedDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSuppressedDestinationRequest, GetSuppressedDestinationResponse>()
                            .withOperationName("GetSuppressedDestination").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSuppressedDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSuppressedDestinationRequest));
            CompletableFuture<GetSuppressedDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List all of the configuration sets associated with your account in the current region.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        A request to obtain a list of configuration sets for your Amazon SES account in the current Amazon Web
     *        Services Region.
     * @return A Java Future containing the result of the ListConfigurationSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListConfigurationSetsResponse> listConfigurationSets(
            ListConfigurationSetsRequest listConfigurationSetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listConfigurationSetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listConfigurationSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConfigurationSets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListConfigurationSetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListConfigurationSetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListConfigurationSetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListConfigurationSetsRequest, ListConfigurationSetsResponse>()
                            .withOperationName("ListConfigurationSets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListConfigurationSetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listConfigurationSetsRequest));
            CompletableFuture<ListConfigurationSetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all of the contact lists available.
     * </p>
     *
     * @param listContactListsRequest
     * @return A Java Future containing the result of the ListContactLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListContactLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContactLists" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListContactListsResponse> listContactLists(ListContactListsRequest listContactListsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listContactListsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listContactListsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListContactLists");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListContactListsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListContactListsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListContactListsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListContactListsRequest, ListContactListsResponse>()
                            .withOperationName("ListContactLists").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListContactListsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listContactListsRequest));
            CompletableFuture<ListContactListsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the contacts present in a specific contact list.
     * </p>
     *
     * @param listContactsRequest
     * @return A Java Future containing the result of the ListContacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContacts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListContactsResponse> listContacts(ListContactsRequest listContactsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listContactsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listContactsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListContacts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListContactsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListContactsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListContactsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListContactsRequest, ListContactsResponse>()
                            .withOperationName("ListContacts").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListContactsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listContactsRequest));
            CompletableFuture<ListContactsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current Amazon Web Services
     * Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listCustomVerificationEmailTemplatesRequest
     *        Represents a request to list the existing custom verification email templates for your account.
     * @return A Java Future containing the result of the ListCustomVerificationEmailTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListCustomVerificationEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCustomVerificationEmailTemplatesResponse> listCustomVerificationEmailTemplates(
            ListCustomVerificationEmailTemplatesRequest listCustomVerificationEmailTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCustomVerificationEmailTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCustomVerificationEmailTemplatesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomVerificationEmailTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCustomVerificationEmailTemplatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListCustomVerificationEmailTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCustomVerificationEmailTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCustomVerificationEmailTemplatesRequest, ListCustomVerificationEmailTemplatesResponse>()
                            .withOperationName("ListCustomVerificationEmailTemplates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCustomVerificationEmailTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCustomVerificationEmailTemplatesRequest));
            CompletableFuture<ListCustomVerificationEmailTemplatesResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List all of the dedicated IP pools that exist in your Amazon Web Services account in the current Region.
     * </p>
     *
     * @param listDedicatedIpPoolsRequest
     *        A request to obtain a list of dedicated IP pools.
     * @return A Java Future containing the result of the ListDedicatedIpPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDedicatedIpPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDedicatedIpPools" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDedicatedIpPoolsResponse> listDedicatedIpPools(
            ListDedicatedIpPoolsRequest listDedicatedIpPoolsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDedicatedIpPoolsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDedicatedIpPoolsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDedicatedIpPools");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDedicatedIpPoolsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDedicatedIpPoolsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDedicatedIpPoolsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDedicatedIpPoolsRequest, ListDedicatedIpPoolsResponse>()
                            .withOperationName("ListDedicatedIpPools").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDedicatedIpPoolsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDedicatedIpPoolsRequest));
            CompletableFuture<ListDedicatedIpPoolsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For
     * predictive inbox placement tests that are complete, you can use the <code>GetDeliverabilityTestReport</code>
     * operation to view the results.
     * </p>
     *
     * @param listDeliverabilityTestReportsRequest
     *        A request to list all of the predictive inbox placement tests that you've performed.
     * @return A Java Future containing the result of the ListDeliverabilityTestReports operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDeliverabilityTestReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDeliverabilityTestReports"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeliverabilityTestReportsResponse> listDeliverabilityTestReports(
            ListDeliverabilityTestReportsRequest listDeliverabilityTestReportsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDeliverabilityTestReportsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDeliverabilityTestReportsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDeliverabilityTestReports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDeliverabilityTestReportsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDeliverabilityTestReportsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDeliverabilityTestReportsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDeliverabilityTestReportsRequest, ListDeliverabilityTestReportsResponse>()
                            .withOperationName("ListDeliverabilityTestReports").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDeliverabilityTestReportsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDeliverabilityTestReportsRequest));
            CompletableFuture<ListDeliverabilityTestReportsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified
     * time range. This data is available for a domain only if you enabled the Deliverability dashboard for the domain.
     * </p>
     *
     * @param listDomainDeliverabilityCampaignsRequest
     *        Retrieve deliverability data for all the campaigns that used a specific domain to send email during a
     *        specified time range. This data is available for a domain only if you enabled the Deliverability
     *        dashboard.
     * @return A Java Future containing the result of the ListDomainDeliverabilityCampaigns operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDomainDeliverabilityCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDomainDeliverabilityCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDomainDeliverabilityCampaignsResponse> listDomainDeliverabilityCampaigns(
            ListDomainDeliverabilityCampaignsRequest listDomainDeliverabilityCampaignsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDomainDeliverabilityCampaignsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDomainDeliverabilityCampaignsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDomainDeliverabilityCampaigns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDomainDeliverabilityCampaignsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListDomainDeliverabilityCampaignsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDomainDeliverabilityCampaignsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDomainDeliverabilityCampaignsRequest, ListDomainDeliverabilityCampaignsResponse>()
                            .withOperationName("ListDomainDeliverabilityCampaigns").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDomainDeliverabilityCampaignsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDomainDeliverabilityCampaignsRequest));
            CompletableFuture<ListDomainDeliverabilityCampaignsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all of the email identities that are associated with your Amazon Web Services account. An
     * identity can be either an email address or a domain. This operation returns identities that are verified as well
     * as those that aren't. This operation returns identities that are associated with Amazon SES and Amazon Pinpoint.
     * </p>
     *
     * @param listEmailIdentitiesRequest
     *        A request to list all of the email identities associated with your Amazon Web Services account. This list
     *        includes identities that you've already verified, identities that are unverified, and identities that were
     *        verified in the past, but are no longer verified.
     * @return A Java Future containing the result of the ListEmailIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListEmailIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListEmailIdentitiesResponse> listEmailIdentities(
            ListEmailIdentitiesRequest listEmailIdentitiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEmailIdentitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEmailIdentitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEmailIdentities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEmailIdentitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEmailIdentitiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEmailIdentitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEmailIdentitiesRequest, ListEmailIdentitiesResponse>()
                            .withOperationName("ListEmailIdentities").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEmailIdentitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEmailIdentitiesRequest));
            CompletableFuture<ListEmailIdentitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the email templates present in your Amazon SES account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listEmailTemplatesRequest
     *        Represents a request to list the email templates present in your Amazon SES account in the current Amazon
     *        Web Services Region. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the ListEmailTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListEmailTemplatesResponse> listEmailTemplates(ListEmailTemplatesRequest listEmailTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEmailTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEmailTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEmailTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEmailTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEmailTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEmailTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEmailTemplatesRequest, ListEmailTemplatesResponse>()
                            .withOperationName("ListEmailTemplates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEmailTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEmailTemplatesRequest));
            CompletableFuture<ListEmailTemplatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all of the export jobs.
     * </p>
     *
     * @param listExportJobsRequest
     *        Represents a request to list all export jobs with filters.
     * @return A Java Future containing the result of the ListExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListExportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListExportJobsResponse> listExportJobs(ListExportJobsRequest listExportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listExportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listExportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListExportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListExportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListExportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListExportJobsRequest, ListExportJobsResponse>()
                            .withOperationName("ListExportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListExportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listExportJobsRequest));
            CompletableFuture<ListExportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all of the import jobs.
     * </p>
     *
     * @param listImportJobsRequest
     *        Represents a request to list all of the import jobs for a data destination within the specified maximum
     *        number of import jobs.
     * @return A Java Future containing the result of the ListImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListImportJobsResponse> listImportJobs(ListImportJobsRequest listImportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListImportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImportJobsRequest, ListImportJobsResponse>()
                            .withOperationName("ListImportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListImportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listImportJobsRequest));
            CompletableFuture<ListImportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the recommendations present in your Amazon SES account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listRecommendationsRequest
     *        Represents a request to list the existing recommendations for your account.
     * @return A Java Future containing the result of the ListRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListRecommendations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListRecommendationsResponse> listRecommendations(
            ListRecommendationsRequest listRecommendationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecommendations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRecommendationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRecommendationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRecommendationsRequest, ListRecommendationsResponse>()
                            .withOperationName("ListRecommendations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRecommendationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRecommendationsRequest));
            CompletableFuture<ListRecommendationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of email addresses that are on the suppression list for your account.
     * </p>
     *
     * @param listSuppressedDestinationsRequest
     *        A request to obtain a list of email destinations that are on the suppression list for your account.
     * @return A Java Future containing the result of the ListSuppressedDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>InvalidNextTokenException The specified request includes an invalid or expired token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListSuppressedDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListSuppressedDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSuppressedDestinationsResponse> listSuppressedDestinations(
            ListSuppressedDestinationsRequest listSuppressedDestinationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSuppressedDestinationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSuppressedDestinationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSuppressedDestinations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSuppressedDestinationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSuppressedDestinationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSuppressedDestinationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSuppressedDestinationsRequest, ListSuppressedDestinationsResponse>()
                            .withOperationName("ListSuppressedDestinations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSuppressedDestinationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSuppressedDestinationsRequest));
            CompletableFuture<ListSuppressedDestinationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieve a list of the tags (keys and values) that are associated with a specified resource. A <i>tag</i> is a
     * label that you optionally define and associate with a resource. Each tag consists of a required <i>tag
     * key</i> and an optional associated <i>tag value</i>. A tag key is a general label that acts as a category for
     * more specific tag values. A tag value acts as a descriptor within a tag key.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enable or disable the automatic warm-up feature for dedicated IP addresses.
     * </p>
     *
     * @param putAccountDedicatedIpWarmupAttributesRequest
     *        A request to enable or disable the automatic IP address warm-up feature.
     * @return A Java Future containing the result of the PutAccountDedicatedIpWarmupAttributes operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountDedicatedIpWarmupAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountDedicatedIpWarmupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutAccountDedicatedIpWarmupAttributesResponse> putAccountDedicatedIpWarmupAttributes(
            PutAccountDedicatedIpWarmupAttributesRequest putAccountDedicatedIpWarmupAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putAccountDedicatedIpWarmupAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putAccountDedicatedIpWarmupAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutAccountDedicatedIpWarmupAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutAccountDedicatedIpWarmupAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutAccountDedicatedIpWarmupAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutAccountDedicatedIpWarmupAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutAccountDedicatedIpWarmupAttributesRequest, PutAccountDedicatedIpWarmupAttributesResponse>()
                            .withOperationName("PutAccountDedicatedIpWarmupAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutAccountDedicatedIpWarmupAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putAccountDedicatedIpWarmupAttributesRequest));
            CompletableFuture<PutAccountDedicatedIpWarmupAttributesResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update your Amazon SES account details.
     * </p>
     *
     * @param putAccountDetailsRequest
     *        A request to submit new account details.
     * @return A Java Future containing the result of the PutAccountDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConflictException If there is already an ongoing account details update under review.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountDetails" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutAccountDetailsResponse> putAccountDetails(PutAccountDetailsRequest putAccountDetailsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putAccountDetailsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putAccountDetailsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutAccountDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutAccountDetailsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutAccountDetailsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutAccountDetailsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutAccountDetailsRequest, PutAccountDetailsResponse>()
                            .withOperationName("PutAccountDetails").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutAccountDetailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putAccountDetailsRequest));
            CompletableFuture<PutAccountDetailsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enable or disable the ability of your account to send email.
     * </p>
     *
     * @param putAccountSendingAttributesRequest
     *        A request to change the ability of your account to send email.
     * @return A Java Future containing the result of the PutAccountSendingAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountSendingAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountSendingAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutAccountSendingAttributesResponse> putAccountSendingAttributes(
            PutAccountSendingAttributesRequest putAccountSendingAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putAccountSendingAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putAccountSendingAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutAccountSendingAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutAccountSendingAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutAccountSendingAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutAccountSendingAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutAccountSendingAttributesRequest, PutAccountSendingAttributesResponse>()
                            .withOperationName("PutAccountSendingAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutAccountSendingAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putAccountSendingAttributesRequest));
            CompletableFuture<PutAccountSendingAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Change the settings for the account-level suppression list.
     * </p>
     *
     * @param putAccountSuppressionAttributesRequest
     *        A request to change your account's suppression preferences.
     * @return A Java Future containing the result of the PutAccountSuppressionAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountSuppressionAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountSuppressionAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutAccountSuppressionAttributesResponse> putAccountSuppressionAttributes(
            PutAccountSuppressionAttributesRequest putAccountSuppressionAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putAccountSuppressionAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putAccountSuppressionAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutAccountSuppressionAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutAccountSuppressionAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutAccountSuppressionAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutAccountSuppressionAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutAccountSuppressionAttributesRequest, PutAccountSuppressionAttributesResponse>()
                            .withOperationName("PutAccountSuppressionAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutAccountSuppressionAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putAccountSuppressionAttributesRequest));
            CompletableFuture<PutAccountSuppressionAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update your Amazon SES account VDM attributes.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param putAccountVdmAttributesRequest
     *        A request to submit new account VDM attributes.
     * @return A Java Future containing the result of the PutAccountVdmAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountVdmAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountVdmAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutAccountVdmAttributesResponse> putAccountVdmAttributes(
            PutAccountVdmAttributesRequest putAccountVdmAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putAccountVdmAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putAccountVdmAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutAccountVdmAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutAccountVdmAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutAccountVdmAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutAccountVdmAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutAccountVdmAttributesRequest, PutAccountVdmAttributesResponse>()
                            .withOperationName("PutAccountVdmAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutAccountVdmAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putAccountVdmAttributesRequest));
            CompletableFuture<PutAccountVdmAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of
     * dedicated IP addresses for sending specific types of email.
     * </p>
     *
     * @param putConfigurationSetDeliveryOptionsRequest
     *        A request to associate a configuration set with a dedicated IP pool.
     * @return A Java Future containing the result of the PutConfigurationSetDeliveryOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetDeliveryOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetDeliveryOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutConfigurationSetDeliveryOptionsResponse> putConfigurationSetDeliveryOptions(
            PutConfigurationSetDeliveryOptionsRequest putConfigurationSetDeliveryOptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putConfigurationSetDeliveryOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putConfigurationSetDeliveryOptionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutConfigurationSetDeliveryOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutConfigurationSetDeliveryOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutConfigurationSetDeliveryOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutConfigurationSetDeliveryOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutConfigurationSetDeliveryOptionsRequest, PutConfigurationSetDeliveryOptionsResponse>()
                            .withOperationName("PutConfigurationSetDeliveryOptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutConfigurationSetDeliveryOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putConfigurationSetDeliveryOptionsRequest));
            CompletableFuture<PutConfigurationSetDeliveryOptionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enable or disable collection of reputation metrics for emails that you send using a particular configuration set
     * in a specific Amazon Web Services Region.
     * </p>
     *
     * @param putConfigurationSetReputationOptionsRequest
     *        A request to enable or disable tracking of reputation metrics for a configuration set.
     * @return A Java Future containing the result of the PutConfigurationSetReputationOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetReputationOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetReputationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutConfigurationSetReputationOptionsResponse> putConfigurationSetReputationOptions(
            PutConfigurationSetReputationOptionsRequest putConfigurationSetReputationOptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putConfigurationSetReputationOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putConfigurationSetReputationOptionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutConfigurationSetReputationOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutConfigurationSetReputationOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutConfigurationSetReputationOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutConfigurationSetReputationOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutConfigurationSetReputationOptionsRequest, PutConfigurationSetReputationOptionsResponse>()
                            .withOperationName("PutConfigurationSetReputationOptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutConfigurationSetReputationOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putConfigurationSetReputationOptionsRequest));
            CompletableFuture<PutConfigurationSetReputationOptionsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enable or disable email sending for messages that use a particular configuration set in a specific Amazon Web
     * Services Region.
     * </p>
     *
     * @param putConfigurationSetSendingOptionsRequest
     *        A request to enable or disable the ability of Amazon SES to send emails that use a specific configuration
     *        set.
     * @return A Java Future containing the result of the PutConfigurationSetSendingOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetSendingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetSendingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutConfigurationSetSendingOptionsResponse> putConfigurationSetSendingOptions(
            PutConfigurationSetSendingOptionsRequest putConfigurationSetSendingOptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putConfigurationSetSendingOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putConfigurationSetSendingOptionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutConfigurationSetSendingOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutConfigurationSetSendingOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutConfigurationSetSendingOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutConfigurationSetSendingOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutConfigurationSetSendingOptionsRequest, PutConfigurationSetSendingOptionsResponse>()
                            .withOperationName("PutConfigurationSetSendingOptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutConfigurationSetSendingOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putConfigurationSetSendingOptionsRequest));
            CompletableFuture<PutConfigurationSetSendingOptionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Specify the account suppression list preferences for a configuration set.
     * </p>
     *
     * @param putConfigurationSetSuppressionOptionsRequest
     *        A request to change the account suppression list preferences for a specific configuration set.
     * @return A Java Future containing the result of the PutConfigurationSetSuppressionOptions operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetSuppressionOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetSuppressionOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutConfigurationSetSuppressionOptionsResponse> putConfigurationSetSuppressionOptions(
            PutConfigurationSetSuppressionOptionsRequest putConfigurationSetSuppressionOptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putConfigurationSetSuppressionOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putConfigurationSetSuppressionOptionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutConfigurationSetSuppressionOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutConfigurationSetSuppressionOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutConfigurationSetSuppressionOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutConfigurationSetSuppressionOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutConfigurationSetSuppressionOptionsRequest, PutConfigurationSetSuppressionOptionsResponse>()
                            .withOperationName("PutConfigurationSetSuppressionOptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutConfigurationSetSuppressionOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putConfigurationSetSuppressionOptionsRequest));
            CompletableFuture<PutConfigurationSetSuppressionOptionsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Specify a custom domain to use for open and click tracking elements in email that you send.
     * </p>
     *
     * @param putConfigurationSetTrackingOptionsRequest
     *        A request to add a custom domain for tracking open and click events to a configuration set.
     * @return A Java Future containing the result of the PutConfigurationSetTrackingOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetTrackingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutConfigurationSetTrackingOptionsResponse> putConfigurationSetTrackingOptions(
            PutConfigurationSetTrackingOptionsRequest putConfigurationSetTrackingOptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putConfigurationSetTrackingOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putConfigurationSetTrackingOptionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutConfigurationSetTrackingOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutConfigurationSetTrackingOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutConfigurationSetTrackingOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutConfigurationSetTrackingOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutConfigurationSetTrackingOptionsRequest, PutConfigurationSetTrackingOptionsResponse>()
                            .withOperationName("PutConfigurationSetTrackingOptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutConfigurationSetTrackingOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putConfigurationSetTrackingOptionsRequest));
            CompletableFuture<PutConfigurationSetTrackingOptionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Specify VDM preferences for email that you send using the configuration set.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param putConfigurationSetVdmOptionsRequest
     *        A request to add specific VDM settings to a configuration set.
     * @return A Java Future containing the result of the PutConfigurationSetVdmOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetVdmOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetVdmOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutConfigurationSetVdmOptionsResponse> putConfigurationSetVdmOptions(
            PutConfigurationSetVdmOptionsRequest putConfigurationSetVdmOptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putConfigurationSetVdmOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putConfigurationSetVdmOptionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutConfigurationSetVdmOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutConfigurationSetVdmOptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutConfigurationSetVdmOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutConfigurationSetVdmOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutConfigurationSetVdmOptionsRequest, PutConfigurationSetVdmOptionsResponse>()
                            .withOperationName("PutConfigurationSetVdmOptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutConfigurationSetVdmOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putConfigurationSetVdmOptionsRequest));
            CompletableFuture<PutConfigurationSetVdmOptionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Move a dedicated IP address to an existing dedicated IP pool.
     * </p>
     * <note>
     * <p>
     * The dedicated IP address that you specify must already exist, and must be associated with your Amazon Web
     * Services account.
     * </p>
     * <p>
     * The dedicated IP pool you specify must already exist. You can create a new pool by using the
     * <code>CreateDedicatedIpPool</code> operation.
     * </p>
     * </note>
     *
     * @param putDedicatedIpInPoolRequest
     *        A request to move a dedicated IP address to a dedicated IP pool.
     * @return A Java Future containing the result of the PutDedicatedIpInPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDedicatedIpInPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpInPool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutDedicatedIpInPoolResponse> putDedicatedIpInPool(
            PutDedicatedIpInPoolRequest putDedicatedIpInPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putDedicatedIpInPoolRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putDedicatedIpInPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDedicatedIpInPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutDedicatedIpInPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutDedicatedIpInPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutDedicatedIpInPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutDedicatedIpInPoolRequest, PutDedicatedIpInPoolResponse>()
                            .withOperationName("PutDedicatedIpInPool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutDedicatedIpInPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putDedicatedIpInPoolRequest));
            CompletableFuture<PutDedicatedIpInPoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Used to convert a dedicated IP pool to a different scaling mode.
     * </p>
     * <note>
     * <p>
     * <code>MANAGED</code> pools cannot be converted to <code>STANDARD</code> scaling mode.
     * </p>
     * </note>
     *
     * @param putDedicatedIpPoolScalingAttributesRequest
     *        A request to convert a dedicated IP pool to a different scaling mode.
     * @return A Java Future containing the result of the PutDedicatedIpPoolScalingAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDedicatedIpPoolScalingAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpPoolScalingAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutDedicatedIpPoolScalingAttributesResponse> putDedicatedIpPoolScalingAttributes(
            PutDedicatedIpPoolScalingAttributesRequest putDedicatedIpPoolScalingAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putDedicatedIpPoolScalingAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putDedicatedIpPoolScalingAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDedicatedIpPoolScalingAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutDedicatedIpPoolScalingAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutDedicatedIpPoolScalingAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutDedicatedIpPoolScalingAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutDedicatedIpPoolScalingAttributesRequest, PutDedicatedIpPoolScalingAttributesResponse>()
                            .withOperationName("PutDedicatedIpPoolScalingAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutDedicatedIpPoolScalingAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putDedicatedIpPoolScalingAttributesRequest));
            CompletableFuture<PutDedicatedIpPoolScalingAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p/>
     *
     * @param putDedicatedIpWarmupAttributesRequest
     *        A request to change the warm-up attributes for a dedicated IP address. This operation is useful when you
     *        want to resume the warm-up process for an existing IP address.
     * @return A Java Future containing the result of the PutDedicatedIpWarmupAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li> <li>
     *         TooManyRequestsException Too many requests have been made to the operation.</li> <li>BadRequestException
     *         The input you provided is invalid.</li> <li>SdkException Base class for all exceptions that can be thrown
     *         by the SDK (both service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If
     *         any client side error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>
     *         SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance of
     *         this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDedicatedIpWarmupAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpWarmupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutDedicatedIpWarmupAttributesResponse> putDedicatedIpWarmupAttributes(
            PutDedicatedIpWarmupAttributesRequest putDedicatedIpWarmupAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putDedicatedIpWarmupAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putDedicatedIpWarmupAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDedicatedIpWarmupAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutDedicatedIpWarmupAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutDedicatedIpWarmupAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutDedicatedIpWarmupAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutDedicatedIpWarmupAttributesRequest, PutDedicatedIpWarmupAttributesResponse>()
                            .withOperationName("PutDedicatedIpWarmupAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutDedicatedIpWarmupAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putDedicatedIpWarmupAttributesRequest));
            CompletableFuture<PutDedicatedIpWarmupAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain access to
     * reputation, deliverability, and other metrics for the domains that you use to send email. You also gain the
     * ability to perform predictive inbox placement tests.
     * </p>
     * <p>
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees
     * that you accrue by using Amazon SES and other Amazon Web Services services. For more information about the
     * features and cost of a Deliverability dashboard subscription, see <a
     * href="http://aws.amazon.com/ses/pricing/">Amazon SES Pricing</a>.
     * </p>
     *
     * @param putDeliverabilityDashboardOptionRequest
     *        Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain
     *        access to reputation, deliverability, and other metrics for the domains that you use to send email using
     *        Amazon SES API v2. You also gain the ability to perform predictive inbox placement tests.</p>
     *        <p>
     *        When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other
     *        fees that you accrue by using Amazon SES and other Amazon Web Services services. For more information
     *        about the features and cost of a Deliverability dashboard subscription, see <a
     *        href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.
     * @return A Java Future containing the result of the PutDeliverabilityDashboardOption operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li> <li>
     *         NotFoundException The resource you attempted to access doesn't exist.</li> <li>TooManyRequestsException
     *         Too many requests have been made to the operation.</li> <li>LimitExceededException There are too many
     *         instances of the specified resource type.</li> <li>BadRequestException The input you provided is invalid.
     *         </li> <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs
     *         such as an IO related failure, failure to get credentials, etc.</li> <li>SesV2Exception Base class for
     *         all service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDeliverabilityDashboardOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDeliverabilityDashboardOption"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutDeliverabilityDashboardOptionResponse> putDeliverabilityDashboardOption(
            PutDeliverabilityDashboardOptionRequest putDeliverabilityDashboardOptionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putDeliverabilityDashboardOptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putDeliverabilityDashboardOptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDeliverabilityDashboardOption");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutDeliverabilityDashboardOptionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutDeliverabilityDashboardOptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutDeliverabilityDashboardOptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutDeliverabilityDashboardOptionRequest, PutDeliverabilityDashboardOptionResponse>()
                            .withOperationName("PutDeliverabilityDashboardOption").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutDeliverabilityDashboardOptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putDeliverabilityDashboardOptionRequest));
            CompletableFuture<PutDeliverabilityDashboardOptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Used to associate a configuration set with an email identity.
     * </p>
     *
     * @param putEmailIdentityConfigurationSetAttributesRequest
     *        A request to associate a configuration set with an email identity.
     * @return A Java Future containing the result of the PutEmailIdentityConfigurationSetAttributes operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityConfigurationSetAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityConfigurationSetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutEmailIdentityConfigurationSetAttributesResponse> putEmailIdentityConfigurationSetAttributes(
            PutEmailIdentityConfigurationSetAttributesRequest putEmailIdentityConfigurationSetAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                putEmailIdentityConfigurationSetAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putEmailIdentityConfigurationSetAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEmailIdentityConfigurationSetAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutEmailIdentityConfigurationSetAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutEmailIdentityConfigurationSetAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutEmailIdentityConfigurationSetAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutEmailIdentityConfigurationSetAttributesRequest, PutEmailIdentityConfigurationSetAttributesResponse>()
                            .withOperationName("PutEmailIdentityConfigurationSetAttributes")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutEmailIdentityConfigurationSetAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putEmailIdentityConfigurationSetAttributesRequest));
            CompletableFuture<PutEmailIdentityConfigurationSetAttributesResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Used to enable or disable DKIM authentication for an email identity.
     * </p>
     *
     * @param putEmailIdentityDkimAttributesRequest
     *        A request to enable or disable DKIM signing of email that you send from an email identity.
     * @return A Java Future containing the result of the PutEmailIdentityDkimAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityDkimAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityDkimAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutEmailIdentityDkimAttributesResponse> putEmailIdentityDkimAttributes(
            PutEmailIdentityDkimAttributesRequest putEmailIdentityDkimAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putEmailIdentityDkimAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putEmailIdentityDkimAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEmailIdentityDkimAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutEmailIdentityDkimAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutEmailIdentityDkimAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutEmailIdentityDkimAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutEmailIdentityDkimAttributesRequest, PutEmailIdentityDkimAttributesResponse>()
                            .withOperationName("PutEmailIdentityDkimAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutEmailIdentityDkimAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putEmailIdentityDkimAttributesRequest));
            CompletableFuture<PutEmailIdentityDkimAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Used to configure or change the DKIM authentication settings for an email domain identity. You can use this
     * operation to do any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Update the signing attributes for an identity that uses Bring Your Own DKIM (BYODKIM).
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the key length that should be used for Easy DKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using no DKIM authentication to using Easy DKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using no DKIM authentication to using BYODKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using Easy DKIM to using BYODKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using BYODKIM to using Easy DKIM.
     * </p>
     * </li>
     * </ul>
     *
     * @param putEmailIdentityDkimSigningAttributesRequest
     *        A request to change the DKIM attributes for an email identity.
     * @return A Java Future containing the result of the PutEmailIdentityDkimSigningAttributes operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityDkimSigningAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityDkimSigningAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutEmailIdentityDkimSigningAttributesResponse> putEmailIdentityDkimSigningAttributes(
            PutEmailIdentityDkimSigningAttributesRequest putEmailIdentityDkimSigningAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putEmailIdentityDkimSigningAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putEmailIdentityDkimSigningAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEmailIdentityDkimSigningAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutEmailIdentityDkimSigningAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutEmailIdentityDkimSigningAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutEmailIdentityDkimSigningAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutEmailIdentityDkimSigningAttributesRequest, PutEmailIdentityDkimSigningAttributesResponse>()
                            .withOperationName("PutEmailIdentityDkimSigningAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutEmailIdentityDkimSigningAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putEmailIdentityDkimSigningAttributesRequest));
            CompletableFuture<PutEmailIdentityDkimSigningAttributesResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an
     * identity is used to send an email that results in a bounce or complaint event.
     * </p>
     * <p>
     * If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These
     * notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original
     * email.
     * </p>
     * <p>
     * You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for
     * receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an
     * email notification when these events occur (even if this setting is disabled).
     * </p>
     *
     * @param putEmailIdentityFeedbackAttributesRequest
     *        A request to set the attributes that control how bounce and complaint events are processed.
     * @return A Java Future containing the result of the PutEmailIdentityFeedbackAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityFeedbackAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityFeedbackAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutEmailIdentityFeedbackAttributesResponse> putEmailIdentityFeedbackAttributes(
            PutEmailIdentityFeedbackAttributesRequest putEmailIdentityFeedbackAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putEmailIdentityFeedbackAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putEmailIdentityFeedbackAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEmailIdentityFeedbackAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutEmailIdentityFeedbackAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutEmailIdentityFeedbackAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutEmailIdentityFeedbackAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutEmailIdentityFeedbackAttributesRequest, PutEmailIdentityFeedbackAttributesResponse>()
                            .withOperationName("PutEmailIdentityFeedbackAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutEmailIdentityFeedbackAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putEmailIdentityFeedbackAttributesRequest));
            CompletableFuture<PutEmailIdentityFeedbackAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     * </p>
     *
     * @param putEmailIdentityMailFromAttributesRequest
     *        A request to configure the custom MAIL FROM domain for a verified identity.
     * @return A Java Future containing the result of the PutEmailIdentityMailFromAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityMailFromAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityMailFromAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutEmailIdentityMailFromAttributesResponse> putEmailIdentityMailFromAttributes(
            PutEmailIdentityMailFromAttributesRequest putEmailIdentityMailFromAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putEmailIdentityMailFromAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putEmailIdentityMailFromAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEmailIdentityMailFromAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutEmailIdentityMailFromAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutEmailIdentityMailFromAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutEmailIdentityMailFromAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutEmailIdentityMailFromAttributesRequest, PutEmailIdentityMailFromAttributesResponse>()
                            .withOperationName("PutEmailIdentityMailFromAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutEmailIdentityMailFromAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putEmailIdentityMailFromAttributesRequest));
            CompletableFuture<PutEmailIdentityMailFromAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds an email address to the suppression list for your account.
     * </p>
     *
     * @param putSuppressedDestinationRequest
     *        A request to add an email destination to the suppression list for your account.
     * @return A Java Future containing the result of the PutSuppressedDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutSuppressedDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutSuppressedDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutSuppressedDestinationResponse> putSuppressedDestination(
            PutSuppressedDestinationRequest putSuppressedDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putSuppressedDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putSuppressedDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutSuppressedDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutSuppressedDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutSuppressedDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutSuppressedDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutSuppressedDestinationRequest, PutSuppressedDestinationResponse>()
                            .withOperationName("PutSuppressedDestination").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutSuppressedDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putSuppressedDestinationRequest));
            CompletableFuture<PutSuppressedDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Composes an email message to multiple destinations.
     * </p>
     *
     * @param sendBulkEmailRequest
     *        Represents a request to send email messages to multiple destinations using Amazon SES. For more
     *        information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SendBulkEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>AccountSuspendedException The message can't be sent because the account's ability to send email has
     *         been permanently restricted.</li>
     *         <li>SendingPausedException The message can't be sent because the account's ability to send email is
     *         currently paused.</li>
     *         <li>MessageRejectedException The message can't be sent because it contains invalid content.</li>
     *         <li>MailFromDomainNotVerifiedException The message can't be sent because the sending domain isn't
     *         verified.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.SendBulkEmail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendBulkEmail" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SendBulkEmailResponse> sendBulkEmail(SendBulkEmailRequest sendBulkEmailRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendBulkEmailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendBulkEmailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendBulkEmail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendBulkEmailResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SendBulkEmailResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendBulkEmailResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendBulkEmailRequest, SendBulkEmailResponse>()
                            .withOperationName("SendBulkEmail").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SendBulkEmailRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(sendBulkEmailRequest));
            CompletableFuture<SendBulkEmailResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds an email address to the list of identities for your Amazon SES account in the current Amazon Web Services
     * Region and attempts to verify it. As a result of executing this operation, a customized verification email is
     * sent to the specified address.
     * </p>
     * <p>
     * To use this operation, you must first create a custom verification email template. For more information about
     * creating and using custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param sendCustomVerificationEmailRequest
     *        Represents a request to send a custom verification email to a specified recipient.
     * @return A Java Future containing the result of the SendCustomVerificationEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>MessageRejectedException The message can't be sent because it contains invalid content.</li>
     *         <li>SendingPausedException The message can't be sent because the account's ability to send email is
     *         currently paused.</li>
     *         <li>MailFromDomainNotVerifiedException The message can't be sent because the sending domain isn't
     *         verified.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.SendCustomVerificationEmail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendCustomVerificationEmail"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SendCustomVerificationEmailResponse> sendCustomVerificationEmail(
            SendCustomVerificationEmailRequest sendCustomVerificationEmailRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendCustomVerificationEmailRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendCustomVerificationEmailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendCustomVerificationEmail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendCustomVerificationEmailResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SendCustomVerificationEmailResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendCustomVerificationEmailResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendCustomVerificationEmailRequest, SendCustomVerificationEmailResponse>()
                            .withOperationName("SendCustomVerificationEmail").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SendCustomVerificationEmailRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(sendCustomVerificationEmailRequest));
            CompletableFuture<SendCustomVerificationEmailResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sends an email message. You can use the Amazon SES API v2 to send the following types of messages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Simple</b> – A standard email message. When you create this type of message, you specify the sender, the
     * recipient, and the message body, and Amazon SES assembles the message for you.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Raw</b> – A raw, MIME-formatted email message. When you send this type of email, you have to specify all of
     * the message headers, as well as the message body. You can use this message type to send messages that contain
     * attachments. The message that you specify has to be a valid MIME message.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Templated</b> – A message that contains personalization tags. When you send this type of email, Amazon SES API
     * v2 automatically replaces the tags with values that you specify.
     * </p>
     * </li>
     * </ul>
     *
     * @param sendEmailRequest
     *        Represents a request to send a single formatted email using Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-formatted.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SendEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>AccountSuspendedException The message can't be sent because the account's ability to send email has
     *         been permanently restricted.</li>
     *         <li>SendingPausedException The message can't be sent because the account's ability to send email is
     *         currently paused.</li>
     *         <li>MessageRejectedException The message can't be sent because it contains invalid content.</li>
     *         <li>MailFromDomainNotVerifiedException The message can't be sent because the sending domain isn't
     *         verified.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.SendEmail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendEmail" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SendEmailResponse> sendEmail(SendEmailRequest sendEmailRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendEmailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendEmailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendEmail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendEmailResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SendEmailResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendEmailResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendEmailRequest, SendEmailResponse>().withOperationName("SendEmail")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SendEmailRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(sendEmailRequest));
            CompletableFuture<SendEmailResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Add one or more tags (keys and values) to a specified resource. A <i>tag</i> is a label that you optionally
     * define and associate with a resource. Tags can help you categorize and manage resources in different ways, such
     * as by purpose, owner, environment, or other criteria. A resource can have as many as 50 tags.
     * </p>
     * <p>
     * Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>, both of which you define. A
     * tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor
     * within a tag key.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param testRenderEmailTemplateRequest
     *        &gt;Represents a request to create a preview of the MIME content of an email when provided with a template
     *        and a set of replacement data.
     * @return A Java Future containing the result of the TestRenderEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.TestRenderEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/TestRenderEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<TestRenderEmailTemplateResponse> testRenderEmailTemplate(
            TestRenderEmailTemplateRequest testRenderEmailTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(testRenderEmailTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testRenderEmailTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestRenderEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TestRenderEmailTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TestRenderEmailTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TestRenderEmailTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TestRenderEmailTemplateRequest, TestRenderEmailTemplateResponse>()
                            .withOperationName("TestRenderEmailTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TestRenderEmailTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(testRenderEmailTemplateRequest));
            CompletableFuture<TestRenderEmailTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Remove one or more tags (keys and values) from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update the configuration of an event destination for a configuration set.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis
     * Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     *
     * @param updateConfigurationSetEventDestinationRequest
     *        A request to change the settings for an event destination for a configuration set.
     * @return A Java Future containing the result of the UpdateConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateConfigurationSetEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateConfigurationSetEventDestinationResponse> updateConfigurationSetEventDestination(
            UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateConfigurationSetEventDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateConfigurationSetEventDestinationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConfigurationSetEventDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateConfigurationSetEventDestinationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateConfigurationSetEventDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateConfigurationSetEventDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateConfigurationSetEventDestinationRequest, UpdateConfigurationSetEventDestinationResponse>()
                            .withOperationName("UpdateConfigurationSetEventDestination").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateConfigurationSetEventDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateConfigurationSetEventDestinationRequest));
            CompletableFuture<UpdateConfigurationSetEventDestinationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a contact's preferences for a list.
     * </p>
     * <note>
     * <p>
     * You must specify all existing topic preferences in the <code>TopicPreferences</code> object, not just the ones
     * that need updating; otherwise, all your existing preferences will be removed.
     * </p>
     * </note>
     *
     * @param updateContactRequest
     * @return A Java Future containing the result of the UpdateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateContact" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateContactResponse> updateContact(UpdateContactRequest updateContactRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateContactRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateContactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateContact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateContactResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateContactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateContactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateContactRequest, UpdateContactResponse>()
                            .withOperationName("UpdateContact").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateContactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateContactRequest));
            CompletableFuture<UpdateContactResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates contact list metadata. This operation does a complete replacement.
     * </p>
     *
     * @param updateContactListRequest
     * @return A Java Future containing the result of the UpdateContactList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateContactList" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateContactListResponse> updateContactList(UpdateContactListRequest updateContactListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateContactListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateContactListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateContactList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateContactListResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateContactListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateContactListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateContactListRequest, UpdateContactListResponse>()
                            .withOperationName("UpdateContactList").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateContactListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateContactListRequest));
            CompletableFuture<UpdateContactListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateCustomVerificationEmailTemplateRequest
     *        Represents a request to update an existing custom verification email template.
     * @return A Java Future containing the result of the UpdateCustomVerificationEmailTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCustomVerificationEmailTemplateResponse> updateCustomVerificationEmailTemplate(
            UpdateCustomVerificationEmailTemplateRequest updateCustomVerificationEmailTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCustomVerificationEmailTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCustomVerificationEmailTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCustomVerificationEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCustomVerificationEmailTemplateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateCustomVerificationEmailTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCustomVerificationEmailTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCustomVerificationEmailTemplateRequest, UpdateCustomVerificationEmailTemplateResponse>()
                            .withOperationName("UpdateCustomVerificationEmailTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCustomVerificationEmailTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCustomVerificationEmailTemplateRequest));
            CompletableFuture<UpdateCustomVerificationEmailTemplateResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified sending authorization policy for the given identity (an email address or a domain). This
     * API returns successfully even if a policy with the specified name does not exist.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateEmailIdentityPolicyRequest
     *        Represents a request to update a sending authorization policy for an identity. Sending authorization is an
     *        Amazon SES feature that enables you to authorize other senders to use your identities. For information,
     *        see the <a href=
     *        "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html"
     *        >Amazon SES Developer Guide</a>.
     * @return A Java Future containing the result of the UpdateEmailIdentityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateEmailIdentityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateEmailIdentityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEmailIdentityPolicyResponse> updateEmailIdentityPolicy(
            UpdateEmailIdentityPolicyRequest updateEmailIdentityPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEmailIdentityPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEmailIdentityPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEmailIdentityPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEmailIdentityPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEmailIdentityPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEmailIdentityPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEmailIdentityPolicyRequest, UpdateEmailIdentityPolicyResponse>()
                            .withOperationName("UpdateEmailIdentityPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateEmailIdentityPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateEmailIdentityPolicyRequest));
            CompletableFuture<UpdateEmailIdentityPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateEmailTemplateRequest
     *        Represents a request to update an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the UpdateEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEmailTemplateResponse> updateEmailTemplate(
            UpdateEmailTemplateRequest updateEmailTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEmailTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEmailTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEmailTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEmailTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEmailTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEmailTemplateRequest, UpdateEmailTemplateResponse>()
                            .withOperationName("UpdateEmailTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateEmailTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateEmailTemplateRequest));
            CompletableFuture<UpdateEmailTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final SesV2ServiceClientConfiguration serviceClientConfiguration() {
        return new SesV2ServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(SesV2Exception::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                                .exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MessageRejected")
                                .exceptionBuilderSupplier(MessageRejectedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNextTokenException")
                                .exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccountSuspendedException")
                                .exceptionBuilderSupplier(AccountSuspendedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AlreadyExistsException")
                                .exceptionBuilderSupplier(AlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServiceErrorException")
                                .exceptionBuilderSupplier(InternalServiceErrorException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException")
                                .exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SendingPausedException")
                                .exceptionBuilderSupplier(SendingPausedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        SesV2ServiceClientConfigurationBuilder serviceConfigBuilder = new SesV2ServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
