/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.DomainIspPlacement;
import software.amazon.awssdk.services.sesv2.model.DomainIspPlacementsCopier;
import software.amazon.awssdk.services.sesv2.model.VolumeStatistics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OverallVolume
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OverallVolume> {
    private static final SdkField<VolumeStatistics> VOLUME_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VolumeStatistics").getter(OverallVolume.getter(OverallVolume::volumeStatistics)).setter(OverallVolume.setter(Builder::volumeStatistics)).constructor(VolumeStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeStatistics").build()}).build();
    private static final SdkField<Double> READ_RATE_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ReadRatePercent").getter(OverallVolume.getter(OverallVolume::readRatePercent)).setter(OverallVolume.setter(Builder::readRatePercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadRatePercent").build()}).build();
    private static final SdkField<List<DomainIspPlacement>> DOMAIN_ISP_PLACEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainIspPlacements").getter(OverallVolume.getter(OverallVolume::domainIspPlacements)).setter(OverallVolume.setter(Builder::domainIspPlacements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIspPlacements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainIspPlacement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_STATISTICS_FIELD, READ_RATE_PERCENT_FIELD, DOMAIN_ISP_PLACEMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VolumeStatistics", VOLUME_STATISTICS_FIELD);
            this.put("ReadRatePercent", READ_RATE_PERCENT_FIELD);
            this.put("DomainIspPlacements", DOMAIN_ISP_PLACEMENTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final VolumeStatistics volumeStatistics;
    private final Double readRatePercent;
    private final List<DomainIspPlacement> domainIspPlacements;

    private OverallVolume(BuilderImpl builder) {
        this.volumeStatistics = builder.volumeStatistics;
        this.readRatePercent = builder.readRatePercent;
        this.domainIspPlacements = builder.domainIspPlacements;
    }

    public final VolumeStatistics volumeStatistics() {
        return this.volumeStatistics;
    }

    public final Double readRatePercent() {
        return this.readRatePercent;
    }

    public final boolean hasDomainIspPlacements() {
        return this.domainIspPlacements != null && !(this.domainIspPlacements instanceof SdkAutoConstructList);
    }

    public final List<DomainIspPlacement> domainIspPlacements() {
        return this.domainIspPlacements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.readRatePercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainIspPlacements() ? this.domainIspPlacements() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverallVolume)) {
            return false;
        }
        OverallVolume other = (OverallVolume)obj;
        return Objects.equals(this.volumeStatistics(), other.volumeStatistics()) && Objects.equals(this.readRatePercent(), other.readRatePercent()) && this.hasDomainIspPlacements() == other.hasDomainIspPlacements() && Objects.equals(this.domainIspPlacements(), other.domainIspPlacements());
    }

    public final String toString() {
        return ToString.builder((String)"OverallVolume").add("VolumeStatistics", (Object)this.volumeStatistics()).add("ReadRatePercent", (Object)this.readRatePercent()).add("DomainIspPlacements", this.hasDomainIspPlacements() ? this.domainIspPlacements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeStatistics": {
                return Optional.ofNullable(clazz.cast(this.volumeStatistics()));
            }
            case "ReadRatePercent": {
                return Optional.ofNullable(clazz.cast(this.readRatePercent()));
            }
            case "DomainIspPlacements": {
                return Optional.ofNullable(clazz.cast(this.domainIspPlacements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OverallVolume, T> g) {
        return obj -> g.apply((OverallVolume)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VolumeStatistics volumeStatistics;
        private Double readRatePercent;
        private List<DomainIspPlacement> domainIspPlacements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OverallVolume model) {
            this.volumeStatistics(model.volumeStatistics);
            this.readRatePercent(model.readRatePercent);
            this.domainIspPlacements(model.domainIspPlacements);
        }

        public final VolumeStatistics.Builder getVolumeStatistics() {
            return this.volumeStatistics != null ? this.volumeStatistics.toBuilder() : null;
        }

        public final void setVolumeStatistics(VolumeStatistics.BuilderImpl volumeStatistics) {
            this.volumeStatistics = volumeStatistics != null ? volumeStatistics.build() : null;
        }

        @Override
        public final Builder volumeStatistics(VolumeStatistics volumeStatistics) {
            this.volumeStatistics = volumeStatistics;
            return this;
        }

        public final Double getReadRatePercent() {
            return this.readRatePercent;
        }

        public final void setReadRatePercent(Double readRatePercent) {
            this.readRatePercent = readRatePercent;
        }

        @Override
        public final Builder readRatePercent(Double readRatePercent) {
            this.readRatePercent = readRatePercent;
            return this;
        }

        public final List<DomainIspPlacement.Builder> getDomainIspPlacements() {
            List<DomainIspPlacement.Builder> result = DomainIspPlacementsCopier.copyToBuilder(this.domainIspPlacements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainIspPlacements(Collection<DomainIspPlacement.BuilderImpl> domainIspPlacements) {
            this.domainIspPlacements = DomainIspPlacementsCopier.copyFromBuilder(domainIspPlacements);
        }

        @Override
        public final Builder domainIspPlacements(Collection<DomainIspPlacement> domainIspPlacements) {
            this.domainIspPlacements = DomainIspPlacementsCopier.copy(domainIspPlacements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainIspPlacements(DomainIspPlacement ... domainIspPlacements) {
            this.domainIspPlacements(Arrays.asList(domainIspPlacements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainIspPlacements(Consumer<DomainIspPlacement.Builder> ... domainIspPlacements) {
            this.domainIspPlacements(Stream.of(domainIspPlacements).map(c -> (DomainIspPlacement)((DomainIspPlacement.Builder)DomainIspPlacement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public OverallVolume build() {
            return new OverallVolume(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OverallVolume> {
        public Builder volumeStatistics(VolumeStatistics var1);

        default public Builder volumeStatistics(Consumer<VolumeStatistics.Builder> volumeStatistics) {
            return this.volumeStatistics((VolumeStatistics)((VolumeStatistics.Builder)VolumeStatistics.builder().applyMutation(volumeStatistics)).build());
        }

        public Builder readRatePercent(Double var1);

        public Builder domainIspPlacements(Collection<DomainIspPlacement> var1);

        public Builder domainIspPlacements(DomainIspPlacement ... var1);

        public Builder domainIspPlacements(Consumer<DomainIspPlacement.Builder> ... var1);
    }
}

