/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to list all export jobs with filters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListExportJobsRequest extends SesV2Request implements
        ToCopyableBuilder<ListExportJobsRequest.Builder, ListExportJobsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListExportJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(ListExportJobsRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final SdkField<String> EXPORT_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportSourceType").getter(getter(ListExportJobsRequest::exportSourceTypeAsString))
            .setter(setter(Builder::exportSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportSourceType").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(ListExportJobsRequest::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PAGE_SIZE_FIELD, EXPORT_SOURCE_TYPE_FIELD, JOB_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer pageSize;

    private final String exportSourceType;

    private final String jobStatus;

    private ListExportJobsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
        this.exportSourceType = builder.exportSourceType;
        this.jobStatus = builder.jobStatus;
    }

    /**
     * <p>
     * The pagination token returned from a previous call to <code>ListExportJobs</code> to indicate the position in the
     * list of export jobs.
     * </p>
     * 
     * @return The pagination token returned from a previous call to <code>ListExportJobs</code> to indicate the
     *         position in the list of export jobs.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Maximum number of export jobs to return at once. Use this parameter to paginate results. If additional export
     * jobs exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the
     * <code>NextToken</code> value in subsequent calls to <code>ListExportJobs</code> to retrieve additional export
     * jobs.
     * </p>
     * 
     * @return Maximum number of export jobs to return at once. Use this parameter to paginate results. If additional
     *         export jobs exist beyond the specified limit, the <code>NextToken</code> element is sent in the response.
     *         Use the <code>NextToken</code> value in subsequent calls to <code>ListExportJobs</code> to retrieve
     *         additional export jobs.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * A value used to list export jobs that have a certain <code>ExportSourceType</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportSourceType}
     * will return {@link ExportSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportSourceTypeAsString}.
     * </p>
     * 
     * @return A value used to list export jobs that have a certain <code>ExportSourceType</code>.
     * @see ExportSourceType
     */
    public final ExportSourceType exportSourceType() {
        return ExportSourceType.fromValue(exportSourceType);
    }

    /**
     * <p>
     * A value used to list export jobs that have a certain <code>ExportSourceType</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportSourceType}
     * will return {@link ExportSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportSourceTypeAsString}.
     * </p>
     * 
     * @return A value used to list export jobs that have a certain <code>ExportSourceType</code>.
     * @see ExportSourceType
     */
    public final String exportSourceTypeAsString() {
        return exportSourceType;
    }

    /**
     * <p>
     * A value used to list export jobs that have a certain <code>JobStatus</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return A value used to list export jobs that have a certain <code>JobStatus</code>.
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * A value used to list export jobs that have a certain <code>JobStatus</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return A value used to list export jobs that have a certain <code>JobStatus</code>.
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(exportSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExportJobsRequest)) {
            return false;
        }
        ListExportJobsRequest other = (ListExportJobsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(pageSize(), other.pageSize())
                && Objects.equals(exportSourceTypeAsString(), other.exportSourceTypeAsString())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListExportJobsRequest").add("NextToken", nextToken()).add("PageSize", pageSize())
                .add("ExportSourceType", exportSourceTypeAsString()).add("JobStatus", jobStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "ExportSourceType":
            return Optional.ofNullable(clazz.cast(exportSourceTypeAsString()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("PageSize", PAGE_SIZE_FIELD);
        map.put("ExportSourceType", EXPORT_SOURCE_TYPE_FIELD);
        map.put("JobStatus", JOB_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListExportJobsRequest, T> g) {
        return obj -> g.apply((ListExportJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListExportJobsRequest> {
        /**
         * <p>
         * The pagination token returned from a previous call to <code>ListExportJobs</code> to indicate the position in
         * the list of export jobs.
         * </p>
         * 
         * @param nextToken
         *        The pagination token returned from a previous call to <code>ListExportJobs</code> to indicate the
         *        position in the list of export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Maximum number of export jobs to return at once. Use this parameter to paginate results. If additional export
         * jobs exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the
         * <code>NextToken</code> value in subsequent calls to <code>ListExportJobs</code> to retrieve additional export
         * jobs.
         * </p>
         * 
         * @param pageSize
         *        Maximum number of export jobs to return at once. Use this parameter to paginate results. If additional
         *        export jobs exist beyond the specified limit, the <code>NextToken</code> element is sent in the
         *        response. Use the <code>NextToken</code> value in subsequent calls to <code>ListExportJobs</code> to
         *        retrieve additional export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * A value used to list export jobs that have a certain <code>ExportSourceType</code>.
         * </p>
         * 
         * @param exportSourceType
         *        A value used to list export jobs that have a certain <code>ExportSourceType</code>.
         * @see ExportSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportSourceType
         */
        Builder exportSourceType(String exportSourceType);

        /**
         * <p>
         * A value used to list export jobs that have a certain <code>ExportSourceType</code>.
         * </p>
         * 
         * @param exportSourceType
         *        A value used to list export jobs that have a certain <code>ExportSourceType</code>.
         * @see ExportSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportSourceType
         */
        Builder exportSourceType(ExportSourceType exportSourceType);

        /**
         * <p>
         * A value used to list export jobs that have a certain <code>JobStatus</code>.
         * </p>
         * 
         * @param jobStatus
         *        A value used to list export jobs that have a certain <code>JobStatus</code>.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * A value used to list export jobs that have a certain <code>JobStatus</code>.
         * </p>
         * 
         * @param jobStatus
         *        A value used to list export jobs that have a certain <code>JobStatus</code>.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String nextToken;

        private Integer pageSize;

        private String exportSourceType;

        private String jobStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExportJobsRequest model) {
            super(model);
            nextToken(model.nextToken);
            pageSize(model.pageSize);
            exportSourceType(model.exportSourceType);
            jobStatus(model.jobStatus);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getExportSourceType() {
            return exportSourceType;
        }

        public final void setExportSourceType(String exportSourceType) {
            this.exportSourceType = exportSourceType;
        }

        @Override
        public final Builder exportSourceType(String exportSourceType) {
            this.exportSourceType = exportSourceType;
            return this;
        }

        @Override
        public final Builder exportSourceType(ExportSourceType exportSourceType) {
            this.exportSourceType(exportSourceType == null ? null : exportSourceType.toString());
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListExportJobsRequest build() {
            return new ListExportJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
