/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains configuration details of multi-region endpoint (global-endpoint).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Details implements SdkPojo, Serializable, ToCopyableBuilder<Details.Builder, Details> {
    private static final SdkField<List<RouteDetails>> ROUTES_DETAILS_FIELD = SdkField
            .<List<RouteDetails>> builder(MarshallingType.LIST)
            .memberName("RoutesDetails")
            .getter(getter(Details::routesDetails))
            .setter(setter(Builder::routesDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutesDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTES_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RouteDetails> routesDetails;

    private Details(BuilderImpl builder) {
        this.routesDetails = builder.routesDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoutesDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoutesDetails() {
        return routesDetails != null && !(routesDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of route configuration details. Must contain exactly one route configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutesDetails} method.
     * </p>
     * 
     * @return A list of route configuration details. Must contain exactly one route configuration.
     */
    public final List<RouteDetails> routesDetails() {
        return routesDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutesDetails() ? routesDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Details)) {
            return false;
        }
        Details other = (Details) obj;
        return hasRoutesDetails() == other.hasRoutesDetails() && Objects.equals(routesDetails(), other.routesDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Details").add("RoutesDetails", hasRoutesDetails() ? routesDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoutesDetails":
            return Optional.ofNullable(clazz.cast(routesDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RoutesDetails", ROUTES_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Details, T> g) {
        return obj -> g.apply((Details) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Details> {
        /**
         * <p>
         * A list of route configuration details. Must contain exactly one route configuration.
         * </p>
         * 
         * @param routesDetails
         *        A list of route configuration details. Must contain exactly one route configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routesDetails(Collection<RouteDetails> routesDetails);

        /**
         * <p>
         * A list of route configuration details. Must contain exactly one route configuration.
         * </p>
         * 
         * @param routesDetails
         *        A list of route configuration details. Must contain exactly one route configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routesDetails(RouteDetails... routesDetails);

        /**
         * <p>
         * A list of route configuration details. Must contain exactly one route configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.RouteDetails.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.RouteDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.RouteDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #routesDetails(List<RouteDetails>)}.
         * 
         * @param routesDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.RouteDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routesDetails(java.util.Collection<RouteDetails>)
         */
        Builder routesDetails(Consumer<RouteDetails.Builder>... routesDetails);
    }

    static final class BuilderImpl implements Builder {
        private List<RouteDetails> routesDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Details model) {
            routesDetails(model.routesDetails);
        }

        public final List<RouteDetails.Builder> getRoutesDetails() {
            List<RouteDetails.Builder> result = RoutesDetailsCopier.copyToBuilder(this.routesDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutesDetails(Collection<RouteDetails.BuilderImpl> routesDetails) {
            this.routesDetails = RoutesDetailsCopier.copyFromBuilder(routesDetails);
        }

        @Override
        public final Builder routesDetails(Collection<RouteDetails> routesDetails) {
            this.routesDetails = RoutesDetailsCopier.copy(routesDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routesDetails(RouteDetails... routesDetails) {
            routesDetails(Arrays.asList(routesDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routesDetails(Consumer<RouteDetails.Builder>... routesDetails) {
            routesDetails(Stream.of(routesDetails).map(c -> RouteDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Details build() {
            return new Details(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
