/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An HTTP 200 response if the request succeeds, or an error message if the request fails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMultiRegionEndpointResponse extends SesV2Response implements
        ToCopyableBuilder<GetMultiRegionEndpointResponse.Builder, GetMultiRegionEndpointResponse> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(GetMultiRegionEndpointResponse::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(GetMultiRegionEndpointResponse::endpointId))
            .setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()).build();

    private static final SdkField<List<Route>> ROUTES_FIELD = SdkField
            .<List<Route>> builder(MarshallingType.LIST)
            .memberName("Routes")
            .getter(getter(GetMultiRegionEndpointResponse::routes))
            .setter(setter(Builder::routes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Routes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Route> builder(MarshallingType.SDK_POJO)
                                            .constructor(Route::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetMultiRegionEndpointResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(GetMultiRegionEndpointResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(GetMultiRegionEndpointResponse::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            ENDPOINT_ID_FIELD, ROUTES_FIELD, STATUS_FIELD, CREATED_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String endpointName;

    private final String endpointId;

    private final List<Route> routes;

    private final String status;

    private final Instant createdTimestamp;

    private final Instant lastUpdatedTimestamp;

    private GetMultiRegionEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.endpointId = builder.endpointId;
        this.routes = builder.routes;
        this.status = builder.status;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The name of the multi-region endpoint (global-endpoint).
     * </p>
     * 
     * @return The name of the multi-region endpoint (global-endpoint).
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The ID of the multi-region endpoint (global-endpoint).
     * </p>
     * 
     * @return The ID of the multi-region endpoint (global-endpoint).
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Routes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRoutes() {
        return routes != null && !(routes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains routes information for the multi-region endpoint (global-endpoint).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutes} method.
     * </p>
     * 
     * @return Contains routes information for the multi-region endpoint (global-endpoint).
     */
    public final List<Route> routes() {
        return routes;
    }

    /**
     * <p>
     * The status of the multi-region endpoint (global-endpoint).
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> – The resource is being provisioned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code> – The resource is ready to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – The resource failed to be provisioned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> – The resource is being deleted as requested.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the multi-region endpoint (global-endpoint).</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> – The resource is being provisioned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code> – The resource is ready to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – The resource failed to be provisioned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> – The resource is being deleted as requested.
     *         </p>
     *         </li>
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the multi-region endpoint (global-endpoint).
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> – The resource is being provisioned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code> – The resource is ready to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – The resource failed to be provisioned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> – The resource is being deleted as requested.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the multi-region endpoint (global-endpoint).</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> – The resource is being provisioned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code> – The resource is ready to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – The resource failed to be provisioned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> – The resource is being deleted as requested.
     *         </p>
     *         </li>
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time stamp of when the multi-region endpoint (global-endpoint) was created.
     * </p>
     * 
     * @return The time stamp of when the multi-region endpoint (global-endpoint) was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time stamp of when the multi-region endpoint (global-endpoint) was last updated.
     * </p>
     * 
     * @return The time stamp of when the multi-region endpoint (global-endpoint) was last updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutes() ? routes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMultiRegionEndpointResponse)) {
            return false;
        }
        GetMultiRegionEndpointResponse other = (GetMultiRegionEndpointResponse) obj;
        return Objects.equals(endpointName(), other.endpointName()) && Objects.equals(endpointId(), other.endpointId())
                && hasRoutes() == other.hasRoutes() && Objects.equals(routes(), other.routes())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMultiRegionEndpointResponse").add("EndpointName", endpointName())
                .add("EndpointId", endpointId()).add("Routes", hasRoutes() ? routes() : null).add("Status", statusAsString())
                .add("CreatedTimestamp", createdTimestamp()).add("LastUpdatedTimestamp", lastUpdatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "Routes":
            return Optional.ofNullable(clazz.cast(routes()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("EndpointId", ENDPOINT_ID_FIELD);
        map.put("Routes", ROUTES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMultiRegionEndpointResponse, T> g) {
        return obj -> g.apply((GetMultiRegionEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetMultiRegionEndpointResponse> {
        /**
         * <p>
         * The name of the multi-region endpoint (global-endpoint).
         * </p>
         * 
         * @param endpointName
         *        The name of the multi-region endpoint (global-endpoint).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The ID of the multi-region endpoint (global-endpoint).
         * </p>
         * 
         * @param endpointId
         *        The ID of the multi-region endpoint (global-endpoint).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * Contains routes information for the multi-region endpoint (global-endpoint).
         * </p>
         * 
         * @param routes
         *        Contains routes information for the multi-region endpoint (global-endpoint).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Collection<Route> routes);

        /**
         * <p>
         * Contains routes information for the multi-region endpoint (global-endpoint).
         * </p>
         * 
         * @param routes
         *        Contains routes information for the multi-region endpoint (global-endpoint).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Route... routes);

        /**
         * <p>
         * Contains routes information for the multi-region endpoint (global-endpoint).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.Route.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sesv2.model.Route#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.Route.Builder#build()} is called immediately and its
         * result is passed to {@link #routes(List<Route>)}.
         * 
         * @param routes
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.sesv2.model.Route.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routes(java.util.Collection<Route>)
         */
        Builder routes(Consumer<Route.Builder>... routes);

        /**
         * <p>
         * The status of the multi-region endpoint (global-endpoint).
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> – The resource is being provisioned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code> – The resource is ready to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – The resource failed to be provisioned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> – The resource is being deleted as requested.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the multi-region endpoint (global-endpoint).</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> – The resource is being provisioned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code> – The resource is ready to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – The resource failed to be provisioned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> – The resource is being deleted as requested.
         *        </p>
         *        </li>
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the multi-region endpoint (global-endpoint).
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> – The resource is being provisioned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code> – The resource is ready to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – The resource failed to be provisioned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> – The resource is being deleted as requested.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the multi-region endpoint (global-endpoint).</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> – The resource is being provisioned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code> – The resource is ready to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – The resource failed to be provisioned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> – The resource is being deleted as requested.
         *        </p>
         *        </li>
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The time stamp of when the multi-region endpoint (global-endpoint) was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time stamp of when the multi-region endpoint (global-endpoint) was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time stamp of when the multi-region endpoint (global-endpoint) was last updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The time stamp of when the multi-region endpoint (global-endpoint) was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private String endpointName;

        private String endpointId;

        private List<Route> routes = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Instant createdTimestamp;

        private Instant lastUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMultiRegionEndpointResponse model) {
            super(model);
            endpointName(model.endpointName);
            endpointId(model.endpointId);
            routes(model.routes);
            status(model.status);
            createdTimestamp(model.createdTimestamp);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final List<Route.Builder> getRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<Route.BuilderImpl> routes) {
            this.routes = RoutesCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<Route> routes) {
            this.routes = RoutesCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Route... routes) {
            routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<Route.Builder>... routes) {
            routes(Stream.of(routes).map(c -> Route.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        @Override
        public GetMultiRegionEndpointResponse build() {
            return new GetMultiRegionEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
