/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.auth.scheme;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sesv2.auth.scheme.internal.DefaultSesV2AuthSchemeParams;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The parameters object used to resolve the auth schemes for the SesV2 service.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface SesV2AuthSchemeParams extends ToCopyableBuilder<SesV2AuthSchemeParams.Builder, SesV2AuthSchemeParams> {
    /**
     * Get a new builder for creating a {@link SesV2AuthSchemeParams}.
     */
    static Builder builder() {
        return DefaultSesV2AuthSchemeParams.builder();
    }

    /**
     * Returns the operation for which to resolve the auth scheme.
     */
    String operation();

    /**
     * Returns the region. The region parameter may be used with the "aws.auth#sigv4" auth scheme.
     */
    Region region();

    /**
     * When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the
     * request MAY return an error.
     */
    Boolean useDualStack();

    /**
     * When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a
     * FIPS compliant endpoint, dispatching the request will return an error.
     */
    Boolean useFips();

    /**
     * Override the endpoint used to send this request
     */
    String endpoint();

    /**
     * Operation parameter for EndpointId
     */
    String endpointId();

    /**
     * Returns a {@link Builder} to customize the parameters.
     */
    Builder toBuilder();

    /**
     * A builder for a {@link SesV2AuthSchemeParams}.
     */
    interface Builder extends CopyableBuilder<Builder, SesV2AuthSchemeParams> {
        /**
         * Set the operation for which to resolve the auth scheme.
         */
        Builder operation(String operation);

        /**
         * Set the region. The region parameter may be used with the "aws.auth#sigv4" auth scheme.
         */
        Builder region(Region region);

        /**
         * When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching
         * the request MAY return an error.
         */
        Builder useDualStack(Boolean useDualStack);

        /**
         * When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not
         * have a FIPS compliant endpoint, dispatching the request will return an error.
         */
        Builder useFips(Boolean useFIPS);

        /**
         * Override the endpoint used to send this request
         */
        Builder endpoint(String endpoint);

        /**
         * Operation parameter for EndpointId
         */
        Builder endpointId(String endpointId);

        /**
         * Returns a {@link SesV2AuthSchemeParams} object that is created from the properties that have been set on the
         * builder.
         */
        SesV2AuthSchemeParams build();
    }
}
