/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to retrieve a batch of metric data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetMetricDataRequest extends SesV2Request implements
        ToCopyableBuilder<BatchGetMetricDataRequest.Builder, BatchGetMetricDataRequest> {
    private static final SdkField<List<BatchGetMetricDataQuery>> QUERIES_FIELD = SdkField
            .<List<BatchGetMetricDataQuery>> builder(MarshallingType.LIST)
            .memberName("Queries")
            .getter(getter(BatchGetMetricDataRequest::queries))
            .setter(setter(Builder::queries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetMetricDataQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetMetricDataQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchGetMetricDataQuery> queries;

    private BatchGetMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.queries = builder.queries;
    }

    /**
     * For responses, this returns true if the service returned a value for the Queries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueries() {
        return queries != null && !(queries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of queries for metrics to be retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueries} method.
     * </p>
     * 
     * @return A list of queries for metrics to be retrieved.
     */
    public final List<BatchGetMetricDataQuery> queries() {
        return queries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasQueries() ? queries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetMetricDataRequest)) {
            return false;
        }
        BatchGetMetricDataRequest other = (BatchGetMetricDataRequest) obj;
        return hasQueries() == other.hasQueries() && Objects.equals(queries(), other.queries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetMetricDataRequest").add("Queries", hasQueries() ? queries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Queries":
            return Optional.ofNullable(clazz.cast(queries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Queries", QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetMetricDataRequest, T> g) {
        return obj -> g.apply((BatchGetMetricDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetMetricDataRequest> {
        /**
         * <p>
         * A list of queries for metrics to be retrieved.
         * </p>
         * 
         * @param queries
         *        A list of queries for metrics to be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queries(Collection<BatchGetMetricDataQuery> queries);

        /**
         * <p>
         * A list of queries for metrics to be retrieved.
         * </p>
         * 
         * @param queries
         *        A list of queries for metrics to be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queries(BatchGetMetricDataQuery... queries);

        /**
         * <p>
         * A list of queries for metrics to be retrieved.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataQuery.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataQuery#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataQuery.Builder#build()} is called
         * immediately and its result is passed to {@link #queries(List<BatchGetMetricDataQuery>)}.
         * 
         * @param queries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queries(java.util.Collection<BatchGetMetricDataQuery>)
         */
        Builder queries(Consumer<BatchGetMetricDataQuery.Builder>... queries);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private List<BatchGetMetricDataQuery> queries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetMetricDataRequest model) {
            super(model);
            queries(model.queries);
        }

        public final List<BatchGetMetricDataQuery.Builder> getQueries() {
            List<BatchGetMetricDataQuery.Builder> result = BatchGetMetricDataQueriesCopier.copyToBuilder(this.queries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueries(Collection<BatchGetMetricDataQuery.BuilderImpl> queries) {
            this.queries = BatchGetMetricDataQueriesCopier.copyFromBuilder(queries);
        }

        @Override
        public final Builder queries(Collection<BatchGetMetricDataQuery> queries) {
            this.queries = BatchGetMetricDataQueriesCopier.copy(queries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(BatchGetMetricDataQuery... queries) {
            queries(Arrays.asList(queries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(Consumer<BatchGetMetricDataQuery.Builder>... queries) {
            queries(Stream.of(queries).map(c -> BatchGetMetricDataQuery.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetMetricDataRequest build() {
            return new BatchGetMetricDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
