/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of processing your metric data batch request
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetMetricDataResponse extends SesV2Response implements
        ToCopyableBuilder<BatchGetMetricDataResponse.Builder, BatchGetMetricDataResponse> {
    private static final SdkField<List<MetricDataResult>> RESULTS_FIELD = SdkField
            .<List<MetricDataResult>> builder(MarshallingType.LIST)
            .memberName("Results")
            .getter(getter(BatchGetMetricDataResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDataResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDataResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MetricDataError>> ERRORS_FIELD = SdkField
            .<List<MetricDataError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchGetMetricDataResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDataError> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDataError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MetricDataResult> results;

    private final List<MetricDataError> errors;

    private BatchGetMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Results property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of successfully retrieved <code>MetricDataResult</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResults} method.
     * </p>
     * 
     * @return A list of successfully retrieved <code>MetricDataResult</code>.
     */
    public final List<MetricDataResult> results() {
        return results;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>MetricDataError</code> encountered while processing your metric data batch request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of <code>MetricDataError</code> encountered while processing your metric data batch request.
     */
    public final List<MetricDataError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetMetricDataResponse)) {
            return false;
        }
        BatchGetMetricDataResponse other = (BatchGetMetricDataResponse) obj;
        return hasResults() == other.hasResults() && Objects.equals(results(), other.results())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetMetricDataResponse").add("Results", hasResults() ? results() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Results", RESULTS_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetMetricDataResponse, T> g) {
        return obj -> g.apply((BatchGetMetricDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetMetricDataResponse> {
        /**
         * <p>
         * A list of successfully retrieved <code>MetricDataResult</code>.
         * </p>
         * 
         * @param results
         *        A list of successfully retrieved <code>MetricDataResult</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<MetricDataResult> results);

        /**
         * <p>
         * A list of successfully retrieved <code>MetricDataResult</code>.
         * </p>
         * 
         * @param results
         *        A list of successfully retrieved <code>MetricDataResult</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(MetricDataResult... results);

        /**
         * <p>
         * A list of successfully retrieved <code>MetricDataResult</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.MetricDataResult.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.MetricDataResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.MetricDataResult.Builder#build()} is called immediately
         * and its result is passed to {@link #results(List<MetricDataResult>)}.
         * 
         * @param results
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.MetricDataResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(java.util.Collection<MetricDataResult>)
         */
        Builder results(Consumer<MetricDataResult.Builder>... results);

        /**
         * <p>
         * A list of <code>MetricDataError</code> encountered while processing your metric data batch request.
         * </p>
         * 
         * @param errors
         *        A list of <code>MetricDataError</code> encountered while processing your metric data batch request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<MetricDataError> errors);

        /**
         * <p>
         * A list of <code>MetricDataError</code> encountered while processing your metric data batch request.
         * </p>
         * 
         * @param errors
         *        A list of <code>MetricDataError</code> encountered while processing your metric data batch request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(MetricDataError... errors);

        /**
         * <p>
         * A list of <code>MetricDataError</code> encountered while processing your metric data batch request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.MetricDataError.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.MetricDataError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.MetricDataError.Builder#build()} is called immediately and
         * its result is passed to {@link #errors(List<MetricDataError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.MetricDataError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<MetricDataError>)
         */
        Builder errors(Consumer<MetricDataError.Builder>... errors);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private List<MetricDataResult> results = DefaultSdkAutoConstructList.getInstance();

        private List<MetricDataError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetMetricDataResponse model) {
            super(model);
            results(model.results);
            errors(model.errors);
        }

        public final List<MetricDataResult.Builder> getResults() {
            List<MetricDataResult.Builder> result = MetricDataResultListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<MetricDataResult.BuilderImpl> results) {
            this.results = MetricDataResultListCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<MetricDataResult> results) {
            this.results = MetricDataResultListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(MetricDataResult... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<MetricDataResult.Builder>... results) {
            results(Stream.of(results).map(c -> MetricDataResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MetricDataError.Builder> getErrors() {
            List<MetricDataError.Builder> result = MetricDataErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<MetricDataError.BuilderImpl> errors) {
            this.errors = MetricDataErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<MetricDataError> errors) {
            this.errors = MetricDataErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(MetricDataError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<MetricDataError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> MetricDataError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetMetricDataResponse build() {
            return new BatchGetMetricDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
