/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list that contains contacts that have subscribed to a particular topic or topics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactList implements SdkPojo, Serializable, ToCopyableBuilder<ContactList.Builder, ContactList> {
    private static final SdkField<String> CONTACT_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactListName").getter(getter(ContactList::contactListName)).setter(setter(Builder::contactListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactListName").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(ContactList::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_LIST_NAME_FIELD,
            LAST_UPDATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String contactListName;

    private final Instant lastUpdatedTimestamp;

    private ContactList(BuilderImpl builder) {
        this.contactListName = builder.contactListName;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The name of the contact list.
     * </p>
     * 
     * @return The name of the contact list.
     */
    public final String contactListName() {
        return contactListName;
    }

    /**
     * <p>
     * A timestamp noting the last time the contact list was updated.
     * </p>
     * 
     * @return A timestamp noting the last time the contact list was updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactListName());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactList)) {
            return false;
        }
        ContactList other = (ContactList) obj;
        return Objects.equals(contactListName(), other.contactListName())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactList").add("ContactListName", contactListName())
                .add("LastUpdatedTimestamp", lastUpdatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactListName":
            return Optional.ofNullable(clazz.cast(contactListName()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactListName", CONTACT_LIST_NAME_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactList, T> g) {
        return obj -> g.apply((ContactList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactList> {
        /**
         * <p>
         * The name of the contact list.
         * </p>
         * 
         * @param contactListName
         *        The name of the contact list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactListName(String contactListName);

        /**
         * <p>
         * A timestamp noting the last time the contact list was updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        A timestamp noting the last time the contact list was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String contactListName;

        private Instant lastUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactList model) {
            contactListName(model.contactListName);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
        }

        public final String getContactListName() {
            return contactListName;
        }

        public final void setContactListName(String contactListName) {
            this.contactListName = contactListName;
        }

        @Override
        public final Builder contactListName(String contactListName) {
            this.contactListName = contactListName;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        @Override
        public ContactList build() {
            return new ContactList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
