/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to create an export job from a data source to a data destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateExportJobRequest extends SesV2Request implements
        ToCopyableBuilder<CreateExportJobRequest.Builder, CreateExportJobRequest> {
    private static final SdkField<ExportDataSource> EXPORT_DATA_SOURCE_FIELD = SdkField
            .<ExportDataSource> builder(MarshallingType.SDK_POJO).memberName("ExportDataSource")
            .getter(getter(CreateExportJobRequest::exportDataSource)).setter(setter(Builder::exportDataSource))
            .constructor(ExportDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportDataSource").build()).build();

    private static final SdkField<ExportDestination> EXPORT_DESTINATION_FIELD = SdkField
            .<ExportDestination> builder(MarshallingType.SDK_POJO).memberName("ExportDestination")
            .getter(getter(CreateExportJobRequest::exportDestination)).setter(setter(Builder::exportDestination))
            .constructor(ExportDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportDestination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_DATA_SOURCE_FIELD,
            EXPORT_DESTINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ExportDataSource exportDataSource;

    private final ExportDestination exportDestination;

    private CreateExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.exportDataSource = builder.exportDataSource;
        this.exportDestination = builder.exportDestination;
    }

    /**
     * <p>
     * The data source for the export job.
     * </p>
     * 
     * @return The data source for the export job.
     */
    public final ExportDataSource exportDataSource() {
        return exportDataSource;
    }

    /**
     * <p>
     * The destination for the export job.
     * </p>
     * 
     * @return The destination for the export job.
     */
    public final ExportDestination exportDestination() {
        return exportDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(exportDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExportJobRequest)) {
            return false;
        }
        CreateExportJobRequest other = (CreateExportJobRequest) obj;
        return Objects.equals(exportDataSource(), other.exportDataSource())
                && Objects.equals(exportDestination(), other.exportDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateExportJobRequest").add("ExportDataSource", exportDataSource())
                .add("ExportDestination", exportDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportDataSource":
            return Optional.ofNullable(clazz.cast(exportDataSource()));
        case "ExportDestination":
            return Optional.ofNullable(clazz.cast(exportDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExportDataSource", EXPORT_DATA_SOURCE_FIELD);
        map.put("ExportDestination", EXPORT_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateExportJobRequest, T> g) {
        return obj -> g.apply((CreateExportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateExportJobRequest> {
        /**
         * <p>
         * The data source for the export job.
         * </p>
         * 
         * @param exportDataSource
         *        The data source for the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDataSource(ExportDataSource exportDataSource);

        /**
         * <p>
         * The data source for the export job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportDataSource.Builder} avoiding the
         * need to create one manually via {@link ExportDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportDataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #exportDataSource(ExportDataSource)}.
         * 
         * @param exportDataSource
         *        a consumer that will call methods on {@link ExportDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportDataSource(ExportDataSource)
         */
        default Builder exportDataSource(Consumer<ExportDataSource.Builder> exportDataSource) {
            return exportDataSource(ExportDataSource.builder().applyMutation(exportDataSource).build());
        }

        /**
         * <p>
         * The destination for the export job.
         * </p>
         * 
         * @param exportDestination
         *        The destination for the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDestination(ExportDestination exportDestination);

        /**
         * <p>
         * The destination for the export job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportDestination.Builder} avoiding the
         * need to create one manually via {@link ExportDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #exportDestination(ExportDestination)}.
         * 
         * @param exportDestination
         *        a consumer that will call methods on {@link ExportDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportDestination(ExportDestination)
         */
        default Builder exportDestination(Consumer<ExportDestination.Builder> exportDestination) {
            return exportDestination(ExportDestination.builder().applyMutation(exportDestination).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private ExportDataSource exportDataSource;

        private ExportDestination exportDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExportJobRequest model) {
            super(model);
            exportDataSource(model.exportDataSource);
            exportDestination(model.exportDestination);
        }

        public final ExportDataSource.Builder getExportDataSource() {
            return exportDataSource != null ? exportDataSource.toBuilder() : null;
        }

        public final void setExportDataSource(ExportDataSource.BuilderImpl exportDataSource) {
            this.exportDataSource = exportDataSource != null ? exportDataSource.build() : null;
        }

        @Override
        public final Builder exportDataSource(ExportDataSource exportDataSource) {
            this.exportDataSource = exportDataSource;
            return this;
        }

        public final ExportDestination.Builder getExportDestination() {
            return exportDestination != null ? exportDestination.toBuilder() : null;
        }

        public final void setExportDestination(ExportDestination.BuilderImpl exportDestination) {
            this.exportDestination = exportDestination != null ? exportDestination.build() : null;
        }

        @Override
        public final Builder exportDestination(ExportDestination exportDestination) {
            this.exportDestination = exportDestination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExportJobRequest build() {
            return new CreateExportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
