/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to submit new account VDM attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAccountVdmAttributesRequest extends SesV2Request implements
        ToCopyableBuilder<PutAccountVdmAttributesRequest.Builder, PutAccountVdmAttributesRequest> {
    private static final SdkField<VdmAttributes> VDM_ATTRIBUTES_FIELD = SdkField
            .<VdmAttributes> builder(MarshallingType.SDK_POJO).memberName("VdmAttributes")
            .getter(getter(PutAccountVdmAttributesRequest::vdmAttributes)).setter(setter(Builder::vdmAttributes))
            .constructor(VdmAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VdmAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VDM_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VdmAttributes vdmAttributes;

    private PutAccountVdmAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.vdmAttributes = builder.vdmAttributes;
    }

    /**
     * <p>
     * The VDM attributes that you wish to apply to your Amazon SES account.
     * </p>
     * 
     * @return The VDM attributes that you wish to apply to your Amazon SES account.
     */
    public final VdmAttributes vdmAttributes() {
        return vdmAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vdmAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccountVdmAttributesRequest)) {
            return false;
        }
        PutAccountVdmAttributesRequest other = (PutAccountVdmAttributesRequest) obj;
        return Objects.equals(vdmAttributes(), other.vdmAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAccountVdmAttributesRequest").add("VdmAttributes", vdmAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VdmAttributes":
            return Optional.ofNullable(clazz.cast(vdmAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VdmAttributes", VDM_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAccountVdmAttributesRequest, T> g) {
        return obj -> g.apply((PutAccountVdmAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, PutAccountVdmAttributesRequest> {
        /**
         * <p>
         * The VDM attributes that you wish to apply to your Amazon SES account.
         * </p>
         * 
         * @param vdmAttributes
         *        The VDM attributes that you wish to apply to your Amazon SES account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vdmAttributes(VdmAttributes vdmAttributes);

        /**
         * <p>
         * The VDM attributes that you wish to apply to your Amazon SES account.
         * </p>
         * This is a convenience method that creates an instance of the {@link VdmAttributes.Builder} avoiding the need
         * to create one manually via {@link VdmAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VdmAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #vdmAttributes(VdmAttributes)}.
         * 
         * @param vdmAttributes
         *        a consumer that will call methods on {@link VdmAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vdmAttributes(VdmAttributes)
         */
        default Builder vdmAttributes(Consumer<VdmAttributes.Builder> vdmAttributes) {
            return vdmAttributes(VdmAttributes.builder().applyMutation(vdmAttributes).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private VdmAttributes vdmAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccountVdmAttributesRequest model) {
            super(model);
            vdmAttributes(model.vdmAttributes);
        }

        public final VdmAttributes.Builder getVdmAttributes() {
            return vdmAttributes != null ? vdmAttributes.toBuilder() : null;
        }

        public final void setVdmAttributes(VdmAttributes.BuilderImpl vdmAttributes) {
            this.vdmAttributes = vdmAttributes != null ? vdmAttributes.build() : null;
        }

        @Override
        public final Builder vdmAttributes(VdmAttributes vdmAttributes) {
            this.vdmAttributes = vdmAttributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAccountVdmAttributesRequest build() {
            return new PutAccountVdmAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
