/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing details about a specific event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsightsEvent implements SdkPojo, Serializable, ToCopyableBuilder<InsightsEvent.Builder, InsightsEvent> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(InsightsEvent::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(InsightsEvent::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<EventDetails> DETAILS_FIELD = SdkField.<EventDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Details").getter(getter(InsightsEvent::details)).setter(setter(Builder::details))
            .constructor(EventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, TYPE_FIELD,
            DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant timestamp;

    private final String type;

    private final EventDetails details;

    private InsightsEvent(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.type = builder.type;
        this.details = builder.details;
    }

    /**
     * <p>
     * The timestamp of the event.
     * </p>
     * 
     * @return The timestamp of the event.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The type of event:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SEND</code> - The send request was successful and SES will attempt to deliver the message to the
     * recipient’s mail server. (If account-level or global suppression is being used, SES will still count it as a
     * send, but delivery is suppressed.)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELIVERY</code> - SES successfully delivered the email to the recipient's mail server. Excludes deliveries
     * to the mailbox simulator, and those from emails addressed to more than one recipient.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BOUNCE</code> - Feedback received for delivery failures. Additional details about the bounce are provided
     * in the <code>Details</code> object. Excludes bounces from the mailbox simulator, and those from emails addressed
     * to more than one recipient.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLAINT</code> - Complaint received for the email. Additional details about the complaint are provided in
     * the <code>Details</code> object. This excludes complaints from the mailbox simulator, those originating from your
     * account-level suppression list (if enabled), and those from emails addressed to more than one recipient.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPEN</code> - Open event for emails including open trackers. Excludes opens for emails addressed to more
     * than one recipient.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CLICK</code> - Click event for emails including wrapped links. Excludes clicks for emails addressed to more
     * than one recipient.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of event:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SEND</code> - The send request was successful and SES will attempt to deliver the message to the
     *         recipient’s mail server. (If account-level or global suppression is being used, SES will still count it
     *         as a send, but delivery is suppressed.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELIVERY</code> - SES successfully delivered the email to the recipient's mail server. Excludes
     *         deliveries to the mailbox simulator, and those from emails addressed to more than one recipient.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BOUNCE</code> - Feedback received for delivery failures. Additional details about the bounce are
     *         provided in the <code>Details</code> object. Excludes bounces from the mailbox simulator, and those from
     *         emails addressed to more than one recipient.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLAINT</code> - Complaint received for the email. Additional details about the complaint are
     *         provided in the <code>Details</code> object. This excludes complaints from the mailbox simulator, those
     *         originating from your account-level suppression list (if enabled), and those from emails addressed to
     *         more than one recipient.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPEN</code> - Open event for emails including open trackers. Excludes opens for emails addressed to
     *         more than one recipient.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CLICK</code> - Click event for emails including wrapped links. Excludes clicks for emails addressed
     *         to more than one recipient.
     *         </p>
     *         </li>
     * @see EventType
     */
    public final EventType type() {
        return EventType.fromValue(type);
    }

    /**
     * <p>
     * The type of event:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SEND</code> - The send request was successful and SES will attempt to deliver the message to the
     * recipient’s mail server. (If account-level or global suppression is being used, SES will still count it as a
     * send, but delivery is suppressed.)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELIVERY</code> - SES successfully delivered the email to the recipient's mail server. Excludes deliveries
     * to the mailbox simulator, and those from emails addressed to more than one recipient.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BOUNCE</code> - Feedback received for delivery failures. Additional details about the bounce are provided
     * in the <code>Details</code> object. Excludes bounces from the mailbox simulator, and those from emails addressed
     * to more than one recipient.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLAINT</code> - Complaint received for the email. Additional details about the complaint are provided in
     * the <code>Details</code> object. This excludes complaints from the mailbox simulator, those originating from your
     * account-level suppression list (if enabled), and those from emails addressed to more than one recipient.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPEN</code> - Open event for emails including open trackers. Excludes opens for emails addressed to more
     * than one recipient.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CLICK</code> - Click event for emails including wrapped links. Excludes clicks for emails addressed to more
     * than one recipient.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of event:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SEND</code> - The send request was successful and SES will attempt to deliver the message to the
     *         recipient’s mail server. (If account-level or global suppression is being used, SES will still count it
     *         as a send, but delivery is suppressed.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELIVERY</code> - SES successfully delivered the email to the recipient's mail server. Excludes
     *         deliveries to the mailbox simulator, and those from emails addressed to more than one recipient.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BOUNCE</code> - Feedback received for delivery failures. Additional details about the bounce are
     *         provided in the <code>Details</code> object. Excludes bounces from the mailbox simulator, and those from
     *         emails addressed to more than one recipient.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLAINT</code> - Complaint received for the email. Additional details about the complaint are
     *         provided in the <code>Details</code> object. This excludes complaints from the mailbox simulator, those
     *         originating from your account-level suppression list (if enabled), and those from emails addressed to
     *         more than one recipient.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPEN</code> - Open event for emails including open trackers. Excludes opens for emails addressed to
     *         more than one recipient.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CLICK</code> - Click event for emails including wrapped links. Excludes clicks for emails addressed
     *         to more than one recipient.
     *         </p>
     *         </li>
     * @see EventType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Details about bounce or complaint events.
     * </p>
     * 
     * @return Details about bounce or complaint events.
     */
    public final EventDetails details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightsEvent)) {
            return false;
        }
        InsightsEvent other = (InsightsEvent) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InsightsEvent").add("Timestamp", timestamp()).add("Type", typeAsString())
                .add("Details", details()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Details", DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightsEvent, T> g) {
        return obj -> g.apply((InsightsEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsightsEvent> {
        /**
         * <p>
         * The timestamp of the event.
         * </p>
         * 
         * @param timestamp
         *        The timestamp of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The type of event:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SEND</code> - The send request was successful and SES will attempt to deliver the message to the
         * recipient’s mail server. (If account-level or global suppression is being used, SES will still count it as a
         * send, but delivery is suppressed.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELIVERY</code> - SES successfully delivered the email to the recipient's mail server. Excludes
         * deliveries to the mailbox simulator, and those from emails addressed to more than one recipient.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOUNCE</code> - Feedback received for delivery failures. Additional details about the bounce are
         * provided in the <code>Details</code> object. Excludes bounces from the mailbox simulator, and those from
         * emails addressed to more than one recipient.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLAINT</code> - Complaint received for the email. Additional details about the complaint are
         * provided in the <code>Details</code> object. This excludes complaints from the mailbox simulator, those
         * originating from your account-level suppression list (if enabled), and those from emails addressed to more
         * than one recipient.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPEN</code> - Open event for emails including open trackers. Excludes opens for emails addressed to
         * more than one recipient.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CLICK</code> - Click event for emails including wrapped links. Excludes clicks for emails addressed to
         * more than one recipient.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of event:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SEND</code> - The send request was successful and SES will attempt to deliver the message to the
         *        recipient’s mail server. (If account-level or global suppression is being used, SES will still count
         *        it as a send, but delivery is suppressed.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELIVERY</code> - SES successfully delivered the email to the recipient's mail server. Excludes
         *        deliveries to the mailbox simulator, and those from emails addressed to more than one recipient.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOUNCE</code> - Feedback received for delivery failures. Additional details about the bounce are
         *        provided in the <code>Details</code> object. Excludes bounces from the mailbox simulator, and those
         *        from emails addressed to more than one recipient.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLAINT</code> - Complaint received for the email. Additional details about the complaint are
         *        provided in the <code>Details</code> object. This excludes complaints from the mailbox simulator,
         *        those originating from your account-level suppression list (if enabled), and those from emails
         *        addressed to more than one recipient.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPEN</code> - Open event for emails including open trackers. Excludes opens for emails addressed
         *        to more than one recipient.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CLICK</code> - Click event for emails including wrapped links. Excludes clicks for emails
         *        addressed to more than one recipient.
         *        </p>
         *        </li>
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of event:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SEND</code> - The send request was successful and SES will attempt to deliver the message to the
         * recipient’s mail server. (If account-level or global suppression is being used, SES will still count it as a
         * send, but delivery is suppressed.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELIVERY</code> - SES successfully delivered the email to the recipient's mail server. Excludes
         * deliveries to the mailbox simulator, and those from emails addressed to more than one recipient.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOUNCE</code> - Feedback received for delivery failures. Additional details about the bounce are
         * provided in the <code>Details</code> object. Excludes bounces from the mailbox simulator, and those from
         * emails addressed to more than one recipient.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLAINT</code> - Complaint received for the email. Additional details about the complaint are
         * provided in the <code>Details</code> object. This excludes complaints from the mailbox simulator, those
         * originating from your account-level suppression list (if enabled), and those from emails addressed to more
         * than one recipient.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPEN</code> - Open event for emails including open trackers. Excludes opens for emails addressed to
         * more than one recipient.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CLICK</code> - Click event for emails including wrapped links. Excludes clicks for emails addressed to
         * more than one recipient.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of event:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SEND</code> - The send request was successful and SES will attempt to deliver the message to the
         *        recipient’s mail server. (If account-level or global suppression is being used, SES will still count
         *        it as a send, but delivery is suppressed.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELIVERY</code> - SES successfully delivered the email to the recipient's mail server. Excludes
         *        deliveries to the mailbox simulator, and those from emails addressed to more than one recipient.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOUNCE</code> - Feedback received for delivery failures. Additional details about the bounce are
         *        provided in the <code>Details</code> object. Excludes bounces from the mailbox simulator, and those
         *        from emails addressed to more than one recipient.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLAINT</code> - Complaint received for the email. Additional details about the complaint are
         *        provided in the <code>Details</code> object. This excludes complaints from the mailbox simulator,
         *        those originating from your account-level suppression list (if enabled), and those from emails
         *        addressed to more than one recipient.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPEN</code> - Open event for emails including open trackers. Excludes opens for emails addressed
         *        to more than one recipient.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CLICK</code> - Click event for emails including wrapped links. Excludes clicks for emails
         *        addressed to more than one recipient.
         *        </p>
         *        </li>
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder type(EventType type);

        /**
         * <p>
         * Details about bounce or complaint events.
         * </p>
         * 
         * @param details
         *        Details about bounce or complaint events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(EventDetails details);

        /**
         * <p>
         * Details about bounce or complaint events.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventDetails.Builder} avoiding the need
         * to create one manually via {@link EventDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #details(EventDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link EventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(EventDetails)
         */
        default Builder details(Consumer<EventDetails.Builder> details) {
            return details(EventDetails.builder().applyMutation(details).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant timestamp;

        private String type;

        private EventDetails details;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightsEvent model) {
            timestamp(model.timestamp);
            type(model.type);
            details(model.details);
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EventType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final EventDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        public final void setDetails(EventDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(EventDetails details) {
            this.details = details;
            return this;
        }

        @Override
        public InsightsEvent build() {
            return new InsightsEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
