/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to obtain a list of email destinations that are on the suppression list for your account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSuppressedDestinationsRequest extends SesV2Request implements
        ToCopyableBuilder<ListSuppressedDestinationsRequest.Builder, ListSuppressedDestinationsRequest> {
    private static final SdkField<List<String>> REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Reasons")
            .getter(getter(ListSuppressedDestinationsRequest::reasonsAsStrings))
            .setter(setter(Builder::reasonsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Reason").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDate").getter(getter(ListSuppressedDestinationsRequest::startDate))
            .setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("StartDate").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDate").getter(getter(ListSuppressedDestinationsRequest::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("EndDate").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSuppressedDestinationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(ListSuppressedDestinationsRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("PageSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASONS_FIELD,
            START_DATE_FIELD, END_DATE_FIELD, NEXT_TOKEN_FIELD, PAGE_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> reasons;

    private final Instant startDate;

    private final Instant endDate;

    private final String nextToken;

    private final Integer pageSize;

    private ListSuppressedDestinationsRequest(BuilderImpl builder) {
        super(builder);
        this.reasons = builder.reasons;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
    }

    /**
     * <p>
     * The factors that caused the email address to be added to .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReasons} method.
     * </p>
     * 
     * @return The factors that caused the email address to be added to .
     */
    public final List<SuppressionListReason> reasons() {
        return SuppressionListReasonsCopier.copyStringToEnum(reasons);
    }

    /**
     * For responses, this returns true if the service returned a value for the Reasons property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReasons() {
        return reasons != null && !(reasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The factors that caused the email address to be added to .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReasons} method.
     * </p>
     * 
     * @return The factors that caused the email address to be added to .
     */
    public final List<String> reasonsAsStrings() {
        return reasons;
    }

    /**
     * <p>
     * Used to filter the list of suppressed email destinations so that it only includes addresses that were added to
     * the list after a specific date.
     * </p>
     * 
     * @return Used to filter the list of suppressed email destinations so that it only includes addresses that were
     *         added to the list after a specific date.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * Used to filter the list of suppressed email destinations so that it only includes addresses that were added to
     * the list before a specific date.
     * </p>
     * 
     * @return Used to filter the list of suppressed email destinations so that it only includes addresses that were
     *         added to the list before a specific date.
     */
    public final Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * A token returned from a previous call to <code>ListSuppressedDestinations</code> to indicate the position in the
     * list of suppressed email addresses.
     * </p>
     * 
     * @return A token returned from a previous call to <code>ListSuppressedDestinations</code> to indicate the position
     *         in the list of suppressed email addresses.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The number of results to show in a single call to <code>ListSuppressedDestinations</code>. If the number of
     * results is larger than the number you specified in this parameter, then the response includes a
     * <code>NextToken</code> element, which you can use to obtain additional results.
     * </p>
     * 
     * @return The number of results to show in a single call to <code>ListSuppressedDestinations</code>. If the number
     *         of results is larger than the number you specified in this parameter, then the response includes a
     *         <code>NextToken</code> element, which you can use to obtain additional results.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReasons() ? reasonsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSuppressedDestinationsRequest)) {
            return false;
        }
        ListSuppressedDestinationsRequest other = (ListSuppressedDestinationsRequest) obj;
        return hasReasons() == other.hasReasons() && Objects.equals(reasonsAsStrings(), other.reasonsAsStrings())
                && Objects.equals(startDate(), other.startDate()) && Objects.equals(endDate(), other.endDate())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(pageSize(), other.pageSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSuppressedDestinationsRequest").add("Reasons", hasReasons() ? reasonsAsStrings() : null)
                .add("StartDate", startDate()).add("EndDate", endDate()).add("NextToken", nextToken())
                .add("PageSize", pageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Reasons":
            return Optional.ofNullable(clazz.cast(reasonsAsStrings()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Reason", REASONS_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("PageSize", PAGE_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSuppressedDestinationsRequest, T> g) {
        return obj -> g.apply((ListSuppressedDestinationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListSuppressedDestinationsRequest> {
        /**
         * <p>
         * The factors that caused the email address to be added to .
         * </p>
         * 
         * @param reasons
         *        The factors that caused the email address to be added to .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonsWithStrings(Collection<String> reasons);

        /**
         * <p>
         * The factors that caused the email address to be added to .
         * </p>
         * 
         * @param reasons
         *        The factors that caused the email address to be added to .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonsWithStrings(String... reasons);

        /**
         * <p>
         * The factors that caused the email address to be added to .
         * </p>
         * 
         * @param reasons
         *        The factors that caused the email address to be added to .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasons(Collection<SuppressionListReason> reasons);

        /**
         * <p>
         * The factors that caused the email address to be added to .
         * </p>
         * 
         * @param reasons
         *        The factors that caused the email address to be added to .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasons(SuppressionListReason... reasons);

        /**
         * <p>
         * Used to filter the list of suppressed email destinations so that it only includes addresses that were added
         * to the list after a specific date.
         * </p>
         * 
         * @param startDate
         *        Used to filter the list of suppressed email destinations so that it only includes addresses that were
         *        added to the list after a specific date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * Used to filter the list of suppressed email destinations so that it only includes addresses that were added
         * to the list before a specific date.
         * </p>
         * 
         * @param endDate
         *        Used to filter the list of suppressed email destinations so that it only includes addresses that were
         *        added to the list before a specific date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * A token returned from a previous call to <code>ListSuppressedDestinations</code> to indicate the position in
         * the list of suppressed email addresses.
         * </p>
         * 
         * @param nextToken
         *        A token returned from a previous call to <code>ListSuppressedDestinations</code> to indicate the
         *        position in the list of suppressed email addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The number of results to show in a single call to <code>ListSuppressedDestinations</code>. If the number of
         * results is larger than the number you specified in this parameter, then the response includes a
         * <code>NextToken</code> element, which you can use to obtain additional results.
         * </p>
         * 
         * @param pageSize
         *        The number of results to show in a single call to <code>ListSuppressedDestinations</code>. If the
         *        number of results is larger than the number you specified in this parameter, then the response
         *        includes a <code>NextToken</code> element, which you can use to obtain additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private List<String> reasons = DefaultSdkAutoConstructList.getInstance();

        private Instant startDate;

        private Instant endDate;

        private String nextToken;

        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSuppressedDestinationsRequest model) {
            super(model);
            reasonsWithStrings(model.reasons);
            startDate(model.startDate);
            endDate(model.endDate);
            nextToken(model.nextToken);
            pageSize(model.pageSize);
        }

        public final Collection<String> getReasons() {
            if (reasons instanceof SdkAutoConstructList) {
                return null;
            }
            return reasons;
        }

        public final void setReasons(Collection<String> reasons) {
            this.reasons = SuppressionListReasonsCopier.copy(reasons);
        }

        @Override
        public final Builder reasonsWithStrings(Collection<String> reasons) {
            this.reasons = SuppressionListReasonsCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonsWithStrings(String... reasons) {
            reasonsWithStrings(Arrays.asList(reasons));
            return this;
        }

        @Override
        public final Builder reasons(Collection<SuppressionListReason> reasons) {
            this.reasons = SuppressionListReasonsCopier.copyEnumToString(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(SuppressionListReason... reasons) {
            reasons(Arrays.asList(reasons));
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSuppressedDestinationsRequest build() {
            return new ListSuppressedDestinationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
