/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata and attachment raw content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Attachment implements SdkPojo, Serializable, ToCopyableBuilder<Attachment.Builder, Attachment> {
    private static final SdkField<SdkBytes> RAW_CONTENT_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("RawContent").getter(getter(Attachment::rawContent)).setter(setter(Builder::rawContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawContent").build()).build();

    private static final SdkField<String> CONTENT_DISPOSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentDisposition").getter(getter(Attachment::contentDispositionAsString))
            .setter(setter(Builder::contentDisposition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentDisposition").build())
            .build();

    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileName").getter(getter(Attachment::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileName").build()).build();

    private static final SdkField<String> CONTENT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentDescription").getter(getter(Attachment::contentDescription))
            .setter(setter(Builder::contentDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentDescription").build())
            .build();

    private static final SdkField<String> CONTENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentId").getter(getter(Attachment::contentId)).setter(setter(Builder::contentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentId").build()).build();

    private static final SdkField<String> CONTENT_TRANSFER_ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentTransferEncoding").getter(getter(Attachment::contentTransferEncodingAsString))
            .setter(setter(Builder::contentTransferEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentTransferEncoding").build())
            .build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(Attachment::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RAW_CONTENT_FIELD,
            CONTENT_DISPOSITION_FIELD, FILE_NAME_FIELD, CONTENT_DESCRIPTION_FIELD, CONTENT_ID_FIELD,
            CONTENT_TRANSFER_ENCODING_FIELD, CONTENT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SdkBytes rawContent;

    private final String contentDisposition;

    private final String fileName;

    private final String contentDescription;

    private final String contentId;

    private final String contentTransferEncoding;

    private final String contentType;

    private Attachment(BuilderImpl builder) {
        this.rawContent = builder.rawContent;
        this.contentDisposition = builder.contentDisposition;
        this.fileName = builder.fileName;
        this.contentDescription = builder.contentDescription;
        this.contentId = builder.contentId;
        this.contentTransferEncoding = builder.contentTransferEncoding;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The raw data of the attachment. It needs to be base64-encoded if you are accessing Amazon SES directly through
     * the HTTPS interface. If you are accessing Amazon SES using an Amazon Web Services SDK, the SDK takes care of the
     * base 64-encoding for you.
     * </p>
     * 
     * @return The raw data of the attachment. It needs to be base64-encoded if you are accessing Amazon SES directly
     *         through the HTTPS interface. If you are accessing Amazon SES using an Amazon Web Services SDK, the SDK
     *         takes care of the base 64-encoding for you.
     */
    public final SdkBytes rawContent() {
        return rawContent;
    }

    /**
     * <p>
     * A standard descriptor indicating how the attachment should be rendered in the email. Supported values:
     * <code>ATTACHMENT</code> or <code>INLINE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentDisposition} will return {@link AttachmentContentDisposition#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contentDispositionAsString}.
     * </p>
     * 
     * @return A standard descriptor indicating how the attachment should be rendered in the email. Supported values:
     *         <code>ATTACHMENT</code> or <code>INLINE</code>.
     * @see AttachmentContentDisposition
     */
    public final AttachmentContentDisposition contentDisposition() {
        return AttachmentContentDisposition.fromValue(contentDisposition);
    }

    /**
     * <p>
     * A standard descriptor indicating how the attachment should be rendered in the email. Supported values:
     * <code>ATTACHMENT</code> or <code>INLINE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentDisposition} will return {@link AttachmentContentDisposition#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contentDispositionAsString}.
     * </p>
     * 
     * @return A standard descriptor indicating how the attachment should be rendered in the email. Supported values:
     *         <code>ATTACHMENT</code> or <code>INLINE</code>.
     * @see AttachmentContentDisposition
     */
    public final String contentDispositionAsString() {
        return contentDisposition;
    }

    /**
     * <p>
     * The file name for the attachment as it will appear in the email. Amazon SES restricts certain file extensions. To
     * ensure attachments are accepted, check the <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/mime-types.html">Unsupported attachment types</a> in the Amazon
     * SES Developer Guide.
     * </p>
     * 
     * @return The file name for the attachment as it will appear in the email. Amazon SES restricts certain file
     *         extensions. To ensure attachments are accepted, check the <a
     *         href="https://docs.aws.amazon.com/ses/latest/dg/mime-types.html">Unsupported attachment types</a> in the
     *         Amazon SES Developer Guide.
     */
    public final String fileName() {
        return fileName;
    }

    /**
     * <p>
     * A brief description of the attachment content.
     * </p>
     * 
     * @return A brief description of the attachment content.
     */
    public final String contentDescription() {
        return contentDescription;
    }

    /**
     * <p>
     * Unique identifier for the attachment, used for referencing attachments with INLINE disposition in HTML content.
     * </p>
     * 
     * @return Unique identifier for the attachment, used for referencing attachments with INLINE disposition in HTML
     *         content.
     */
    public final String contentId() {
        return contentId;
    }

    /**
     * <p>
     * Specifies how the attachment is encoded. Supported values: <code>BASE64</code>, <code>QUOTED_PRINTABLE</code>,
     * <code>SEVEN_BIT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentTransferEncoding} will return {@link AttachmentContentTransferEncoding#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #contentTransferEncodingAsString}.
     * </p>
     * 
     * @return Specifies how the attachment is encoded. Supported values: <code>BASE64</code>,
     *         <code>QUOTED_PRINTABLE</code>, <code>SEVEN_BIT</code>.
     * @see AttachmentContentTransferEncoding
     */
    public final AttachmentContentTransferEncoding contentTransferEncoding() {
        return AttachmentContentTransferEncoding.fromValue(contentTransferEncoding);
    }

    /**
     * <p>
     * Specifies how the attachment is encoded. Supported values: <code>BASE64</code>, <code>QUOTED_PRINTABLE</code>,
     * <code>SEVEN_BIT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentTransferEncoding} will return {@link AttachmentContentTransferEncoding#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #contentTransferEncodingAsString}.
     * </p>
     * 
     * @return Specifies how the attachment is encoded. Supported values: <code>BASE64</code>,
     *         <code>QUOTED_PRINTABLE</code>, <code>SEVEN_BIT</code>.
     * @see AttachmentContentTransferEncoding
     */
    public final String contentTransferEncodingAsString() {
        return contentTransferEncoding;
    }

    /**
     * <p>
     * The MIME type of the attachment.
     * </p>
     * <note>
     * <p>
     * Example: <code>application/pdf</code>, <code>image/jpeg</code>
     * </p>
     * </note>
     * 
     * @return The MIME type of the attachment.</p> <note>
     *         <p>
     *         Example: <code>application/pdf</code>, <code>image/jpeg</code>
     *         </p>
     */
    public final String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(contentDispositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        hashCode = 31 * hashCode + Objects.hashCode(contentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(contentId());
        hashCode = 31 * hashCode + Objects.hashCode(contentTransferEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment) obj;
        return Objects.equals(rawContent(), other.rawContent())
                && Objects.equals(contentDispositionAsString(), other.contentDispositionAsString())
                && Objects.equals(fileName(), other.fileName())
                && Objects.equals(contentDescription(), other.contentDescription())
                && Objects.equals(contentId(), other.contentId())
                && Objects.equals(contentTransferEncodingAsString(), other.contentTransferEncodingAsString())
                && Objects.equals(contentType(), other.contentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Attachment").add("RawContent", rawContent())
                .add("ContentDisposition", contentDispositionAsString()).add("FileName", fileName())
                .add("ContentDescription", contentDescription()).add("ContentId", contentId())
                .add("ContentTransferEncoding", contentTransferEncodingAsString()).add("ContentType", contentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RawContent":
            return Optional.ofNullable(clazz.cast(rawContent()));
        case "ContentDisposition":
            return Optional.ofNullable(clazz.cast(contentDispositionAsString()));
        case "FileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        case "ContentDescription":
            return Optional.ofNullable(clazz.cast(contentDescription()));
        case "ContentId":
            return Optional.ofNullable(clazz.cast(contentId()));
        case "ContentTransferEncoding":
            return Optional.ofNullable(clazz.cast(contentTransferEncodingAsString()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RawContent", RAW_CONTENT_FIELD);
        map.put("ContentDisposition", CONTENT_DISPOSITION_FIELD);
        map.put("FileName", FILE_NAME_FIELD);
        map.put("ContentDescription", CONTENT_DESCRIPTION_FIELD);
        map.put("ContentId", CONTENT_ID_FIELD);
        map.put("ContentTransferEncoding", CONTENT_TRANSFER_ENCODING_FIELD);
        map.put("ContentType", CONTENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Attachment, T> g) {
        return obj -> g.apply((Attachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Attachment> {
        /**
         * <p>
         * The raw data of the attachment. It needs to be base64-encoded if you are accessing Amazon SES directly
         * through the HTTPS interface. If you are accessing Amazon SES using an Amazon Web Services SDK, the SDK takes
         * care of the base 64-encoding for you.
         * </p>
         * 
         * @param rawContent
         *        The raw data of the attachment. It needs to be base64-encoded if you are accessing Amazon SES directly
         *        through the HTTPS interface. If you are accessing Amazon SES using an Amazon Web Services SDK, the SDK
         *        takes care of the base 64-encoding for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawContent(SdkBytes rawContent);

        /**
         * <p>
         * A standard descriptor indicating how the attachment should be rendered in the email. Supported values:
         * <code>ATTACHMENT</code> or <code>INLINE</code>.
         * </p>
         * 
         * @param contentDisposition
         *        A standard descriptor indicating how the attachment should be rendered in the email. Supported values:
         *        <code>ATTACHMENT</code> or <code>INLINE</code>.
         * @see AttachmentContentDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentContentDisposition
         */
        Builder contentDisposition(String contentDisposition);

        /**
         * <p>
         * A standard descriptor indicating how the attachment should be rendered in the email. Supported values:
         * <code>ATTACHMENT</code> or <code>INLINE</code>.
         * </p>
         * 
         * @param contentDisposition
         *        A standard descriptor indicating how the attachment should be rendered in the email. Supported values:
         *        <code>ATTACHMENT</code> or <code>INLINE</code>.
         * @see AttachmentContentDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentContentDisposition
         */
        Builder contentDisposition(AttachmentContentDisposition contentDisposition);

        /**
         * <p>
         * The file name for the attachment as it will appear in the email. Amazon SES restricts certain file
         * extensions. To ensure attachments are accepted, check the <a
         * href="https://docs.aws.amazon.com/ses/latest/dg/mime-types.html">Unsupported attachment types</a> in the
         * Amazon SES Developer Guide.
         * </p>
         * 
         * @param fileName
         *        The file name for the attachment as it will appear in the email. Amazon SES restricts certain file
         *        extensions. To ensure attachments are accepted, check the <a
         *        href="https://docs.aws.amazon.com/ses/latest/dg/mime-types.html">Unsupported attachment types</a> in
         *        the Amazon SES Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p>
         * A brief description of the attachment content.
         * </p>
         * 
         * @param contentDescription
         *        A brief description of the attachment content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentDescription(String contentDescription);

        /**
         * <p>
         * Unique identifier for the attachment, used for referencing attachments with INLINE disposition in HTML
         * content.
         * </p>
         * 
         * @param contentId
         *        Unique identifier for the attachment, used for referencing attachments with INLINE disposition in HTML
         *        content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentId(String contentId);

        /**
         * <p>
         * Specifies how the attachment is encoded. Supported values: <code>BASE64</code>, <code>QUOTED_PRINTABLE</code>, <code>SEVEN_BIT</code>.
         * </p>
         * 
         * @param contentTransferEncoding
         *        Specifies how the attachment is encoded. Supported values: <code>BASE64</code>,
         *        <code>QUOTED_PRINTABLE</code>, <code>SEVEN_BIT</code>.
         * @see AttachmentContentTransferEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentContentTransferEncoding
         */
        Builder contentTransferEncoding(String contentTransferEncoding);

        /**
         * <p>
         * Specifies how the attachment is encoded. Supported values: <code>BASE64</code>, <code>QUOTED_PRINTABLE</code>, <code>SEVEN_BIT</code>.
         * </p>
         * 
         * @param contentTransferEncoding
         *        Specifies how the attachment is encoded. Supported values: <code>BASE64</code>,
         *        <code>QUOTED_PRINTABLE</code>, <code>SEVEN_BIT</code>.
         * @see AttachmentContentTransferEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentContentTransferEncoding
         */
        Builder contentTransferEncoding(AttachmentContentTransferEncoding contentTransferEncoding);

        /**
         * <p>
         * The MIME type of the attachment.
         * </p>
         * <note>
         * <p>
         * Example: <code>application/pdf</code>, <code>image/jpeg</code>
         * </p>
         * </note>
         * 
         * @param contentType
         *        The MIME type of the attachment.</p> <note>
         *        <p>
         *        Example: <code>application/pdf</code>, <code>image/jpeg</code>
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes rawContent;

        private String contentDisposition;

        private String fileName;

        private String contentDescription;

        private String contentId;

        private String contentTransferEncoding;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(Attachment model) {
            rawContent(model.rawContent);
            contentDisposition(model.contentDisposition);
            fileName(model.fileName);
            contentDescription(model.contentDescription);
            contentId(model.contentId);
            contentTransferEncoding(model.contentTransferEncoding);
            contentType(model.contentType);
        }

        public final ByteBuffer getRawContent() {
            return rawContent == null ? null : rawContent.asByteBuffer();
        }

        public final void setRawContent(ByteBuffer rawContent) {
            rawContent(rawContent == null ? null : SdkBytes.fromByteBuffer(rawContent));
        }

        @Override
        public final Builder rawContent(SdkBytes rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final String getContentDisposition() {
            return contentDisposition;
        }

        public final void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        @Override
        public final Builder contentDisposition(AttachmentContentDisposition contentDisposition) {
            this.contentDisposition(contentDisposition == null ? null : contentDisposition.toString());
            return this;
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getContentDescription() {
            return contentDescription;
        }

        public final void setContentDescription(String contentDescription) {
            this.contentDescription = contentDescription;
        }

        @Override
        public final Builder contentDescription(String contentDescription) {
            this.contentDescription = contentDescription;
            return this;
        }

        public final String getContentId() {
            return contentId;
        }

        public final void setContentId(String contentId) {
            this.contentId = contentId;
        }

        @Override
        public final Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public final String getContentTransferEncoding() {
            return contentTransferEncoding;
        }

        public final void setContentTransferEncoding(String contentTransferEncoding) {
            this.contentTransferEncoding = contentTransferEncoding;
        }

        @Override
        public final Builder contentTransferEncoding(String contentTransferEncoding) {
            this.contentTransferEncoding = contentTransferEncoding;
            return this;
        }

        @Override
        public final Builder contentTransferEncoding(AttachmentContentTransferEncoding contentTransferEncoding) {
            this.contentTransferEncoding(contentTransferEncoding == null ? null : contentTransferEncoding.toString());
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public Attachment build() {
            return new Attachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
