/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the email message that you're sending. The <code>Message</code> object consists of a subject line and a
 * message body.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Message implements SdkPojo, Serializable, ToCopyableBuilder<Message.Builder, Message> {
    private static final SdkField<Content> SUBJECT_FIELD = SdkField.<Content> builder(MarshallingType.SDK_POJO)
            .memberName("Subject").getter(getter(Message::subject)).setter(setter(Builder::subject))
            .constructor(Content::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<Body> BODY_FIELD = SdkField.<Body> builder(MarshallingType.SDK_POJO).memberName("Body")
            .getter(getter(Message::body)).setter(setter(Builder::body)).constructor(Body::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<List<MessageHeader>> HEADERS_FIELD = SdkField
            .<List<MessageHeader>> builder(MarshallingType.LIST)
            .memberName("Headers")
            .getter(getter(Message::headers))
            .setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageHeader> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageHeader::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Attachment>> ATTACHMENTS_FIELD = SdkField
            .<List<Attachment>> builder(MarshallingType.LIST)
            .memberName("Attachments")
            .getter(getter(Message::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD, BODY_FIELD,
            HEADERS_FIELD, ATTACHMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Content subject;

    private final Body body;

    private final List<MessageHeader> headers;

    private final List<Attachment> attachments;

    private Message(BuilderImpl builder) {
        this.subject = builder.subject;
        this.body = builder.body;
        this.headers = builder.headers;
        this.attachments = builder.attachments;
    }

    /**
     * <p>
     * The subject line of the email. The subject line can only contain 7-bit ASCII characters. However, you can specify
     * non-ASCII characters in the subject line by using encoded-word syntax, as described in <a
     * href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>.
     * </p>
     * 
     * @return The subject line of the email. The subject line can only contain 7-bit ASCII characters. However, you can
     *         specify non-ASCII characters in the subject line by using encoded-word syntax, as described in <a
     *         href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>.
     */
    public final Content subject() {
        return subject;
    }

    /**
     * <p>
     * The body of the message. You can specify an HTML version of the message, a text-only version of the message, or
     * both.
     * </p>
     * 
     * @return The body of the message. You can specify an HTML version of the message, a text-only version of the
     *         message, or both.
     */
    public final Body body() {
        return body;
    }

    /**
     * For responses, this returns true if the service returned a value for the Headers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHeaders() {
        return headers != null && !(headers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of message headers that will be added to the email message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaders} method.
     * </p>
     * 
     * @return The list of message headers that will be added to the email message.
     */
    public final List<MessageHeader> headers() {
        return headers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The List of attachments to include in your email. All recipients will receive the same attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachments} method.
     * </p>
     * 
     * @return The List of attachments to include in your email. All recipients will receive the same attachments.
     */
    public final List<Attachment> attachments() {
        return attachments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaders() ? headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message) obj;
        return Objects.equals(subject(), other.subject()) && Objects.equals(body(), other.body())
                && hasHeaders() == other.hasHeaders() && Objects.equals(headers(), other.headers())
                && hasAttachments() == other.hasAttachments() && Objects.equals(attachments(), other.attachments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Message").add("Subject", subject()).add("Body", body())
                .add("Headers", hasHeaders() ? headers() : null).add("Attachments", hasAttachments() ? attachments() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "Headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "Attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Subject", SUBJECT_FIELD);
        map.put("Body", BODY_FIELD);
        map.put("Headers", HEADERS_FIELD);
        map.put("Attachments", ATTACHMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Message, T> g) {
        return obj -> g.apply((Message) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Message> {
        /**
         * <p>
         * The subject line of the email. The subject line can only contain 7-bit ASCII characters. However, you can
         * specify non-ASCII characters in the subject line by using encoded-word syntax, as described in <a
         * href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>.
         * </p>
         * 
         * @param subject
         *        The subject line of the email. The subject line can only contain 7-bit ASCII characters. However, you
         *        can specify non-ASCII characters in the subject line by using encoded-word syntax, as described in <a
         *        href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(Content subject);

        /**
         * <p>
         * The subject line of the email. The subject line can only contain 7-bit ASCII characters. However, you can
         * specify non-ASCII characters in the subject line by using encoded-word syntax, as described in <a
         * href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Content.Builder} avoiding the need to
         * create one manually via {@link Content#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Content.Builder#build()} is called immediately and its result is
         * passed to {@link #subject(Content)}.
         * 
         * @param subject
         *        a consumer that will call methods on {@link Content.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subject(Content)
         */
        default Builder subject(Consumer<Content.Builder> subject) {
            return subject(Content.builder().applyMutation(subject).build());
        }

        /**
         * <p>
         * The body of the message. You can specify an HTML version of the message, a text-only version of the message,
         * or both.
         * </p>
         * 
         * @param body
         *        The body of the message. You can specify an HTML version of the message, a text-only version of the
         *        message, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(Body body);

        /**
         * <p>
         * The body of the message. You can specify an HTML version of the message, a text-only version of the message,
         * or both.
         * </p>
         * This is a convenience method that creates an instance of the {@link Body.Builder} avoiding the need to create
         * one manually via {@link Body#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Body.Builder#build()} is called immediately and its result is
         * passed to {@link #body(Body)}.
         * 
         * @param body
         *        a consumer that will call methods on {@link Body.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #body(Body)
         */
        default Builder body(Consumer<Body.Builder> body) {
            return body(Body.builder().applyMutation(body).build());
        }

        /**
         * <p>
         * The list of message headers that will be added to the email message.
         * </p>
         * 
         * @param headers
         *        The list of message headers that will be added to the email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Collection<MessageHeader> headers);

        /**
         * <p>
         * The list of message headers that will be added to the email message.
         * </p>
         * 
         * @param headers
         *        The list of message headers that will be added to the email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(MessageHeader... headers);

        /**
         * <p>
         * The list of message headers that will be added to the email message.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.MessageHeader.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.MessageHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.MessageHeader.Builder#build()} is called immediately and
         * its result is passed to {@link #headers(List<MessageHeader>)}.
         * 
         * @param headers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.MessageHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headers(java.util.Collection<MessageHeader>)
         */
        Builder headers(Consumer<MessageHeader.Builder>... headers);

        /**
         * <p>
         * The List of attachments to include in your email. All recipients will receive the same attachments.
         * </p>
         * 
         * @param attachments
         *        The List of attachments to include in your email. All recipients will receive the same attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<Attachment> attachments);

        /**
         * <p>
         * The List of attachments to include in your email. All recipients will receive the same attachments.
         * </p>
         * 
         * @param attachments
         *        The List of attachments to include in your email. All recipients will receive the same attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Attachment... attachments);

        /**
         * <p>
         * The List of attachments to include in your email. All recipients will receive the same attachments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.Attachment.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.Attachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.Attachment.Builder#build()} is called immediately and its
         * result is passed to {@link #attachments(List<Attachment>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.Attachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(java.util.Collection<Attachment>)
         */
        Builder attachments(Consumer<Attachment.Builder>... attachments);
    }

    static final class BuilderImpl implements Builder {
        private Content subject;

        private Body body;

        private List<MessageHeader> headers = DefaultSdkAutoConstructList.getInstance();

        private List<Attachment> attachments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            subject(model.subject);
            body(model.body);
            headers(model.headers);
            attachments(model.attachments);
        }

        public final Content.Builder getSubject() {
            return subject != null ? subject.toBuilder() : null;
        }

        public final void setSubject(Content.BuilderImpl subject) {
            this.subject = subject != null ? subject.build() : null;
        }

        @Override
        public final Builder subject(Content subject) {
            this.subject = subject;
            return this;
        }

        public final Body.Builder getBody() {
            return body != null ? body.toBuilder() : null;
        }

        public final void setBody(Body.BuilderImpl body) {
            this.body = body != null ? body.build() : null;
        }

        @Override
        public final Builder body(Body body) {
            this.body = body;
            return this;
        }

        public final List<MessageHeader.Builder> getHeaders() {
            List<MessageHeader.Builder> result = MessageHeaderListCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<MessageHeader.BuilderImpl> headers) {
            this.headers = MessageHeaderListCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<MessageHeader> headers) {
            this.headers = MessageHeaderListCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(MessageHeader... headers) {
            headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<MessageHeader.Builder>... headers) {
            headers(Stream.of(headers).map(c -> MessageHeader.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Attachment.Builder> getAttachments() {
            List<Attachment.Builder> result = AttachmentListCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<Attachment.BuilderImpl> attachments) {
            this.attachments = AttachmentListCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<Attachment> attachments) {
            this.attachments = AttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Attachment... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<Attachment.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> Attachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Message build() {
            return new Message(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
