/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If the email identity is a domain, this object contains information about the DKIM verification status for the
 * domain.
 * </p>
 * <p>
 * If the email identity is an email address, this object is empty.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEmailIdentityResponse extends SesV2Response implements
        ToCopyableBuilder<CreateEmailIdentityResponse.Builder, CreateEmailIdentityResponse> {
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityType").getter(getter(CreateEmailIdentityResponse::identityTypeAsString))
            .setter(setter(Builder::identityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()).build();

    private static final SdkField<Boolean> VERIFIED_FOR_SENDING_STATUS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("VerifiedForSendingStatus")
            .getter(getter(CreateEmailIdentityResponse::verifiedForSendingStatus))
            .setter(setter(Builder::verifiedForSendingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedForSendingStatus").build())
            .build();

    private static final SdkField<DkimAttributes> DKIM_ATTRIBUTES_FIELD = SdkField
            .<DkimAttributes> builder(MarshallingType.SDK_POJO).memberName("DkimAttributes")
            .getter(getter(CreateEmailIdentityResponse::dkimAttributes)).setter(setter(Builder::dkimAttributes))
            .constructor(DkimAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_TYPE_FIELD,
            VERIFIED_FOR_SENDING_STATUS_FIELD, DKIM_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identityType;

    private final Boolean verifiedForSendingStatus;

    private final DkimAttributes dkimAttributes;

    private CreateEmailIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.identityType = builder.identityType;
        this.verifiedForSendingStatus = builder.verifiedForSendingStatus;
        this.dkimAttributes = builder.dkimAttributes;
    }

    /**
     * <p>
     * The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.
     * @see IdentityType
     */
    public final IdentityType identityType() {
        return IdentityType.fromValue(identityType);
    }

    /**
     * <p>
     * The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.
     * @see IdentityType
     */
    public final String identityTypeAsString() {
        return identityType;
    }

    /**
     * <p>
     * Specifies whether or not the identity is verified. You can only send email from verified email addresses or
     * domains. For more information about verifying identities, see the <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html">Amazon Pinpoint
     * User Guide</a>.
     * </p>
     * 
     * @return Specifies whether or not the identity is verified. You can only send email from verified email addresses
     *         or domains. For more information about verifying identities, see the <a
     *         href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html">Amazon
     *         Pinpoint User Guide</a>.
     */
    public final Boolean verifiedForSendingStatus() {
        return verifiedForSendingStatus;
    }

    /**
     * <p>
     * An object that contains information about the DKIM attributes for the identity.
     * </p>
     * 
     * @return An object that contains information about the DKIM attributes for the identity.
     */
    public final DkimAttributes dkimAttributes() {
        return dkimAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(verifiedForSendingStatus());
        hashCode = 31 * hashCode + Objects.hashCode(dkimAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEmailIdentityResponse)) {
            return false;
        }
        CreateEmailIdentityResponse other = (CreateEmailIdentityResponse) obj;
        return Objects.equals(identityTypeAsString(), other.identityTypeAsString())
                && Objects.equals(verifiedForSendingStatus(), other.verifiedForSendingStatus())
                && Objects.equals(dkimAttributes(), other.dkimAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEmailIdentityResponse").add("IdentityType", identityTypeAsString())
                .add("VerifiedForSendingStatus", verifiedForSendingStatus()).add("DkimAttributes", dkimAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityType":
            return Optional.ofNullable(clazz.cast(identityTypeAsString()));
        case "VerifiedForSendingStatus":
            return Optional.ofNullable(clazz.cast(verifiedForSendingStatus()));
        case "DkimAttributes":
            return Optional.ofNullable(clazz.cast(dkimAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityType", IDENTITY_TYPE_FIELD);
        map.put("VerifiedForSendingStatus", VERIFIED_FOR_SENDING_STATUS_FIELD);
        map.put("DkimAttributes", DKIM_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEmailIdentityResponse, T> g) {
        return obj -> g.apply((CreateEmailIdentityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateEmailIdentityResponse> {
        /**
         * <p>
         * The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.
         * </p>
         * 
         * @param identityType
         *        The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(String identityType);

        /**
         * <p>
         * The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.
         * </p>
         * 
         * @param identityType
         *        The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(IdentityType identityType);

        /**
         * <p>
         * Specifies whether or not the identity is verified. You can only send email from verified email addresses or
         * domains. For more information about verifying identities, see the <a
         * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html">Amazon
         * Pinpoint User Guide</a>.
         * </p>
         * 
         * @param verifiedForSendingStatus
         *        Specifies whether or not the identity is verified. You can only send email from verified email
         *        addresses or domains. For more information about verifying identities, see the <a
         *        href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html">Amazon
         *        Pinpoint User Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedForSendingStatus(Boolean verifiedForSendingStatus);

        /**
         * <p>
         * An object that contains information about the DKIM attributes for the identity.
         * </p>
         * 
         * @param dkimAttributes
         *        An object that contains information about the DKIM attributes for the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dkimAttributes(DkimAttributes dkimAttributes);

        /**
         * <p>
         * An object that contains information about the DKIM attributes for the identity.
         * </p>
         * This is a convenience method that creates an instance of the {@link DkimAttributes.Builder} avoiding the need
         * to create one manually via {@link DkimAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DkimAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #dkimAttributes(DkimAttributes)}.
         * 
         * @param dkimAttributes
         *        a consumer that will call methods on {@link DkimAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dkimAttributes(DkimAttributes)
         */
        default Builder dkimAttributes(Consumer<DkimAttributes.Builder> dkimAttributes) {
            return dkimAttributes(DkimAttributes.builder().applyMutation(dkimAttributes).build());
        }
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private String identityType;

        private Boolean verifiedForSendingStatus;

        private DkimAttributes dkimAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEmailIdentityResponse model) {
            super(model);
            identityType(model.identityType);
            verifiedForSendingStatus(model.verifiedForSendingStatus);
            dkimAttributes(model.dkimAttributes);
        }

        public final String getIdentityType() {
            return identityType;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final Boolean getVerifiedForSendingStatus() {
            return verifiedForSendingStatus;
        }

        public final void setVerifiedForSendingStatus(Boolean verifiedForSendingStatus) {
            this.verifiedForSendingStatus = verifiedForSendingStatus;
        }

        @Override
        public final Builder verifiedForSendingStatus(Boolean verifiedForSendingStatus) {
            this.verifiedForSendingStatus = verifiedForSendingStatus;
            return this;
        }

        public final DkimAttributes.Builder getDkimAttributes() {
            return dkimAttributes != null ? dkimAttributes.toBuilder() : null;
        }

        public final void setDkimAttributes(DkimAttributes.BuilderImpl dkimAttributes) {
            this.dkimAttributes = dkimAttributes != null ? dkimAttributes.build() : null;
        }

        @Override
        public final Builder dkimAttributes(DkimAttributes dkimAttributes) {
            this.dkimAttributes = dkimAttributes;
            return this;
        }

        @Override
        public CreateEmailIdentityResponse build() {
            return new CreateEmailIdentityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
