/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An email's insights contain metadata and delivery information about a specific email.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailInsights implements SdkPojo, Serializable, ToCopyableBuilder<EmailInsights.Builder, EmailInsights> {
    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(EmailInsights::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> ISP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Isp")
            .getter(getter(EmailInsights::isp)).setter(setter(Builder::isp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Isp").build()).build();

    private static final SdkField<List<InsightsEvent>> EVENTS_FIELD = SdkField
            .<List<InsightsEvent>> builder(MarshallingType.LIST)
            .memberName("Events")
            .getter(getter(EmailInsights::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InsightsEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(InsightsEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD, ISP_FIELD,
            EVENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destination;

    private final String isp;

    private final List<InsightsEvent> events;

    private EmailInsights(BuilderImpl builder) {
        this.destination = builder.destination;
        this.isp = builder.isp;
        this.events = builder.events;
    }

    /**
     * <p>
     * The recipient of the email.
     * </p>
     * 
     * @return The recipient of the email.
     */
    public final String destination() {
        return destination;
    }

    /**
     * <p>
     * The recipient's ISP (e.g., <code>Gmail</code>, <code>Yahoo</code>, etc.).
     * </p>
     * 
     * @return The recipient's ISP (e.g., <code>Gmail</code>, <code>Yahoo</code>, etc.).
     */
    public final String isp() {
        return isp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of events associated with the sent email.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return A list of events associated with the sent email.
     */
    public final List<InsightsEvent> events() {
        return events;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(isp());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailInsights)) {
            return false;
        }
        EmailInsights other = (EmailInsights) obj;
        return Objects.equals(destination(), other.destination()) && Objects.equals(isp(), other.isp())
                && hasEvents() == other.hasEvents() && Objects.equals(events(), other.events());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailInsights")
                .add("Destination", destination() == null ? null : "*** Sensitive Data Redacted ***").add("Isp", isp())
                .add("Events", hasEvents() ? events() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Isp":
            return Optional.ofNullable(clazz.cast(isp()));
        case "Events":
            return Optional.ofNullable(clazz.cast(events()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Destination", DESTINATION_FIELD);
        map.put("Isp", ISP_FIELD);
        map.put("Events", EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailInsights, T> g) {
        return obj -> g.apply((EmailInsights) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailInsights> {
        /**
         * <p>
         * The recipient of the email.
         * </p>
         * 
         * @param destination
         *        The recipient of the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The recipient's ISP (e.g., <code>Gmail</code>, <code>Yahoo</code>, etc.).
         * </p>
         * 
         * @param isp
         *        The recipient's ISP (e.g., <code>Gmail</code>, <code>Yahoo</code>, etc.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isp(String isp);

        /**
         * <p>
         * A list of events associated with the sent email.
         * </p>
         * 
         * @param events
         *        A list of events associated with the sent email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<InsightsEvent> events);

        /**
         * <p>
         * A list of events associated with the sent email.
         * </p>
         * 
         * @param events
         *        A list of events associated with the sent email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(InsightsEvent... events);

        /**
         * <p>
         * A list of events associated with the sent email.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.InsightsEvent.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.InsightsEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.InsightsEvent.Builder#build()} is called immediately and
         * its result is passed to {@link #events(List<InsightsEvent>)}.
         * 
         * @param events
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.InsightsEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(java.util.Collection<InsightsEvent>)
         */
        Builder events(Consumer<InsightsEvent.Builder>... events);
    }

    static final class BuilderImpl implements Builder {
        private String destination;

        private String isp;

        private List<InsightsEvent> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmailInsights model) {
            destination(model.destination);
            isp(model.isp);
            events(model.events);
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getIsp() {
            return isp;
        }

        public final void setIsp(String isp) {
            this.isp = isp;
        }

        @Override
        public final Builder isp(String isp) {
            this.isp = isp;
            return this;
        }

        public final List<InsightsEvent.Builder> getEvents() {
            List<InsightsEvent.Builder> result = InsightsEventsCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<InsightsEvent.BuilderImpl> events) {
            this.events = InsightsEventsCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Collection<InsightsEvent> events) {
            this.events = InsightsEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(InsightsEvent... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<InsightsEvent.Builder>... events) {
            events(Stream.of(events).map(c -> InsightsEvent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public EmailInsights build() {
            return new EmailInsights(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
