/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to add a custom domain for tracking open and click events to a configuration set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutConfigurationSetTrackingOptionsRequest extends SesV2Request implements
        ToCopyableBuilder<PutConfigurationSetTrackingOptionsRequest.Builder, PutConfigurationSetTrackingOptionsRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(PutConfigurationSetTrackingOptionsRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationSetName").build()).build();

    private static final SdkField<String> CUSTOM_REDIRECT_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomRedirectDomain").getter(getter(PutConfigurationSetTrackingOptionsRequest::customRedirectDomain))
            .setter(setter(Builder::customRedirectDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomRedirectDomain").build())
            .build();

    private static final SdkField<String> HTTPS_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HttpsPolicy").getter(getter(PutConfigurationSetTrackingOptionsRequest::httpsPolicyAsString))
            .setter(setter(Builder::httpsPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpsPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD,
            CUSTOM_REDIRECT_DOMAIN_FIELD, HTTPS_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configurationSetName;

    private final String customRedirectDomain;

    private final String httpsPolicy;

    private PutConfigurationSetTrackingOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.customRedirectDomain = builder.customRedirectDomain;
        this.httpsPolicy = builder.httpsPolicy;
    }

    /**
     * <p>
     * The name of the configuration set.
     * </p>
     * 
     * @return The name of the configuration set.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * The domain to use to track open and click events.
     * </p>
     * 
     * @return The domain to use to track open and click events.
     */
    public final String customRedirectDomain() {
        return customRedirectDomain;
    }

    /**
     * Returns the value of the HttpsPolicy property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpsPolicy} will
     * return {@link HttpsPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpsPolicyAsString}.
     * </p>
     * 
     * @return The value of the HttpsPolicy property for this object.
     * @see HttpsPolicy
     */
    public final HttpsPolicy httpsPolicy() {
        return HttpsPolicy.fromValue(httpsPolicy);
    }

    /**
     * Returns the value of the HttpsPolicy property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpsPolicy} will
     * return {@link HttpsPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpsPolicyAsString}.
     * </p>
     * 
     * @return The value of the HttpsPolicy property for this object.
     * @see HttpsPolicy
     */
    public final String httpsPolicyAsString() {
        return httpsPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(customRedirectDomain());
        hashCode = 31 * hashCode + Objects.hashCode(httpsPolicyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationSetTrackingOptionsRequest)) {
            return false;
        }
        PutConfigurationSetTrackingOptionsRequest other = (PutConfigurationSetTrackingOptionsRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(customRedirectDomain(), other.customRedirectDomain())
                && Objects.equals(httpsPolicyAsString(), other.httpsPolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutConfigurationSetTrackingOptionsRequest").add("ConfigurationSetName", configurationSetName())
                .add("CustomRedirectDomain", customRedirectDomain()).add("HttpsPolicy", httpsPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "CustomRedirectDomain":
            return Optional.ofNullable(clazz.cast(customRedirectDomain()));
        case "HttpsPolicy":
            return Optional.ofNullable(clazz.cast(httpsPolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("CustomRedirectDomain", CUSTOM_REDIRECT_DOMAIN_FIELD);
        map.put("HttpsPolicy", HTTPS_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutConfigurationSetTrackingOptionsRequest, T> g) {
        return obj -> g.apply((PutConfigurationSetTrackingOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SesV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutConfigurationSetTrackingOptionsRequest> {
        /**
         * <p>
         * The name of the configuration set.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * The domain to use to track open and click events.
         * </p>
         * 
         * @param customRedirectDomain
         *        The domain to use to track open and click events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRedirectDomain(String customRedirectDomain);

        /**
         * Sets the value of the HttpsPolicy property for this object.
         *
         * @param httpsPolicy
         *        The new value for the HttpsPolicy property for this object.
         * @see HttpsPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpsPolicy
         */
        Builder httpsPolicy(String httpsPolicy);

        /**
         * Sets the value of the HttpsPolicy property for this object.
         *
         * @param httpsPolicy
         *        The new value for the HttpsPolicy property for this object.
         * @see HttpsPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpsPolicy
         */
        Builder httpsPolicy(HttpsPolicy httpsPolicy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String configurationSetName;

        private String customRedirectDomain;

        private String httpsPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationSetTrackingOptionsRequest model) {
            super(model);
            configurationSetName(model.configurationSetName);
            customRedirectDomain(model.customRedirectDomain);
            httpsPolicy(model.httpsPolicy);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final String getCustomRedirectDomain() {
            return customRedirectDomain;
        }

        public final void setCustomRedirectDomain(String customRedirectDomain) {
            this.customRedirectDomain = customRedirectDomain;
        }

        @Override
        public final Builder customRedirectDomain(String customRedirectDomain) {
            this.customRedirectDomain = customRedirectDomain;
            return this;
        }

        public final String getHttpsPolicy() {
            return httpsPolicy;
        }

        public final void setHttpsPolicy(String httpsPolicy) {
            this.httpsPolicy = httpsPolicy;
        }

        @Override
        public final Builder httpsPolicy(String httpsPolicy) {
            this.httpsPolicy = httpsPolicy;
            return this;
        }

        @Override
        public final Builder httpsPolicy(HttpsPolicy httpsPolicy) {
            this.httpsPolicy(httpsPolicy == null ? null : httpsPolicy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigurationSetTrackingOptionsRequest build() {
            return new PutConfigurationSetTrackingOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
