/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains additional attributes that are related an email address that is on the suppression list for
 * your account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuppressedDestinationAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<SuppressedDestinationAttributes.Builder, SuppressedDestinationAttributes> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageId").getter(getter(SuppressedDestinationAttributes::messageId))
            .setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()).build();

    private static final SdkField<String> FEEDBACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeedbackId").getter(getter(SuppressedDestinationAttributes::feedbackId))
            .setter(setter(Builder::feedbackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD,
            FEEDBACK_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String messageId;

    private final String feedbackId;

    private SuppressedDestinationAttributes(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.feedbackId = builder.feedbackId;
    }

    /**
     * <p>
     * The unique identifier of the email message that caused the email address to be added to the suppression list for
     * your account.
     * </p>
     * 
     * @return The unique identifier of the email message that caused the email address to be added to the suppression
     *         list for your account.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * A unique identifier that's generated when an email address is added to the suppression list for your account.
     * </p>
     * 
     * @return A unique identifier that's generated when an email address is added to the suppression list for your
     *         account.
     */
    public final String feedbackId() {
        return feedbackId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuppressedDestinationAttributes)) {
            return false;
        }
        SuppressedDestinationAttributes other = (SuppressedDestinationAttributes) obj;
        return Objects.equals(messageId(), other.messageId()) && Objects.equals(feedbackId(), other.feedbackId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuppressedDestinationAttributes").add("MessageId", messageId()).add("FeedbackId", feedbackId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "FeedbackId":
            return Optional.ofNullable(clazz.cast(feedbackId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MessageId", MESSAGE_ID_FIELD);
        map.put("FeedbackId", FEEDBACK_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SuppressedDestinationAttributes, T> g) {
        return obj -> g.apply((SuppressedDestinationAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuppressedDestinationAttributes> {
        /**
         * <p>
         * The unique identifier of the email message that caused the email address to be added to the suppression list
         * for your account.
         * </p>
         * 
         * @param messageId
         *        The unique identifier of the email message that caused the email address to be added to the
         *        suppression list for your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * A unique identifier that's generated when an email address is added to the suppression list for your account.
         * </p>
         * 
         * @param feedbackId
         *        A unique identifier that's generated when an email address is added to the suppression list for your
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedbackId(String feedbackId);
    }

    static final class BuilderImpl implements Builder {
        private String messageId;

        private String feedbackId;

        private BuilderImpl() {
        }

        private BuilderImpl(SuppressedDestinationAttributes model) {
            messageId(model.messageId);
            feedbackId(model.feedbackId);
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getFeedbackId() {
            return feedbackId;
        }

        public final void setFeedbackId(String feedbackId) {
            this.feedbackId = feedbackId;
        }

        @Override
        public final Builder feedbackId(String feedbackId) {
            this.feedbackId = feedbackId;
            return this;
        }

        @Override
        public SuppressedDestinationAttributes build() {
            return new SuppressedDestinationAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
