/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to update the reputation management policy for a reputation entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateReputationEntityPolicyRequest extends SesV2Request implements
        ToCopyableBuilder<UpdateReputationEntityPolicyRequest.Builder, UpdateReputationEntityPolicyRequest> {
    private static final SdkField<String> REPUTATION_ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReputationEntityType").getter(getter(UpdateReputationEntityPolicyRequest::reputationEntityTypeAsString))
            .setter(setter(Builder::reputationEntityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ReputationEntityType").build()).build();

    private static final SdkField<String> REPUTATION_ENTITY_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReputationEntityReference")
            .getter(getter(UpdateReputationEntityPolicyRequest::reputationEntityReference))
            .setter(setter(Builder::reputationEntityReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ReputationEntityReference").build())
            .build();

    private static final SdkField<String> REPUTATION_ENTITY_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReputationEntityPolicy").getter(getter(UpdateReputationEntityPolicyRequest::reputationEntityPolicy))
            .setter(setter(Builder::reputationEntityPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReputationEntityPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPUTATION_ENTITY_TYPE_FIELD,
            REPUTATION_ENTITY_REFERENCE_FIELD, REPUTATION_ENTITY_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String reputationEntityType;

    private final String reputationEntityReference;

    private final String reputationEntityPolicy;

    private UpdateReputationEntityPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.reputationEntityType = builder.reputationEntityType;
        this.reputationEntityReference = builder.reputationEntityReference;
        this.reputationEntityPolicy = builder.reputationEntityPolicy;
    }

    /**
     * <p>
     * The type of reputation entity. Currently, only <code>RESOURCE</code> type entities are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #reputationEntityType} will return {@link ReputationEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #reputationEntityTypeAsString}.
     * </p>
     * 
     * @return The type of reputation entity. Currently, only <code>RESOURCE</code> type entities are supported.
     * @see ReputationEntityType
     */
    public final ReputationEntityType reputationEntityType() {
        return ReputationEntityType.fromValue(reputationEntityType);
    }

    /**
     * <p>
     * The type of reputation entity. Currently, only <code>RESOURCE</code> type entities are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #reputationEntityType} will return {@link ReputationEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #reputationEntityTypeAsString}.
     * </p>
     * 
     * @return The type of reputation entity. Currently, only <code>RESOURCE</code> type entities are supported.
     * @see ReputationEntityType
     */
    public final String reputationEntityTypeAsString() {
        return reputationEntityType;
    }

    /**
     * <p>
     * The unique identifier for the reputation entity. For resource-type entities, this is the Amazon Resource Name
     * (ARN) of the resource.
     * </p>
     * 
     * @return The unique identifier for the reputation entity. For resource-type entities, this is the Amazon Resource
     *         Name (ARN) of the resource.
     */
    public final String reputationEntityReference() {
        return reputationEntityReference;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the reputation management policy to apply to this entity. This is an Amazon Web
     * Services Amazon SES-managed policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the reputation management policy to apply to this entity. This is an
     *         Amazon Web Services Amazon SES-managed policy.
     */
    public final String reputationEntityPolicy() {
        return reputationEntityPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reputationEntityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reputationEntityReference());
        hashCode = 31 * hashCode + Objects.hashCode(reputationEntityPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReputationEntityPolicyRequest)) {
            return false;
        }
        UpdateReputationEntityPolicyRequest other = (UpdateReputationEntityPolicyRequest) obj;
        return Objects.equals(reputationEntityTypeAsString(), other.reputationEntityTypeAsString())
                && Objects.equals(reputationEntityReference(), other.reputationEntityReference())
                && Objects.equals(reputationEntityPolicy(), other.reputationEntityPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateReputationEntityPolicyRequest")
                .add("ReputationEntityType", reputationEntityTypeAsString())
                .add("ReputationEntityReference", reputationEntityReference())
                .add("ReputationEntityPolicy", reputationEntityPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReputationEntityType":
            return Optional.ofNullable(clazz.cast(reputationEntityTypeAsString()));
        case "ReputationEntityReference":
            return Optional.ofNullable(clazz.cast(reputationEntityReference()));
        case "ReputationEntityPolicy":
            return Optional.ofNullable(clazz.cast(reputationEntityPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReputationEntityType", REPUTATION_ENTITY_TYPE_FIELD);
        map.put("ReputationEntityReference", REPUTATION_ENTITY_REFERENCE_FIELD);
        map.put("ReputationEntityPolicy", REPUTATION_ENTITY_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateReputationEntityPolicyRequest, T> g) {
        return obj -> g.apply((UpdateReputationEntityPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateReputationEntityPolicyRequest> {
        /**
         * <p>
         * The type of reputation entity. Currently, only <code>RESOURCE</code> type entities are supported.
         * </p>
         * 
         * @param reputationEntityType
         *        The type of reputation entity. Currently, only <code>RESOURCE</code> type entities are supported.
         * @see ReputationEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReputationEntityType
         */
        Builder reputationEntityType(String reputationEntityType);

        /**
         * <p>
         * The type of reputation entity. Currently, only <code>RESOURCE</code> type entities are supported.
         * </p>
         * 
         * @param reputationEntityType
         *        The type of reputation entity. Currently, only <code>RESOURCE</code> type entities are supported.
         * @see ReputationEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReputationEntityType
         */
        Builder reputationEntityType(ReputationEntityType reputationEntityType);

        /**
         * <p>
         * The unique identifier for the reputation entity. For resource-type entities, this is the Amazon Resource Name
         * (ARN) of the resource.
         * </p>
         * 
         * @param reputationEntityReference
         *        The unique identifier for the reputation entity. For resource-type entities, this is the Amazon
         *        Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reputationEntityReference(String reputationEntityReference);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the reputation management policy to apply to this entity. This is an Amazon
         * Web Services Amazon SES-managed policy.
         * </p>
         * 
         * @param reputationEntityPolicy
         *        The Amazon Resource Name (ARN) of the reputation management policy to apply to this entity. This is an
         *        Amazon Web Services Amazon SES-managed policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reputationEntityPolicy(String reputationEntityPolicy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String reputationEntityType;

        private String reputationEntityReference;

        private String reputationEntityPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReputationEntityPolicyRequest model) {
            super(model);
            reputationEntityType(model.reputationEntityType);
            reputationEntityReference(model.reputationEntityReference);
            reputationEntityPolicy(model.reputationEntityPolicy);
        }

        public final String getReputationEntityType() {
            return reputationEntityType;
        }

        public final void setReputationEntityType(String reputationEntityType) {
            this.reputationEntityType = reputationEntityType;
        }

        @Override
        public final Builder reputationEntityType(String reputationEntityType) {
            this.reputationEntityType = reputationEntityType;
            return this;
        }

        @Override
        public final Builder reputationEntityType(ReputationEntityType reputationEntityType) {
            this.reputationEntityType(reputationEntityType == null ? null : reputationEntityType.toString());
            return this;
        }

        public final String getReputationEntityReference() {
            return reputationEntityReference;
        }

        public final void setReputationEntityReference(String reputationEntityReference) {
            this.reputationEntityReference = reputationEntityReference;
        }

        @Override
        public final Builder reputationEntityReference(String reputationEntityReference) {
            this.reputationEntityReference = reputationEntityReference;
            return this;
        }

        public final String getReputationEntityPolicy() {
            return reputationEntityPolicy;
        }

        public final void setReputationEntityPolicy(String reputationEntityPolicy) {
            this.reputationEntityPolicy = reputationEntityPolicy;
        }

        @Override
        public final Builder reputationEntityPolicy(String reputationEntityPolicy) {
            this.reputationEntityPolicy = reputationEntityPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateReputationEntityPolicyRequest build() {
            return new UpdateReputationEntityPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
