/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListTenantResourcesRequest;
import software.amazon.awssdk.services.sesv2.model.ListTenantResourcesResponse;
import software.amazon.awssdk.services.sesv2.model.TenantResource;

public class ListTenantResourcesIterable
implements SdkIterable<ListTenantResourcesResponse> {
    private final SesV2Client client;
    private final ListTenantResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTenantResourcesIterable(SesV2Client client, ListTenantResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTenantResourcesResponseFetcher();
    }

    public Iterator<ListTenantResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TenantResource> tenantResources() {
        Function<ListTenantResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tenantResources() != null) {
                return response.tenantResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTenantResourcesResponseFetcher
    implements SyncPageFetcher<ListTenantResourcesResponse> {
        private ListTenantResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListTenantResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTenantResourcesResponse nextPage(ListTenantResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListTenantResourcesIterable.this.client.listTenantResources(ListTenantResourcesIterable.this.firstRequest);
            }
            return ListTenantResourcesIterable.this.client.listTenantResources((ListTenantResourcesRequest)((Object)ListTenantResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

