/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2AsyncClient;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesRequest;
import software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesResponse;
import software.amazon.awssdk.services.sesv2.model.ReputationEntity;

public class ListReputationEntitiesPublisher
implements SdkPublisher<ListReputationEntitiesResponse> {
    private final SesV2AsyncClient client;
    private final ListReputationEntitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReputationEntitiesPublisher(SesV2AsyncClient client, ListReputationEntitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReputationEntitiesPublisher(SesV2AsyncClient client, ListReputationEntitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReputationEntitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReputationEntitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReputationEntity> reputationEntities() {
        Function<ListReputationEntitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.reputationEntities() != null) {
                return response.reputationEntities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReputationEntitiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReputationEntitiesResponseFetcher
    implements AsyncPageFetcher<ListReputationEntitiesResponse> {
        private ListReputationEntitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListReputationEntitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReputationEntitiesResponse> nextPage(ListReputationEntitiesResponse previousPage) {
            if (previousPage == null) {
                return ListReputationEntitiesPublisher.this.client.listReputationEntities(ListReputationEntitiesPublisher.this.firstRequest);
            }
            return ListReputationEntitiesPublisher.this.client.listReputationEntities((ListReputationEntitiesRequest)((Object)ListReputationEntitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

