/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * The filter key to use when listing reputation entities. This can be one of the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>ENTITY_TYPE</code> – Filter by entity type.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>REPUTATION_IMPACT</code> – Filter by reputation impact level.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>SENDING_STATUS</code> – Filter by aggregate sending status.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ENTITY_REFERENCE_PREFIX</code> – Filter by entity reference prefix.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public enum ReputationEntityFilterKey {
    ENTITY_TYPE("ENTITY_TYPE"),

    REPUTATION_IMPACT("REPUTATION_IMPACT"),

    SENDING_STATUS("SENDING_STATUS"),

    ENTITY_REFERENCE_PREFIX("ENTITY_REFERENCE_PREFIX"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReputationEntityFilterKey> VALUE_MAP = EnumUtils.uniqueIndex(
            ReputationEntityFilterKey.class, ReputationEntityFilterKey::toString);

    private final String value;

    private ReputationEntityFilterKey(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ReputationEntityFilterKey corresponding to the value
     */
    public static ReputationEntityFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ReputationEntityFilterKey}s
     */
    public static Set<ReputationEntityFilterKey> knownValues() {
        Set<ReputationEntityFilterKey> knownValues = EnumSet.allOf(ReputationEntityFilterKey.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
