/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains details about a tenant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Tenant implements SdkPojo, Serializable, ToCopyableBuilder<Tenant.Builder, Tenant> {
    private static final SdkField<String> TENANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantName").getter(getter(Tenant::tenantName)).setter(setter(Builder::tenantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantName").build()).build();

    private static final SdkField<String> TENANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantId").getter(getter(Tenant::tenantId)).setter(setter(Builder::tenantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantId").build()).build();

    private static final SdkField<String> TENANT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantArn").getter(getter(Tenant::tenantArn)).setter(setter(Builder::tenantArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantArn").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(Tenant::createdTimestamp)).setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Tenant::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SENDING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SendingStatus").getter(getter(Tenant::sendingStatusAsString)).setter(setter(Builder::sendingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_NAME_FIELD,
            TENANT_ID_FIELD, TENANT_ARN_FIELD, CREATED_TIMESTAMP_FIELD, TAGS_FIELD, SENDING_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tenantName;

    private final String tenantId;

    private final String tenantArn;

    private final Instant createdTimestamp;

    private final List<Tag> tags;

    private final String sendingStatus;

    private Tenant(BuilderImpl builder) {
        this.tenantName = builder.tenantName;
        this.tenantId = builder.tenantId;
        this.tenantArn = builder.tenantArn;
        this.createdTimestamp = builder.createdTimestamp;
        this.tags = builder.tags;
        this.sendingStatus = builder.sendingStatus;
    }

    /**
     * <p>
     * The name of the tenant.
     * </p>
     * 
     * @return The name of the tenant.
     */
    public final String tenantName() {
        return tenantName;
    }

    /**
     * <p>
     * A unique identifier for the tenant.
     * </p>
     * 
     * @return A unique identifier for the tenant.
     */
    public final String tenantId() {
        return tenantId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the tenant.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the tenant.
     */
    public final String tenantArn() {
        return tenantArn;
    }

    /**
     * <p>
     * The date and time when the tenant was created.
     * </p>
     * 
     * @return The date and time when the tenant was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that define the tags (keys and values) associated with the tenant.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of objects that define the tags (keys and values) associated with the tenant.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The status of sending capability for the tenant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sendingStatus}
     * will return {@link SendingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sendingStatusAsString}.
     * </p>
     * 
     * @return The status of sending capability for the tenant.
     * @see SendingStatus
     */
    public final SendingStatus sendingStatus() {
        return SendingStatus.fromValue(sendingStatus);
    }

    /**
     * <p>
     * The status of sending capability for the tenant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sendingStatus}
     * will return {@link SendingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sendingStatusAsString}.
     * </p>
     * 
     * @return The status of sending capability for the tenant.
     * @see SendingStatus
     */
    public final String sendingStatusAsString() {
        return sendingStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tenantName());
        hashCode = 31 * hashCode + Objects.hashCode(tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(tenantArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sendingStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tenant)) {
            return false;
        }
        Tenant other = (Tenant) obj;
        return Objects.equals(tenantName(), other.tenantName()) && Objects.equals(tenantId(), other.tenantId())
                && Objects.equals(tenantArn(), other.tenantArn()) && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(sendingStatusAsString(), other.sendingStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Tenant").add("TenantName", tenantName()).add("TenantId", tenantId())
                .add("TenantArn", tenantArn()).add("CreatedTimestamp", createdTimestamp()).add("Tags", hasTags() ? tags() : null)
                .add("SendingStatus", sendingStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TenantName":
            return Optional.ofNullable(clazz.cast(tenantName()));
        case "TenantId":
            return Optional.ofNullable(clazz.cast(tenantId()));
        case "TenantArn":
            return Optional.ofNullable(clazz.cast(tenantArn()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SendingStatus":
            return Optional.ofNullable(clazz.cast(sendingStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TenantName", TENANT_NAME_FIELD);
        map.put("TenantId", TENANT_ID_FIELD);
        map.put("TenantArn", TENANT_ARN_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("SendingStatus", SENDING_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Tenant, T> g) {
        return obj -> g.apply((Tenant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Tenant> {
        /**
         * <p>
         * The name of the tenant.
         * </p>
         * 
         * @param tenantName
         *        The name of the tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantName(String tenantName);

        /**
         * <p>
         * A unique identifier for the tenant.
         * </p>
         * 
         * @param tenantId
         *        A unique identifier for the tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantId(String tenantId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the tenant.
         * </p>
         * 
         * @param tenantArn
         *        The Amazon Resource Name (ARN) of the tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantArn(String tenantArn);

        /**
         * <p>
         * The date and time when the tenant was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The date and time when the tenant was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * An array of objects that define the tags (keys and values) associated with the tenant.
         * </p>
         * 
         * @param tags
         *        An array of objects that define the tags (keys and values) associated with the tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of objects that define the tags (keys and values) associated with the tenant.
         * </p>
         * 
         * @param tags
         *        An array of objects that define the tags (keys and values) associated with the tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of objects that define the tags (keys and values) associated with the tenant.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.sesv2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.sesv2.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.sesv2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The status of sending capability for the tenant.
         * </p>
         * 
         * @param sendingStatus
         *        The status of sending capability for the tenant.
         * @see SendingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SendingStatus
         */
        Builder sendingStatus(String sendingStatus);

        /**
         * <p>
         * The status of sending capability for the tenant.
         * </p>
         * 
         * @param sendingStatus
         *        The status of sending capability for the tenant.
         * @see SendingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SendingStatus
         */
        Builder sendingStatus(SendingStatus sendingStatus);
    }

    static final class BuilderImpl implements Builder {
        private String tenantName;

        private String tenantId;

        private String tenantArn;

        private Instant createdTimestamp;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String sendingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Tenant model) {
            tenantName(model.tenantName);
            tenantId(model.tenantId);
            tenantArn(model.tenantArn);
            createdTimestamp(model.createdTimestamp);
            tags(model.tags);
            sendingStatus(model.sendingStatus);
        }

        public final String getTenantName() {
            return tenantName;
        }

        public final void setTenantName(String tenantName) {
            this.tenantName = tenantName;
        }

        @Override
        public final Builder tenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        public final String getTenantId() {
            return tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getTenantArn() {
            return tenantArn;
        }

        public final void setTenantArn(String tenantArn) {
            this.tenantArn = tenantArn;
        }

        @Override
        public final Builder tenantArn(String tenantArn) {
            this.tenantArn = tenantArn;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSendingStatus() {
            return sendingStatus;
        }

        public final void setSendingStatus(String sendingStatus) {
            this.sendingStatus = sendingStatus;
        }

        @Override
        public final Builder sendingStatus(String sendingStatus) {
            this.sendingStatus = sendingStatus;
            return this;
        }

        @Override
        public final Builder sendingStatus(SendingStatus sendingStatus) {
            this.sendingStatus(sendingStatus == null ? null : sendingStatus.toString());
            return this;
        }

        @Override
        public Tenant build() {
            return new Tenant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
