/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to associate a resource with a tenant.
 * </p>
 * <p>
 * Resources can be email identities, configuration sets, or email templates. When you associate a resource with a
 * tenant, you can use that resource when sending emails on behalf of that tenant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTenantResourceAssociationRequest extends SesV2Request implements
        ToCopyableBuilder<CreateTenantResourceAssociationRequest.Builder, CreateTenantResourceAssociationRequest> {
    private static final SdkField<String> TENANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantName").getter(getter(CreateTenantResourceAssociationRequest::tenantName))
            .setter(setter(Builder::tenantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantName").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(CreateTenantResourceAssociationRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_NAME_FIELD,
            RESOURCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String tenantName;

    private final String resourceArn;

    private CreateTenantResourceAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.tenantName = builder.tenantName;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * The name of the tenant to associate the resource with.
     * </p>
     * 
     * @return The name of the tenant to associate the resource with.
     */
    public final String tenantName() {
        return tenantName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource to associate with the tenant.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource to associate with the tenant.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tenantName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTenantResourceAssociationRequest)) {
            return false;
        }
        CreateTenantResourceAssociationRequest other = (CreateTenantResourceAssociationRequest) obj;
        return Objects.equals(tenantName(), other.tenantName()) && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTenantResourceAssociationRequest").add("TenantName", tenantName())
                .add("ResourceArn", resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TenantName":
            return Optional.ofNullable(clazz.cast(tenantName()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TenantName", TENANT_NAME_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTenantResourceAssociationRequest, T> g) {
        return obj -> g.apply((CreateTenantResourceAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SesV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTenantResourceAssociationRequest> {
        /**
         * <p>
         * The name of the tenant to associate the resource with.
         * </p>
         * 
         * @param tenantName
         *        The name of the tenant to associate the resource with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantName(String tenantName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource to associate with the tenant.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the resource to associate with the tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String tenantName;

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTenantResourceAssociationRequest model) {
            super(model);
            tenantName(model.tenantName);
            resourceArn(model.resourceArn);
        }

        public final String getTenantName() {
            return tenantName;
        }

        public final void setTenantName(String tenantName) {
            this.tenantName = tenantName;
        }

        @Override
        public final Builder tenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTenantResourceAssociationRequest build() {
            return new CreateTenantResourceAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
