/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about tenants associated with your account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTenantsResponse extends SesV2Response implements
        ToCopyableBuilder<ListTenantsResponse.Builder, ListTenantsResponse> {
    private static final SdkField<List<TenantInfo>> TENANTS_FIELD = SdkField
            .<List<TenantInfo>> builder(MarshallingType.LIST)
            .memberName("Tenants")
            .getter(getter(ListTenantsResponse::tenants))
            .setter(setter(Builder::tenants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TenantInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(TenantInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTenantsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TenantInfo> tenants;

    private final String nextToken;

    private ListTenantsResponse(BuilderImpl builder) {
        super(builder);
        this.tenants = builder.tenants;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tenants property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTenants() {
        return tenants != null && !(tenants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains basic information about each tenant.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTenants} method.
     * </p>
     * 
     * @return An array that contains basic information about each tenant.
     */
    public final List<TenantInfo> tenants() {
        return tenants;
    }

    /**
     * <p>
     * A token that indicates that there are additional tenants to list. To view additional tenants, issue another
     * request to <code>ListTenants</code>, and pass this token in the <code>NextToken</code> parameter.
     * </p>
     * 
     * @return A token that indicates that there are additional tenants to list. To view additional tenants, issue
     *         another request to <code>ListTenants</code>, and pass this token in the <code>NextToken</code> parameter.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTenants() ? tenants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTenantsResponse)) {
            return false;
        }
        ListTenantsResponse other = (ListTenantsResponse) obj;
        return hasTenants() == other.hasTenants() && Objects.equals(tenants(), other.tenants())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTenantsResponse").add("Tenants", hasTenants() ? tenants() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tenants":
            return Optional.ofNullable(clazz.cast(tenants()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Tenants", TENANTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTenantsResponse, T> g) {
        return obj -> g.apply((ListTenantsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListTenantsResponse> {
        /**
         * <p>
         * An array that contains basic information about each tenant.
         * </p>
         * 
         * @param tenants
         *        An array that contains basic information about each tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenants(Collection<TenantInfo> tenants);

        /**
         * <p>
         * An array that contains basic information about each tenant.
         * </p>
         * 
         * @param tenants
         *        An array that contains basic information about each tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenants(TenantInfo... tenants);

        /**
         * <p>
         * An array that contains basic information about each tenant.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.TenantInfo.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.TenantInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.TenantInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #tenants(List<TenantInfo>)}.
         * 
         * @param tenants
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.TenantInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tenants(java.util.Collection<TenantInfo>)
         */
        Builder tenants(Consumer<TenantInfo.Builder>... tenants);

        /**
         * <p>
         * A token that indicates that there are additional tenants to list. To view additional tenants, issue another
         * request to <code>ListTenants</code>, and pass this token in the <code>NextToken</code> parameter.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates that there are additional tenants to list. To view additional tenants, issue
         *        another request to <code>ListTenants</code>, and pass this token in the <code>NextToken</code>
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private List<TenantInfo> tenants = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTenantsResponse model) {
            super(model);
            tenants(model.tenants);
            nextToken(model.nextToken);
        }

        public final List<TenantInfo.Builder> getTenants() {
            List<TenantInfo.Builder> result = TenantInfoListCopier.copyToBuilder(this.tenants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTenants(Collection<TenantInfo.BuilderImpl> tenants) {
            this.tenants = TenantInfoListCopier.copyFromBuilder(tenants);
        }

        @Override
        public final Builder tenants(Collection<TenantInfo> tenants) {
            this.tenants = TenantInfoListCopier.copy(tenants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tenants(TenantInfo... tenants) {
            tenants(Arrays.asList(tenants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tenants(Consumer<TenantInfo.Builder>... tenants) {
            tenants(Stream.of(tenants).map(c -> TenantInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTenantsResponse build() {
            return new ListTenantsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
