/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.SesV2ServiceClientConfiguration;
import software.amazon.awssdk.services.sesv2.internal.SesV2ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.sesv2.model.AccountSuspendedException;
import software.amazon.awssdk.services.sesv2.model.AlreadyExistsException;
import software.amazon.awssdk.services.sesv2.model.BadRequestException;
import software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataRequest;
import software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataResponse;
import software.amazon.awssdk.services.sesv2.model.CancelExportJobRequest;
import software.amazon.awssdk.services.sesv2.model.CancelExportJobResponse;
import software.amazon.awssdk.services.sesv2.model.ConcurrentModificationException;
import software.amazon.awssdk.services.sesv2.model.ConflictException;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.CreateContactListRequest;
import software.amazon.awssdk.services.sesv2.model.CreateContactListResponse;
import software.amazon.awssdk.services.sesv2.model.CreateContactRequest;
import software.amazon.awssdk.services.sesv2.model.CreateContactResponse;
import software.amazon.awssdk.services.sesv2.model.CreateCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.CreateCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolRequest;
import software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolResponse;
import software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityPolicyRequest;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityPolicyResponse;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.CreateEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.CreateEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.CreateExportJobRequest;
import software.amazon.awssdk.services.sesv2.model.CreateExportJobResponse;
import software.amazon.awssdk.services.sesv2.model.CreateImportJobRequest;
import software.amazon.awssdk.services.sesv2.model.CreateImportJobResponse;
import software.amazon.awssdk.services.sesv2.model.CreateMultiRegionEndpointRequest;
import software.amazon.awssdk.services.sesv2.model.CreateMultiRegionEndpointResponse;
import software.amazon.awssdk.services.sesv2.model.CreateTenantRequest;
import software.amazon.awssdk.services.sesv2.model.CreateTenantResourceAssociationRequest;
import software.amazon.awssdk.services.sesv2.model.CreateTenantResourceAssociationResponse;
import software.amazon.awssdk.services.sesv2.model.CreateTenantResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteContactListRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteContactListResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteContactRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteContactResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityPolicyRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityPolicyResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteMultiRegionEndpointRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteMultiRegionEndpointResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteSuppressedDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteSuppressedDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteTenantRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteTenantResourceAssociationRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteTenantResourceAssociationResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteTenantResponse;
import software.amazon.awssdk.services.sesv2.model.GetAccountRequest;
import software.amazon.awssdk.services.sesv2.model.GetAccountResponse;
import software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsRequest;
import software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsResponse;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsRequest;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsResponse;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.GetContactListRequest;
import software.amazon.awssdk.services.sesv2.model.GetContactListResponse;
import software.amazon.awssdk.services.sesv2.model.GetContactRequest;
import software.amazon.awssdk.services.sesv2.model.GetContactResponse;
import software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolResponse;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpResponse;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignRequest;
import software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignResponse;
import software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportRequest;
import software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportResponse;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesRequest;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesResponse;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.GetEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.GetEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.GetExportJobRequest;
import software.amazon.awssdk.services.sesv2.model.GetExportJobResponse;
import software.amazon.awssdk.services.sesv2.model.GetImportJobRequest;
import software.amazon.awssdk.services.sesv2.model.GetImportJobResponse;
import software.amazon.awssdk.services.sesv2.model.GetMessageInsightsRequest;
import software.amazon.awssdk.services.sesv2.model.GetMessageInsightsResponse;
import software.amazon.awssdk.services.sesv2.model.GetMultiRegionEndpointRequest;
import software.amazon.awssdk.services.sesv2.model.GetMultiRegionEndpointResponse;
import software.amazon.awssdk.services.sesv2.model.GetReputationEntityRequest;
import software.amazon.awssdk.services.sesv2.model.GetReputationEntityResponse;
import software.amazon.awssdk.services.sesv2.model.GetSuppressedDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.GetSuppressedDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.GetTenantRequest;
import software.amazon.awssdk.services.sesv2.model.GetTenantResponse;
import software.amazon.awssdk.services.sesv2.model.InternalServiceErrorException;
import software.amazon.awssdk.services.sesv2.model.InvalidNextTokenException;
import software.amazon.awssdk.services.sesv2.model.LimitExceededException;
import software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest;
import software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsResponse;
import software.amazon.awssdk.services.sesv2.model.ListContactListsRequest;
import software.amazon.awssdk.services.sesv2.model.ListContactListsResponse;
import software.amazon.awssdk.services.sesv2.model.ListContactsRequest;
import software.amazon.awssdk.services.sesv2.model.ListContactsResponse;
import software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest;
import software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse;
import software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse;
import software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse;
import software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse;
import software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest;
import software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse;
import software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest;
import software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse;
import software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest;
import software.amazon.awssdk.services.sesv2.model.ListExportJobsResponse;
import software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest;
import software.amazon.awssdk.services.sesv2.model.ListImportJobsResponse;
import software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsRequest;
import software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsResponse;
import software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.sesv2.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesRequest;
import software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesResponse;
import software.amazon.awssdk.services.sesv2.model.ListResourceTenantsRequest;
import software.amazon.awssdk.services.sesv2.model.ListResourceTenantsResponse;
import software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest;
import software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse;
import software.amazon.awssdk.services.sesv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.sesv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.sesv2.model.ListTenantResourcesRequest;
import software.amazon.awssdk.services.sesv2.model.ListTenantResourcesResponse;
import software.amazon.awssdk.services.sesv2.model.ListTenantsRequest;
import software.amazon.awssdk.services.sesv2.model.ListTenantsResponse;
import software.amazon.awssdk.services.sesv2.model.MailFromDomainNotVerifiedException;
import software.amazon.awssdk.services.sesv2.model.MessageRejectedException;
import software.amazon.awssdk.services.sesv2.model.NotFoundException;
import software.amazon.awssdk.services.sesv2.model.PutAccountDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountDetailsRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountDetailsResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountSuppressionAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountSuppressionAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountVdmAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountVdmAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetArchivingOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetArchivingOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSuppressionOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSuppressionOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetVdmOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetVdmOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpInPoolRequest;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpInPoolResponse;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpPoolScalingAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpPoolScalingAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionRequest;
import software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityConfigurationSetAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutSuppressedDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.PutSuppressedDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.SendBulkEmailRequest;
import software.amazon.awssdk.services.sesv2.model.SendBulkEmailResponse;
import software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailRequest;
import software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailResponse;
import software.amazon.awssdk.services.sesv2.model.SendEmailRequest;
import software.amazon.awssdk.services.sesv2.model.SendEmailResponse;
import software.amazon.awssdk.services.sesv2.model.SendingPausedException;
import software.amazon.awssdk.services.sesv2.model.SesV2Exception;
import software.amazon.awssdk.services.sesv2.model.TagResourceRequest;
import software.amazon.awssdk.services.sesv2.model.TagResourceResponse;
import software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.TooManyRequestsException;
import software.amazon.awssdk.services.sesv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.sesv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateContactListRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateContactListResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateContactRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateContactResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateEmailIdentityPolicyRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateEmailIdentityPolicyResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateReputationEntityCustomerManagedStatusRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateReputationEntityCustomerManagedStatusResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateReputationEntityPolicyRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateReputationEntityPolicyResponse;
import software.amazon.awssdk.services.sesv2.transform.BatchGetMetricDataRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CancelExportJobRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateContactListRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateContactRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateCustomVerificationEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateDedicatedIpPoolRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateDeliverabilityTestReportRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateEmailIdentityPolicyRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateExportJobRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateImportJobRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateMultiRegionEndpointRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateTenantRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateTenantResourceAssociationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteContactListRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteContactRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteCustomVerificationEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteDedicatedIpPoolRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteEmailIdentityPolicyRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteMultiRegionEndpointRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteSuppressedDestinationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteTenantRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteTenantResourceAssociationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetAccountRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetBlacklistReportsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetConfigurationSetEventDestinationsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetContactListRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetContactRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetCustomVerificationEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDedicatedIpPoolRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDedicatedIpRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDedicatedIpsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDeliverabilityDashboardOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDeliverabilityTestReportRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDomainDeliverabilityCampaignRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDomainStatisticsReportRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetEmailIdentityPoliciesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetExportJobRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetImportJobRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetMessageInsightsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetMultiRegionEndpointRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetReputationEntityRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetSuppressedDestinationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetTenantRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListConfigurationSetsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListContactListsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListContactsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListCustomVerificationEmailTemplatesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListDedicatedIpPoolsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListDeliverabilityTestReportsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListDomainDeliverabilityCampaignsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListEmailIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListEmailTemplatesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListExportJobsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListImportJobsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListMultiRegionEndpointsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListReputationEntitiesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListResourceTenantsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListSuppressedDestinationsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListTenantResourcesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListTenantsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutAccountDedicatedIpWarmupAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutAccountDetailsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutAccountSendingAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutAccountSuppressionAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutAccountVdmAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetArchivingOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetDeliveryOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetReputationOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetSendingOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetSuppressionOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetTrackingOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetVdmOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutDedicatedIpInPoolRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutDedicatedIpPoolScalingAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutDedicatedIpWarmupAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutDeliverabilityDashboardOptionRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutEmailIdentityConfigurationSetAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutEmailIdentityDkimAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutEmailIdentityDkimSigningAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutEmailIdentityFeedbackAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutEmailIdentityMailFromAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutSuppressedDestinationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.SendBulkEmailRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.SendCustomVerificationEmailRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.SendEmailRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.TestRenderEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UpdateConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UpdateContactListRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UpdateContactRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UpdateCustomVerificationEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UpdateEmailIdentityPolicyRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UpdateEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UpdateReputationEntityCustomerManagedStatusRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UpdateReputationEntityPolicyRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultSesV2Client
implements SesV2Client {
    private static final Logger log = Logger.loggerFor(DefaultSesV2Client.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSesV2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"SESv2#2.34.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetMetricDataResponse batchGetMetricData(BatchGetMetricDataRequest batchGetMetricDataRequest) throws BadRequestException, InternalServiceErrorException, TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetMetricDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetMetricDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, batchGetMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetMetricData");
            BatchGetMetricDataResponse batchGetMetricDataResponse = (BatchGetMetricDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetMetricData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchGetMetricDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetMetricDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$batchGetMetricData$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelExportJobResponse cancelExportJob(CancelExportJobRequest cancelExportJobRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelExportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelExportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, cancelExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelExportJob");
            CancelExportJobResponse cancelExportJobResponse = (CancelExportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelExportJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelExportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelExportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$cancelExportJob$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConfigurationSetResponse createConfigurationSet(CreateConfigurationSetRequest createConfigurationSetRequest) throws AlreadyExistsException, NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConfigurationSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createConfigurationSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, createConfigurationSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConfigurationSet");
            CreateConfigurationSetResponse createConfigurationSetResponse = (CreateConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createConfigurationSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConfigurationSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConfigurationSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$createConfigurationSet$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConfigurationSetEventDestinationResponse createConfigurationSetEventDestination(CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest) throws NotFoundException, AlreadyExistsException, LimitExceededException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConfigurationSetEventDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createConfigurationSetEventDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, createConfigurationSetEventDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConfigurationSetEventDestination");
            CreateConfigurationSetEventDestinationResponse createConfigurationSetEventDestinationResponse = (CreateConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationSetEventDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createConfigurationSetEventDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConfigurationSetEventDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConfigurationSetEventDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$createConfigurationSetEventDestination$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateContactResponse createContact(CreateContactRequest createContactRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, AlreadyExistsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateContactResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createContactRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, createContactRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateContact");
            CreateContactResponse createContactResponse = (CreateContactResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateContact").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createContactRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateContactRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createContactResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$createContact$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateContactListResponse createContactList(CreateContactListRequest createContactListRequest) throws BadRequestException, TooManyRequestsException, AlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateContactListResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createContactListRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, createContactListRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateContactList");
            CreateContactListResponse createContactListResponse = (CreateContactListResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateContactList").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createContactListRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateContactListRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createContactListResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$createContactList$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCustomVerificationEmailTemplateResponse createCustomVerificationEmailTemplate(CreateCustomVerificationEmailTemplateRequest createCustomVerificationEmailTemplateRequest) throws BadRequestException, AlreadyExistsException, NotFoundException, TooManyRequestsException, LimitExceededException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomVerificationEmailTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCustomVerificationEmailTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, createCustomVerificationEmailTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomVerificationEmailTemplate");
            CreateCustomVerificationEmailTemplateResponse createCustomVerificationEmailTemplateResponse = (CreateCustomVerificationEmailTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomVerificationEmailTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createCustomVerificationEmailTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCustomVerificationEmailTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCustomVerificationEmailTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$createCustomVerificationEmailTemplate$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDedicatedIpPoolResponse createDedicatedIpPool(CreateDedicatedIpPoolRequest createDedicatedIpPoolRequest) throws AlreadyExistsException, LimitExceededException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDedicatedIpPoolResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDedicatedIpPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, createDedicatedIpPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDedicatedIpPool");
            CreateDedicatedIpPoolResponse createDedicatedIpPoolResponse = (CreateDedicatedIpPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDedicatedIpPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDedicatedIpPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDedicatedIpPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDedicatedIpPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$createDedicatedIpPool$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDeliverabilityTestReportResponse createDeliverabilityTestReport(CreateDeliverabilityTestReportRequest createDeliverabilityTestReportRequest) throws AccountSuspendedException, SendingPausedException, MessageRejectedException, MailFromDomainNotVerifiedException, NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDeliverabilityTestReportResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDeliverabilityTestReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, createDeliverabilityTestReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDeliverabilityTestReport");
            CreateDeliverabilityTestReportResponse createDeliverabilityTestReportResponse = (CreateDeliverabilityTestReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDeliverabilityTestReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDeliverabilityTestReportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDeliverabilityTestReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDeliverabilityTestReportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$createDeliverabilityTestReport$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEmailIdentityResponse createEmailIdentity(CreateEmailIdentityRequest createEmailIdentityRequest) throws AlreadyExistsException, LimitExceededException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEmailIdentityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEmailIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, createEmailIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEmailIdentity");
            CreateEmailIdentityResponse createEmailIdentityResponse = (CreateEmailIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEmailIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createEmailIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEmailIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEmailIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$createEmailIdentity$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEmailIdentityPolicyResponse createEmailIdentityPolicy(CreateEmailIdentityPolicyRequest createEmailIdentityPolicyRequest) throws NotFoundException, AlreadyExistsException, TooManyRequestsException, LimitExceededException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEmailIdentityPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEmailIdentityPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, createEmailIdentityPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEmailIdentityPolicy");
            CreateEmailIdentityPolicyResponse createEmailIdentityPolicyResponse = (CreateEmailIdentityPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEmailIdentityPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createEmailIdentityPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEmailIdentityPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEmailIdentityPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$createEmailIdentityPolicy$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEmailTemplateResponse createEmailTemplate(CreateEmailTemplateRequest createEmailTemplateRequest) throws AlreadyExistsException, TooManyRequestsException, BadRequestException, LimitExceededException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEmailTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEmailTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, createEmailTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEmailTemplate");
            CreateEmailTemplateResponse createEmailTemplateResponse = (CreateEmailTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEmailTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createEmailTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEmailTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEmailTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$createEmailTemplate$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateExportJobResponse createExportJob(CreateExportJobRequest createExportJobRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateExportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createExportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, createExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateExportJob");
            CreateExportJobResponse createExportJobResponse = (CreateExportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateExportJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createExportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createExportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$createExportJob$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateImportJobResponse createImportJob(CreateImportJobRequest createImportJobRequest) throws BadRequestException, LimitExceededException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createImportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, createImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateImportJob");
            CreateImportJobResponse createImportJobResponse = (CreateImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateImportJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$createImportJob$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMultiRegionEndpointResponse createMultiRegionEndpoint(CreateMultiRegionEndpointRequest createMultiRegionEndpointRequest) throws LimitExceededException, TooManyRequestsException, AlreadyExistsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMultiRegionEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createMultiRegionEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, createMultiRegionEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMultiRegionEndpoint");
            CreateMultiRegionEndpointResponse createMultiRegionEndpointResponse = (CreateMultiRegionEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMultiRegionEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createMultiRegionEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMultiRegionEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMultiRegionEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$createMultiRegionEndpoint$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTenantResponse createTenant(CreateTenantRequest createTenantRequest) throws AlreadyExistsException, LimitExceededException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTenantResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTenantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, createTenantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTenant");
            CreateTenantResponse createTenantResponse = (CreateTenantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTenant").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTenantRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTenantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTenantResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$createTenant$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTenantResourceAssociationResponse createTenantResourceAssociation(CreateTenantResourceAssociationRequest createTenantResourceAssociationRequest) throws AlreadyExistsException, NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTenantResourceAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTenantResourceAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, createTenantResourceAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTenantResourceAssociation");
            CreateTenantResourceAssociationResponse createTenantResourceAssociationResponse = (CreateTenantResourceAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTenantResourceAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTenantResourceAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTenantResourceAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTenantResourceAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$createTenantResourceAssociation$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConfigurationSetResponse deleteConfigurationSet(DeleteConfigurationSetRequest deleteConfigurationSetRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigurationSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConfigurationSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, deleteConfigurationSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfigurationSet");
            DeleteConfigurationSetResponse deleteConfigurationSetResponse = (DeleteConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteConfigurationSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConfigurationSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConfigurationSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$deleteConfigurationSet$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConfigurationSetEventDestinationResponse deleteConfigurationSetEventDestination(DeleteConfigurationSetEventDestinationRequest deleteConfigurationSetEventDestinationRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigurationSetEventDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConfigurationSetEventDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, deleteConfigurationSetEventDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfigurationSetEventDestination");
            DeleteConfigurationSetEventDestinationResponse deleteConfigurationSetEventDestinationResponse = (DeleteConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationSetEventDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteConfigurationSetEventDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConfigurationSetEventDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConfigurationSetEventDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$deleteConfigurationSetEventDestination$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteContactResponse deleteContact(DeleteContactRequest deleteContactRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteContactResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteContactRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, deleteContactRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteContact");
            DeleteContactResponse deleteContactResponse = (DeleteContactResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteContact").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteContactRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteContactRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteContactResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$deleteContact$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteContactListResponse deleteContactList(DeleteContactListRequest deleteContactListRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteContactListResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteContactListRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, deleteContactListRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteContactList");
            DeleteContactListResponse deleteContactListResponse = (DeleteContactListResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteContactList").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteContactListRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteContactListRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteContactListResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$deleteContactList$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCustomVerificationEmailTemplateResponse deleteCustomVerificationEmailTemplate(DeleteCustomVerificationEmailTemplateRequest deleteCustomVerificationEmailTemplateRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomVerificationEmailTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCustomVerificationEmailTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, deleteCustomVerificationEmailTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomVerificationEmailTemplate");
            DeleteCustomVerificationEmailTemplateResponse deleteCustomVerificationEmailTemplateResponse = (DeleteCustomVerificationEmailTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomVerificationEmailTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteCustomVerificationEmailTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCustomVerificationEmailTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCustomVerificationEmailTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$deleteCustomVerificationEmailTemplate$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDedicatedIpPoolResponse deleteDedicatedIpPool(DeleteDedicatedIpPoolRequest deleteDedicatedIpPoolRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDedicatedIpPoolResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDedicatedIpPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, deleteDedicatedIpPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDedicatedIpPool");
            DeleteDedicatedIpPoolResponse deleteDedicatedIpPoolResponse = (DeleteDedicatedIpPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDedicatedIpPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDedicatedIpPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDedicatedIpPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDedicatedIpPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$deleteDedicatedIpPool$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEmailIdentityResponse deleteEmailIdentity(DeleteEmailIdentityRequest deleteEmailIdentityRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEmailIdentityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEmailIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, deleteEmailIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEmailIdentity");
            DeleteEmailIdentityResponse deleteEmailIdentityResponse = (DeleteEmailIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEmailIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteEmailIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEmailIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEmailIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$deleteEmailIdentity$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEmailIdentityPolicyResponse deleteEmailIdentityPolicy(DeleteEmailIdentityPolicyRequest deleteEmailIdentityPolicyRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEmailIdentityPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEmailIdentityPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, deleteEmailIdentityPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEmailIdentityPolicy");
            DeleteEmailIdentityPolicyResponse deleteEmailIdentityPolicyResponse = (DeleteEmailIdentityPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEmailIdentityPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteEmailIdentityPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEmailIdentityPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEmailIdentityPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$deleteEmailIdentityPolicy$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEmailTemplateResponse deleteEmailTemplate(DeleteEmailTemplateRequest deleteEmailTemplateRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEmailTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEmailTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, deleteEmailTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEmailTemplate");
            DeleteEmailTemplateResponse deleteEmailTemplateResponse = (DeleteEmailTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEmailTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteEmailTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEmailTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEmailTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$deleteEmailTemplate$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMultiRegionEndpointResponse deleteMultiRegionEndpoint(DeleteMultiRegionEndpointRequest deleteMultiRegionEndpointRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMultiRegionEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMultiRegionEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, deleteMultiRegionEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMultiRegionEndpoint");
            DeleteMultiRegionEndpointResponse deleteMultiRegionEndpointResponse = (DeleteMultiRegionEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMultiRegionEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteMultiRegionEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMultiRegionEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMultiRegionEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$deleteMultiRegionEndpoint$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSuppressedDestinationResponse deleteSuppressedDestination(DeleteSuppressedDestinationRequest deleteSuppressedDestinationRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSuppressedDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSuppressedDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, deleteSuppressedDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSuppressedDestination");
            DeleteSuppressedDestinationResponse deleteSuppressedDestinationResponse = (DeleteSuppressedDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSuppressedDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteSuppressedDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSuppressedDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSuppressedDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$deleteSuppressedDestination$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTenantResponse deleteTenant(DeleteTenantRequest deleteTenantRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTenantResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTenantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, deleteTenantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTenant");
            DeleteTenantResponse deleteTenantResponse = (DeleteTenantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTenant").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTenantRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTenantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTenantResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$deleteTenant$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTenantResourceAssociationResponse deleteTenantResourceAssociation(DeleteTenantResourceAssociationRequest deleteTenantResourceAssociationRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTenantResourceAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTenantResourceAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, deleteTenantResourceAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTenantResourceAssociation");
            DeleteTenantResourceAssociationResponse deleteTenantResourceAssociationResponse = (DeleteTenantResourceAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTenantResourceAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTenantResourceAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTenantResourceAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTenantResourceAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$deleteTenantResourceAssociation$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccountResponse getAccount(GetAccountRequest getAccountRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccount");
            GetAccountResponse getAccountResponse = (GetAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getAccount$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBlacklistReportsResponse getBlacklistReports(GetBlacklistReportsRequest getBlacklistReportsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBlacklistReportsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBlacklistReportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getBlacklistReportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBlacklistReports");
            GetBlacklistReportsResponse getBlacklistReportsResponse = (GetBlacklistReportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBlacklistReports").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBlacklistReportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBlacklistReportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBlacklistReportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getBlacklistReports$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetConfigurationSetResponse getConfigurationSet(GetConfigurationSetRequest getConfigurationSetRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConfigurationSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getConfigurationSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getConfigurationSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConfigurationSet");
            GetConfigurationSetResponse getConfigurationSetResponse = (GetConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConfigurationSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getConfigurationSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetConfigurationSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getConfigurationSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getConfigurationSet$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetConfigurationSetEventDestinationsResponse getConfigurationSetEventDestinations(GetConfigurationSetEventDestinationsRequest getConfigurationSetEventDestinationsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConfigurationSetEventDestinationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getConfigurationSetEventDestinationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getConfigurationSetEventDestinationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConfigurationSetEventDestinations");
            GetConfigurationSetEventDestinationsResponse getConfigurationSetEventDestinationsResponse = (GetConfigurationSetEventDestinationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConfigurationSetEventDestinations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getConfigurationSetEventDestinationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetConfigurationSetEventDestinationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getConfigurationSetEventDestinationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getConfigurationSetEventDestinations$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContactResponse getContact(GetContactRequest getContactRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContactResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContactRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getContactRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContact");
            GetContactResponse getContactResponse = (GetContactResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContact").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getContactRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetContactRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getContactResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getContact$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContactListResponse getContactList(GetContactListRequest getContactListRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContactListResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContactListRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getContactListRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContactList");
            GetContactListResponse getContactListResponse = (GetContactListResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContactList").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getContactListRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetContactListRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getContactListResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getContactList$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCustomVerificationEmailTemplateResponse getCustomVerificationEmailTemplate(GetCustomVerificationEmailTemplateRequest getCustomVerificationEmailTemplateRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCustomVerificationEmailTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCustomVerificationEmailTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getCustomVerificationEmailTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCustomVerificationEmailTemplate");
            GetCustomVerificationEmailTemplateResponse getCustomVerificationEmailTemplateResponse = (GetCustomVerificationEmailTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCustomVerificationEmailTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCustomVerificationEmailTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCustomVerificationEmailTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCustomVerificationEmailTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getCustomVerificationEmailTemplate$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDedicatedIpResponse getDedicatedIp(GetDedicatedIpRequest getDedicatedIpRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDedicatedIpResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDedicatedIpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getDedicatedIpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDedicatedIp");
            GetDedicatedIpResponse getDedicatedIpResponse = (GetDedicatedIpResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDedicatedIp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDedicatedIpRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDedicatedIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDedicatedIpResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getDedicatedIp$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDedicatedIpPoolResponse getDedicatedIpPool(GetDedicatedIpPoolRequest getDedicatedIpPoolRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDedicatedIpPoolResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDedicatedIpPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getDedicatedIpPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDedicatedIpPool");
            GetDedicatedIpPoolResponse getDedicatedIpPoolResponse = (GetDedicatedIpPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDedicatedIpPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDedicatedIpPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDedicatedIpPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDedicatedIpPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getDedicatedIpPool$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDedicatedIpsResponse getDedicatedIps(GetDedicatedIpsRequest getDedicatedIpsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDedicatedIpsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDedicatedIpsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getDedicatedIpsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDedicatedIps");
            GetDedicatedIpsResponse getDedicatedIpsResponse = (GetDedicatedIpsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDedicatedIps").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDedicatedIpsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDedicatedIpsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDedicatedIpsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getDedicatedIps$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDeliverabilityDashboardOptionsResponse getDeliverabilityDashboardOptions(GetDeliverabilityDashboardOptionsRequest getDeliverabilityDashboardOptionsRequest) throws TooManyRequestsException, LimitExceededException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDeliverabilityDashboardOptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDeliverabilityDashboardOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getDeliverabilityDashboardOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDeliverabilityDashboardOptions");
            GetDeliverabilityDashboardOptionsResponse getDeliverabilityDashboardOptionsResponse = (GetDeliverabilityDashboardOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDeliverabilityDashboardOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDeliverabilityDashboardOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDeliverabilityDashboardOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDeliverabilityDashboardOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getDeliverabilityDashboardOptions$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDeliverabilityTestReportResponse getDeliverabilityTestReport(GetDeliverabilityTestReportRequest getDeliverabilityTestReportRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDeliverabilityTestReportResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDeliverabilityTestReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getDeliverabilityTestReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDeliverabilityTestReport");
            GetDeliverabilityTestReportResponse getDeliverabilityTestReportResponse = (GetDeliverabilityTestReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDeliverabilityTestReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDeliverabilityTestReportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDeliverabilityTestReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDeliverabilityTestReportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getDeliverabilityTestReport$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDomainDeliverabilityCampaignResponse getDomainDeliverabilityCampaign(GetDomainDeliverabilityCampaignRequest getDomainDeliverabilityCampaignRequest) throws TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainDeliverabilityCampaignResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDomainDeliverabilityCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getDomainDeliverabilityCampaignRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomainDeliverabilityCampaign");
            GetDomainDeliverabilityCampaignResponse getDomainDeliverabilityCampaignResponse = (GetDomainDeliverabilityCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainDeliverabilityCampaign").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDomainDeliverabilityCampaignRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDomainDeliverabilityCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDomainDeliverabilityCampaignResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getDomainDeliverabilityCampaign$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDomainStatisticsReportResponse getDomainStatisticsReport(GetDomainStatisticsReportRequest getDomainStatisticsReportRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainStatisticsReportResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDomainStatisticsReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getDomainStatisticsReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomainStatisticsReport");
            GetDomainStatisticsReportResponse getDomainStatisticsReportResponse = (GetDomainStatisticsReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainStatisticsReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDomainStatisticsReportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDomainStatisticsReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDomainStatisticsReportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getDomainStatisticsReport$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEmailIdentityResponse getEmailIdentity(GetEmailIdentityRequest getEmailIdentityRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEmailIdentityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEmailIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getEmailIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEmailIdentity");
            GetEmailIdentityResponse getEmailIdentityResponse = (GetEmailIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEmailIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getEmailIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEmailIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEmailIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getEmailIdentity$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEmailIdentityPoliciesResponse getEmailIdentityPolicies(GetEmailIdentityPoliciesRequest getEmailIdentityPoliciesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEmailIdentityPoliciesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEmailIdentityPoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getEmailIdentityPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEmailIdentityPolicies");
            GetEmailIdentityPoliciesResponse getEmailIdentityPoliciesResponse = (GetEmailIdentityPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEmailIdentityPolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getEmailIdentityPoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEmailIdentityPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEmailIdentityPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getEmailIdentityPolicies$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEmailTemplateResponse getEmailTemplate(GetEmailTemplateRequest getEmailTemplateRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEmailTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEmailTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getEmailTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEmailTemplate");
            GetEmailTemplateResponse getEmailTemplateResponse = (GetEmailTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEmailTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getEmailTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEmailTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEmailTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getEmailTemplate$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetExportJobResponse getExportJob(GetExportJobRequest getExportJobRequest) throws BadRequestException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getExportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetExportJob");
            GetExportJobResponse getExportJobResponse = (GetExportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExportJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getExportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getExportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getExportJob$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetImportJobResponse getImportJob(GetImportJobRequest getImportJobRequest) throws BadRequestException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getImportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetImportJob");
            GetImportJobResponse getImportJobResponse = (GetImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetImportJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getImportJob$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMessageInsightsResponse getMessageInsights(GetMessageInsightsRequest getMessageInsightsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMessageInsightsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMessageInsightsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getMessageInsightsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMessageInsights");
            GetMessageInsightsResponse getMessageInsightsResponse = (GetMessageInsightsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMessageInsights").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getMessageInsightsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMessageInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMessageInsightsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getMessageInsights$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMultiRegionEndpointResponse getMultiRegionEndpoint(GetMultiRegionEndpointRequest getMultiRegionEndpointRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMultiRegionEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMultiRegionEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getMultiRegionEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMultiRegionEndpoint");
            GetMultiRegionEndpointResponse getMultiRegionEndpointResponse = (GetMultiRegionEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMultiRegionEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getMultiRegionEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMultiRegionEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMultiRegionEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getMultiRegionEndpoint$101((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReputationEntityResponse getReputationEntity(GetReputationEntityRequest getReputationEntityRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReputationEntityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getReputationEntityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getReputationEntityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReputationEntity");
            GetReputationEntityResponse getReputationEntityResponse = (GetReputationEntityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReputationEntity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getReputationEntityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReputationEntityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReputationEntityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getReputationEntity$103((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSuppressedDestinationResponse getSuppressedDestination(GetSuppressedDestinationRequest getSuppressedDestinationRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSuppressedDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSuppressedDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getSuppressedDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSuppressedDestination");
            GetSuppressedDestinationResponse getSuppressedDestinationResponse = (GetSuppressedDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSuppressedDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSuppressedDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSuppressedDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSuppressedDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getSuppressedDestination$105((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTenantResponse getTenant(GetTenantRequest getTenantRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTenantResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTenantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, getTenantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTenant");
            GetTenantResponse getTenantResponse = (GetTenantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTenant").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTenantRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTenantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTenantResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$getTenant$107((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConfigurationSetsResponse listConfigurationSets(ListConfigurationSetsRequest listConfigurationSetsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConfigurationSetsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listConfigurationSetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listConfigurationSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConfigurationSets");
            ListConfigurationSetsResponse listConfigurationSetsResponse = (ListConfigurationSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConfigurationSets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listConfigurationSetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListConfigurationSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listConfigurationSetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listConfigurationSets$109((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListContactListsResponse listContactLists(ListContactListsRequest listContactListsRequest) throws BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListContactListsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listContactListsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listContactListsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListContactLists");
            ListContactListsResponse listContactListsResponse = (ListContactListsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListContactLists").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listContactListsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListContactListsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listContactListsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listContactLists$111((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListContactsResponse listContacts(ListContactsRequest listContactsRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListContactsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listContactsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listContactsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListContacts");
            ListContactsResponse listContactsResponse = (ListContactsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListContacts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listContactsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListContactsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listContactsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listContacts$113((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCustomVerificationEmailTemplatesResponse listCustomVerificationEmailTemplates(ListCustomVerificationEmailTemplatesRequest listCustomVerificationEmailTemplatesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCustomVerificationEmailTemplatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCustomVerificationEmailTemplatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listCustomVerificationEmailTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCustomVerificationEmailTemplates");
            ListCustomVerificationEmailTemplatesResponse listCustomVerificationEmailTemplatesResponse = (ListCustomVerificationEmailTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomVerificationEmailTemplates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listCustomVerificationEmailTemplatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCustomVerificationEmailTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCustomVerificationEmailTemplatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listCustomVerificationEmailTemplates$115((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDedicatedIpPoolsResponse listDedicatedIpPools(ListDedicatedIpPoolsRequest listDedicatedIpPoolsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDedicatedIpPoolsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDedicatedIpPoolsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listDedicatedIpPoolsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDedicatedIpPools");
            ListDedicatedIpPoolsResponse listDedicatedIpPoolsResponse = (ListDedicatedIpPoolsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDedicatedIpPools").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDedicatedIpPoolsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDedicatedIpPoolsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDedicatedIpPoolsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listDedicatedIpPools$117((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDeliverabilityTestReportsResponse listDeliverabilityTestReports(ListDeliverabilityTestReportsRequest listDeliverabilityTestReportsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDeliverabilityTestReportsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDeliverabilityTestReportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listDeliverabilityTestReportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDeliverabilityTestReports");
            ListDeliverabilityTestReportsResponse listDeliverabilityTestReportsResponse = (ListDeliverabilityTestReportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDeliverabilityTestReports").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDeliverabilityTestReportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDeliverabilityTestReportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDeliverabilityTestReportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listDeliverabilityTestReports$119((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainDeliverabilityCampaignsResponse listDomainDeliverabilityCampaigns(ListDomainDeliverabilityCampaignsRequest listDomainDeliverabilityCampaignsRequest) throws TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainDeliverabilityCampaignsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDomainDeliverabilityCampaignsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listDomainDeliverabilityCampaignsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDomainDeliverabilityCampaigns");
            ListDomainDeliverabilityCampaignsResponse listDomainDeliverabilityCampaignsResponse = (ListDomainDeliverabilityCampaignsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomainDeliverabilityCampaigns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDomainDeliverabilityCampaignsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDomainDeliverabilityCampaignsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDomainDeliverabilityCampaignsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listDomainDeliverabilityCampaigns$121((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEmailIdentitiesResponse listEmailIdentities(ListEmailIdentitiesRequest listEmailIdentitiesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEmailIdentitiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEmailIdentitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listEmailIdentitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEmailIdentities");
            ListEmailIdentitiesResponse listEmailIdentitiesResponse = (ListEmailIdentitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEmailIdentities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEmailIdentitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEmailIdentitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEmailIdentitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listEmailIdentities$123((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEmailTemplatesResponse listEmailTemplates(ListEmailTemplatesRequest listEmailTemplatesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEmailTemplatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEmailTemplatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listEmailTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEmailTemplates");
            ListEmailTemplatesResponse listEmailTemplatesResponse = (ListEmailTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEmailTemplates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEmailTemplatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEmailTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEmailTemplatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listEmailTemplates$125((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExportJobsResponse listExportJobs(ListExportJobsRequest listExportJobsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExportJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listExportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listExportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExportJobs");
            ListExportJobsResponse listExportJobsResponse = (ListExportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExportJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listExportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListExportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listExportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listExportJobs$127((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListImportJobsResponse listImportJobs(ListImportJobsRequest listImportJobsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListImportJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listImportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listImportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListImportJobs");
            ListImportJobsResponse listImportJobsResponse = (ListImportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListImportJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listImportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListImportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listImportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listImportJobs$129((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMultiRegionEndpointsResponse listMultiRegionEndpoints(ListMultiRegionEndpointsRequest listMultiRegionEndpointsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMultiRegionEndpointsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listMultiRegionEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listMultiRegionEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMultiRegionEndpoints");
            ListMultiRegionEndpointsResponse listMultiRegionEndpointsResponse = (ListMultiRegionEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMultiRegionEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listMultiRegionEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMultiRegionEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMultiRegionEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listMultiRegionEndpoints$131((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecommendationsResponse listRecommendations(ListRecommendationsRequest listRecommendationsRequest) throws TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRecommendationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRecommendations");
            ListRecommendationsResponse listRecommendationsResponse = (ListRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRecommendations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listRecommendations$133((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReputationEntitiesResponse listReputationEntities(ListReputationEntitiesRequest listReputationEntitiesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReputationEntitiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listReputationEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listReputationEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReputationEntities");
            ListReputationEntitiesResponse listReputationEntitiesResponse = (ListReputationEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReputationEntities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listReputationEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReputationEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReputationEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listReputationEntities$135((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourceTenantsResponse listResourceTenants(ListResourceTenantsRequest listResourceTenantsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceTenantsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResourceTenantsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listResourceTenantsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceTenants");
            ListResourceTenantsResponse listResourceTenantsResponse = (ListResourceTenantsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceTenants").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listResourceTenantsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourceTenantsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourceTenantsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listResourceTenants$137((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSuppressedDestinationsResponse listSuppressedDestinations(ListSuppressedDestinationsRequest listSuppressedDestinationsRequest) throws BadRequestException, TooManyRequestsException, InvalidNextTokenException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSuppressedDestinationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSuppressedDestinationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listSuppressedDestinationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSuppressedDestinations");
            ListSuppressedDestinationsResponse listSuppressedDestinationsResponse = (ListSuppressedDestinationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSuppressedDestinations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSuppressedDestinationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSuppressedDestinationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSuppressedDestinationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listSuppressedDestinations$139((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listTagsForResource$141((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTenantResourcesResponse listTenantResources(ListTenantResourcesRequest listTenantResourcesRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTenantResourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTenantResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listTenantResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTenantResources");
            ListTenantResourcesResponse listTenantResourcesResponse = (ListTenantResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTenantResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTenantResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTenantResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTenantResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listTenantResources$143((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTenantsResponse listTenants(ListTenantsRequest listTenantsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTenantsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTenantsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, listTenantsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTenants");
            ListTenantsResponse listTenantsResponse = (ListTenantsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTenants").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTenantsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTenantsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTenantsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$listTenants$145((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccountDedicatedIpWarmupAttributesResponse putAccountDedicatedIpWarmupAttributes(PutAccountDedicatedIpWarmupAttributesRequest putAccountDedicatedIpWarmupAttributesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountDedicatedIpWarmupAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAccountDedicatedIpWarmupAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putAccountDedicatedIpWarmupAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountDedicatedIpWarmupAttributes");
            PutAccountDedicatedIpWarmupAttributesResponse putAccountDedicatedIpWarmupAttributesResponse = (PutAccountDedicatedIpWarmupAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountDedicatedIpWarmupAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAccountDedicatedIpWarmupAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAccountDedicatedIpWarmupAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAccountDedicatedIpWarmupAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putAccountDedicatedIpWarmupAttributes$147((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccountDetailsResponse putAccountDetails(PutAccountDetailsRequest putAccountDetailsRequest) throws TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountDetailsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAccountDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putAccountDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountDetails");
            PutAccountDetailsResponse putAccountDetailsResponse = (PutAccountDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAccountDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAccountDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAccountDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putAccountDetails$149((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccountSendingAttributesResponse putAccountSendingAttributes(PutAccountSendingAttributesRequest putAccountSendingAttributesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountSendingAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAccountSendingAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putAccountSendingAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountSendingAttributes");
            PutAccountSendingAttributesResponse putAccountSendingAttributesResponse = (PutAccountSendingAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountSendingAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAccountSendingAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAccountSendingAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAccountSendingAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putAccountSendingAttributes$151((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccountSuppressionAttributesResponse putAccountSuppressionAttributes(PutAccountSuppressionAttributesRequest putAccountSuppressionAttributesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountSuppressionAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAccountSuppressionAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putAccountSuppressionAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountSuppressionAttributes");
            PutAccountSuppressionAttributesResponse putAccountSuppressionAttributesResponse = (PutAccountSuppressionAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountSuppressionAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAccountSuppressionAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAccountSuppressionAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAccountSuppressionAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putAccountSuppressionAttributes$153((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccountVdmAttributesResponse putAccountVdmAttributes(PutAccountVdmAttributesRequest putAccountVdmAttributesRequest) throws BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountVdmAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAccountVdmAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putAccountVdmAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountVdmAttributes");
            PutAccountVdmAttributesResponse putAccountVdmAttributesResponse = (PutAccountVdmAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountVdmAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAccountVdmAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAccountVdmAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAccountVdmAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putAccountVdmAttributes$155((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutConfigurationSetArchivingOptionsResponse putConfigurationSetArchivingOptions(PutConfigurationSetArchivingOptionsRequest putConfigurationSetArchivingOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetArchivingOptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putConfigurationSetArchivingOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putConfigurationSetArchivingOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutConfigurationSetArchivingOptions");
            PutConfigurationSetArchivingOptionsResponse putConfigurationSetArchivingOptionsResponse = (PutConfigurationSetArchivingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetArchivingOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putConfigurationSetArchivingOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutConfigurationSetArchivingOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putConfigurationSetArchivingOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putConfigurationSetArchivingOptions$157((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutConfigurationSetDeliveryOptionsResponse putConfigurationSetDeliveryOptions(PutConfigurationSetDeliveryOptionsRequest putConfigurationSetDeliveryOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetDeliveryOptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putConfigurationSetDeliveryOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putConfigurationSetDeliveryOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutConfigurationSetDeliveryOptions");
            PutConfigurationSetDeliveryOptionsResponse putConfigurationSetDeliveryOptionsResponse = (PutConfigurationSetDeliveryOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetDeliveryOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putConfigurationSetDeliveryOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutConfigurationSetDeliveryOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putConfigurationSetDeliveryOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putConfigurationSetDeliveryOptions$159((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutConfigurationSetReputationOptionsResponse putConfigurationSetReputationOptions(PutConfigurationSetReputationOptionsRequest putConfigurationSetReputationOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetReputationOptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putConfigurationSetReputationOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putConfigurationSetReputationOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutConfigurationSetReputationOptions");
            PutConfigurationSetReputationOptionsResponse putConfigurationSetReputationOptionsResponse = (PutConfigurationSetReputationOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetReputationOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putConfigurationSetReputationOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutConfigurationSetReputationOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putConfigurationSetReputationOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putConfigurationSetReputationOptions$161((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutConfigurationSetSendingOptionsResponse putConfigurationSetSendingOptions(PutConfigurationSetSendingOptionsRequest putConfigurationSetSendingOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetSendingOptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putConfigurationSetSendingOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putConfigurationSetSendingOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutConfigurationSetSendingOptions");
            PutConfigurationSetSendingOptionsResponse putConfigurationSetSendingOptionsResponse = (PutConfigurationSetSendingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetSendingOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putConfigurationSetSendingOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutConfigurationSetSendingOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putConfigurationSetSendingOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putConfigurationSetSendingOptions$163((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutConfigurationSetSuppressionOptionsResponse putConfigurationSetSuppressionOptions(PutConfigurationSetSuppressionOptionsRequest putConfigurationSetSuppressionOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetSuppressionOptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putConfigurationSetSuppressionOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putConfigurationSetSuppressionOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutConfigurationSetSuppressionOptions");
            PutConfigurationSetSuppressionOptionsResponse putConfigurationSetSuppressionOptionsResponse = (PutConfigurationSetSuppressionOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetSuppressionOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putConfigurationSetSuppressionOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutConfigurationSetSuppressionOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putConfigurationSetSuppressionOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putConfigurationSetSuppressionOptions$165((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutConfigurationSetTrackingOptionsResponse putConfigurationSetTrackingOptions(PutConfigurationSetTrackingOptionsRequest putConfigurationSetTrackingOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetTrackingOptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putConfigurationSetTrackingOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putConfigurationSetTrackingOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutConfigurationSetTrackingOptions");
            PutConfigurationSetTrackingOptionsResponse putConfigurationSetTrackingOptionsResponse = (PutConfigurationSetTrackingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetTrackingOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putConfigurationSetTrackingOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutConfigurationSetTrackingOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putConfigurationSetTrackingOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putConfigurationSetTrackingOptions$167((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutConfigurationSetVdmOptionsResponse putConfigurationSetVdmOptions(PutConfigurationSetVdmOptionsRequest putConfigurationSetVdmOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetVdmOptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putConfigurationSetVdmOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putConfigurationSetVdmOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutConfigurationSetVdmOptions");
            PutConfigurationSetVdmOptionsResponse putConfigurationSetVdmOptionsResponse = (PutConfigurationSetVdmOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetVdmOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putConfigurationSetVdmOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutConfigurationSetVdmOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putConfigurationSetVdmOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putConfigurationSetVdmOptions$169((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutDedicatedIpInPoolResponse putDedicatedIpInPool(PutDedicatedIpInPoolRequest putDedicatedIpInPoolRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDedicatedIpInPoolResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putDedicatedIpInPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putDedicatedIpInPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDedicatedIpInPool");
            PutDedicatedIpInPoolResponse putDedicatedIpInPoolResponse = (PutDedicatedIpInPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDedicatedIpInPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putDedicatedIpInPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutDedicatedIpInPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putDedicatedIpInPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putDedicatedIpInPool$171((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutDedicatedIpPoolScalingAttributesResponse putDedicatedIpPoolScalingAttributes(PutDedicatedIpPoolScalingAttributesRequest putDedicatedIpPoolScalingAttributesRequest) throws NotFoundException, ConcurrentModificationException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDedicatedIpPoolScalingAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putDedicatedIpPoolScalingAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putDedicatedIpPoolScalingAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDedicatedIpPoolScalingAttributes");
            PutDedicatedIpPoolScalingAttributesResponse putDedicatedIpPoolScalingAttributesResponse = (PutDedicatedIpPoolScalingAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDedicatedIpPoolScalingAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putDedicatedIpPoolScalingAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutDedicatedIpPoolScalingAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putDedicatedIpPoolScalingAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putDedicatedIpPoolScalingAttributes$173((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutDedicatedIpWarmupAttributesResponse putDedicatedIpWarmupAttributes(PutDedicatedIpWarmupAttributesRequest putDedicatedIpWarmupAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDedicatedIpWarmupAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putDedicatedIpWarmupAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putDedicatedIpWarmupAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDedicatedIpWarmupAttributes");
            PutDedicatedIpWarmupAttributesResponse putDedicatedIpWarmupAttributesResponse = (PutDedicatedIpWarmupAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDedicatedIpWarmupAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putDedicatedIpWarmupAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutDedicatedIpWarmupAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putDedicatedIpWarmupAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putDedicatedIpWarmupAttributes$175((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutDeliverabilityDashboardOptionResponse putDeliverabilityDashboardOption(PutDeliverabilityDashboardOptionRequest putDeliverabilityDashboardOptionRequest) throws AlreadyExistsException, NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDeliverabilityDashboardOptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putDeliverabilityDashboardOptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putDeliverabilityDashboardOptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDeliverabilityDashboardOption");
            PutDeliverabilityDashboardOptionResponse putDeliverabilityDashboardOptionResponse = (PutDeliverabilityDashboardOptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDeliverabilityDashboardOption").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putDeliverabilityDashboardOptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutDeliverabilityDashboardOptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putDeliverabilityDashboardOptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putDeliverabilityDashboardOption$177((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutEmailIdentityConfigurationSetAttributesResponse putEmailIdentityConfigurationSetAttributes(PutEmailIdentityConfigurationSetAttributesRequest putEmailIdentityConfigurationSetAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityConfigurationSetAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putEmailIdentityConfigurationSetAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putEmailIdentityConfigurationSetAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEmailIdentityConfigurationSetAttributes");
            PutEmailIdentityConfigurationSetAttributesResponse putEmailIdentityConfigurationSetAttributesResponse = (PutEmailIdentityConfigurationSetAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityConfigurationSetAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putEmailIdentityConfigurationSetAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutEmailIdentityConfigurationSetAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putEmailIdentityConfigurationSetAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putEmailIdentityConfigurationSetAttributes$179((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutEmailIdentityDkimAttributesResponse putEmailIdentityDkimAttributes(PutEmailIdentityDkimAttributesRequest putEmailIdentityDkimAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityDkimAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putEmailIdentityDkimAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putEmailIdentityDkimAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEmailIdentityDkimAttributes");
            PutEmailIdentityDkimAttributesResponse putEmailIdentityDkimAttributesResponse = (PutEmailIdentityDkimAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityDkimAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putEmailIdentityDkimAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutEmailIdentityDkimAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putEmailIdentityDkimAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putEmailIdentityDkimAttributes$181((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutEmailIdentityDkimSigningAttributesResponse putEmailIdentityDkimSigningAttributes(PutEmailIdentityDkimSigningAttributesRequest putEmailIdentityDkimSigningAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityDkimSigningAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putEmailIdentityDkimSigningAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putEmailIdentityDkimSigningAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEmailIdentityDkimSigningAttributes");
            PutEmailIdentityDkimSigningAttributesResponse putEmailIdentityDkimSigningAttributesResponse = (PutEmailIdentityDkimSigningAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityDkimSigningAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putEmailIdentityDkimSigningAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutEmailIdentityDkimSigningAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putEmailIdentityDkimSigningAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putEmailIdentityDkimSigningAttributes$183((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutEmailIdentityFeedbackAttributesResponse putEmailIdentityFeedbackAttributes(PutEmailIdentityFeedbackAttributesRequest putEmailIdentityFeedbackAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityFeedbackAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putEmailIdentityFeedbackAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putEmailIdentityFeedbackAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEmailIdentityFeedbackAttributes");
            PutEmailIdentityFeedbackAttributesResponse putEmailIdentityFeedbackAttributesResponse = (PutEmailIdentityFeedbackAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityFeedbackAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putEmailIdentityFeedbackAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutEmailIdentityFeedbackAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putEmailIdentityFeedbackAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putEmailIdentityFeedbackAttributes$185((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutEmailIdentityMailFromAttributesResponse putEmailIdentityMailFromAttributes(PutEmailIdentityMailFromAttributesRequest putEmailIdentityMailFromAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityMailFromAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putEmailIdentityMailFromAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putEmailIdentityMailFromAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEmailIdentityMailFromAttributes");
            PutEmailIdentityMailFromAttributesResponse putEmailIdentityMailFromAttributesResponse = (PutEmailIdentityMailFromAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityMailFromAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putEmailIdentityMailFromAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutEmailIdentityMailFromAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putEmailIdentityMailFromAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putEmailIdentityMailFromAttributes$187((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutSuppressedDestinationResponse putSuppressedDestination(PutSuppressedDestinationRequest putSuppressedDestinationRequest) throws BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutSuppressedDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putSuppressedDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, putSuppressedDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutSuppressedDestination");
            PutSuppressedDestinationResponse putSuppressedDestinationResponse = (PutSuppressedDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutSuppressedDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putSuppressedDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutSuppressedDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putSuppressedDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$putSuppressedDestination$189((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendBulkEmailResponse sendBulkEmail(SendBulkEmailRequest sendBulkEmailRequest) throws TooManyRequestsException, LimitExceededException, AccountSuspendedException, SendingPausedException, MessageRejectedException, MailFromDomainNotVerifiedException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendBulkEmailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendBulkEmailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, sendBulkEmailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendBulkEmail");
            SendBulkEmailResponse sendBulkEmailResponse = (SendBulkEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendBulkEmail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)sendBulkEmailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendBulkEmailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return sendBulkEmailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$sendBulkEmail$191((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendCustomVerificationEmailResponse sendCustomVerificationEmail(SendCustomVerificationEmailRequest sendCustomVerificationEmailRequest) throws TooManyRequestsException, LimitExceededException, MessageRejectedException, SendingPausedException, MailFromDomainNotVerifiedException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendCustomVerificationEmailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendCustomVerificationEmailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, sendCustomVerificationEmailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendCustomVerificationEmail");
            SendCustomVerificationEmailResponse sendCustomVerificationEmailResponse = (SendCustomVerificationEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendCustomVerificationEmail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)sendCustomVerificationEmailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendCustomVerificationEmailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return sendCustomVerificationEmailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$sendCustomVerificationEmail$193((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendEmailResponse sendEmail(SendEmailRequest sendEmailRequest) throws TooManyRequestsException, LimitExceededException, AccountSuspendedException, SendingPausedException, MessageRejectedException, MailFromDomainNotVerifiedException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendEmailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendEmailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, sendEmailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendEmail");
            SendEmailResponse sendEmailResponse = (SendEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendEmail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)sendEmailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendEmailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return sendEmailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$sendEmail$195((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$tagResource$197((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestRenderEmailTemplateResponse testRenderEmailTemplate(TestRenderEmailTemplateRequest testRenderEmailTemplateRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestRenderEmailTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)testRenderEmailTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, testRenderEmailTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestRenderEmailTemplate");
            TestRenderEmailTemplateResponse testRenderEmailTemplateResponse = (TestRenderEmailTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestRenderEmailTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)testRenderEmailTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TestRenderEmailTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return testRenderEmailTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$testRenderEmailTemplate$199((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$untagResource$201((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConfigurationSetEventDestinationResponse updateConfigurationSetEventDestination(UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConfigurationSetEventDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateConfigurationSetEventDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, updateConfigurationSetEventDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConfigurationSetEventDestination");
            UpdateConfigurationSetEventDestinationResponse updateConfigurationSetEventDestinationResponse = (UpdateConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfigurationSetEventDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateConfigurationSetEventDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConfigurationSetEventDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateConfigurationSetEventDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$updateConfigurationSetEventDestination$203((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateContactResponse updateContact(UpdateContactRequest updateContactRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContactResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateContactRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, updateContactRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContact");
            UpdateContactResponse updateContactResponse = (UpdateContactResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContact").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateContactRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateContactRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateContactResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$updateContact$205((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateContactListResponse updateContactList(UpdateContactListRequest updateContactListRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContactListResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateContactListRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, updateContactListRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContactList");
            UpdateContactListResponse updateContactListResponse = (UpdateContactListResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContactList").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateContactListRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateContactListRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateContactListResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$updateContactList$207((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCustomVerificationEmailTemplateResponse updateCustomVerificationEmailTemplate(UpdateCustomVerificationEmailTemplateRequest updateCustomVerificationEmailTemplateRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCustomVerificationEmailTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCustomVerificationEmailTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, updateCustomVerificationEmailTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCustomVerificationEmailTemplate");
            UpdateCustomVerificationEmailTemplateResponse updateCustomVerificationEmailTemplateResponse = (UpdateCustomVerificationEmailTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCustomVerificationEmailTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateCustomVerificationEmailTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCustomVerificationEmailTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCustomVerificationEmailTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$updateCustomVerificationEmailTemplate$209((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEmailIdentityPolicyResponse updateEmailIdentityPolicy(UpdateEmailIdentityPolicyRequest updateEmailIdentityPolicyRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEmailIdentityPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateEmailIdentityPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, updateEmailIdentityPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEmailIdentityPolicy");
            UpdateEmailIdentityPolicyResponse updateEmailIdentityPolicyResponse = (UpdateEmailIdentityPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEmailIdentityPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateEmailIdentityPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEmailIdentityPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEmailIdentityPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$updateEmailIdentityPolicy$211((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEmailTemplateResponse updateEmailTemplate(UpdateEmailTemplateRequest updateEmailTemplateRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEmailTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateEmailTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, updateEmailTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEmailTemplate");
            UpdateEmailTemplateResponse updateEmailTemplateResponse = (UpdateEmailTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEmailTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateEmailTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEmailTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEmailTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$updateEmailTemplate$213((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateReputationEntityCustomerManagedStatusResponse updateReputationEntityCustomerManagedStatus(UpdateReputationEntityCustomerManagedStatusRequest updateReputationEntityCustomerManagedStatusRequest) throws TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateReputationEntityCustomerManagedStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateReputationEntityCustomerManagedStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, updateReputationEntityCustomerManagedStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateReputationEntityCustomerManagedStatus");
            UpdateReputationEntityCustomerManagedStatusResponse updateReputationEntityCustomerManagedStatusResponse = (UpdateReputationEntityCustomerManagedStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateReputationEntityCustomerManagedStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateReputationEntityCustomerManagedStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateReputationEntityCustomerManagedStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateReputationEntityCustomerManagedStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$updateReputationEntityCustomerManagedStatus$215((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateReputationEntityPolicyResponse updateReputationEntityPolicy(UpdateReputationEntityPolicyRequest updateReputationEntityPolicyRequest) throws TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateReputationEntityPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "InternalServiceErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                }
                case "MailFromDomainNotVerifiedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "SendingPausedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SendingPausedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SendingPausedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateReputationEntityPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSesV2Client.resolveMetricPublishers(clientConfiguration, updateReputationEntityPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SESv2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateReputationEntityPolicy");
            UpdateReputationEntityPolicyResponse updateReputationEntityPolicyResponse = (UpdateReputationEntityPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateReputationEntityPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateReputationEntityPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateReputationEntityPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateReputationEntityPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesV2Client.lambda$updateReputationEntityPolicy$217((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "ses";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        SesV2ServiceClientConfigurationBuilder serviceConfigBuilder = new SesV2ServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SesV2Exception::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final SesV2ServiceClientConfiguration serviceClientConfiguration() {
        return new SesV2ServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateReputationEntityPolicy$217(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateReputationEntityCustomerManagedStatus$215(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEmailTemplate$213(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEmailIdentityPolicy$211(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCustomVerificationEmailTemplate$209(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContactList$207(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContact$205(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConfigurationSetEventDestination$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$201(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$testRenderEmailTemplate$199(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$197(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendEmail$195(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendCustomVerificationEmail$193(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendBulkEmail$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putSuppressedDestination$189(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putEmailIdentityMailFromAttributes$187(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putEmailIdentityFeedbackAttributes$185(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putEmailIdentityDkimSigningAttributes$183(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putEmailIdentityDkimAttributes$181(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putEmailIdentityConfigurationSetAttributes$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putDeliverabilityDashboardOption$177(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putDedicatedIpWarmupAttributes$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putDedicatedIpPoolScalingAttributes$173(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putDedicatedIpInPool$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putConfigurationSetVdmOptions$169(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putConfigurationSetTrackingOptions$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putConfigurationSetSuppressionOptions$165(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putConfigurationSetSendingOptions$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putConfigurationSetReputationOptions$161(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putConfigurationSetDeliveryOptions$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putConfigurationSetArchivingOptions$157(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccountVdmAttributes$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccountSuppressionAttributes$153(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccountSendingAttributes$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccountDetails$149(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccountDedicatedIpWarmupAttributes$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTenants$145(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTenantResources$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$141(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSuppressedDestinations$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceTenants$137(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReputationEntities$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRecommendations$133(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMultiRegionEndpoints$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listImportJobs$129(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExportJobs$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEmailTemplates$125(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEmailIdentities$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDomainDeliverabilityCampaigns$121(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDeliverabilityTestReports$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDedicatedIpPools$117(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCustomVerificationEmailTemplates$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listContacts$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listContactLists$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConfigurationSets$109(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTenant$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSuppressedDestination$105(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReputationEntity$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMultiRegionEndpoint$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMessageInsights$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getImportJob$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getExportJob$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEmailTemplate$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEmailIdentityPolicies$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEmailIdentity$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDomainStatisticsReport$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDomainDeliverabilityCampaign$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDeliverabilityTestReport$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDeliverabilityDashboardOptions$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDedicatedIps$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDedicatedIpPool$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDedicatedIp$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCustomVerificationEmailTemplate$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContactList$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContact$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getConfigurationSetEventDestinations$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getConfigurationSet$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBlacklistReports$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccount$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTenantResourceAssociation$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTenant$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSuppressedDestination$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMultiRegionEndpoint$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEmailTemplate$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEmailIdentityPolicy$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEmailIdentity$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDedicatedIpPool$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomVerificationEmailTemplate$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteContactList$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteContact$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConfigurationSetEventDestination$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConfigurationSet$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTenantResourceAssociation$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTenant$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMultiRegionEndpoint$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createImportJob$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createExportJob$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEmailTemplate$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEmailIdentityPolicy$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEmailIdentity$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDeliverabilityTestReport$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDedicatedIpPool$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomVerificationEmailTemplate$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createContactList$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createContact$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConfigurationSetEventDestination$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConfigurationSet$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelExportJob$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetMetricData$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

