/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.ReputationEntitiesListCopier;
import software.amazon.awssdk.services.sesv2.model.ReputationEntity;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReputationEntitiesResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, ListReputationEntitiesResponse> {
    private static final SdkField<List<ReputationEntity>> REPUTATION_ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReputationEntities").getter(ListReputationEntitiesResponse.getter(ListReputationEntitiesResponse::reputationEntities)).setter(ListReputationEntitiesResponse.setter(Builder::reputationEntities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReputationEntities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReputationEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListReputationEntitiesResponse.getter(ListReputationEntitiesResponse::nextToken)).setter(ListReputationEntitiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPUTATION_ENTITIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListReputationEntitiesResponse.memberNameToFieldInitializer();
    private final List<ReputationEntity> reputationEntities;
    private final String nextToken;

    private ListReputationEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.reputationEntities = builder.reputationEntities;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasReputationEntities() {
        return this.reputationEntities != null && !(this.reputationEntities instanceof SdkAutoConstructList);
    }

    public final List<ReputationEntity> reputationEntities() {
        return this.reputationEntities;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReputationEntities() ? this.reputationEntities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReputationEntitiesResponse)) {
            return false;
        }
        ListReputationEntitiesResponse other = (ListReputationEntitiesResponse)((Object)obj);
        return this.hasReputationEntities() == other.hasReputationEntities() && Objects.equals(this.reputationEntities(), other.reputationEntities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListReputationEntitiesResponse").add("ReputationEntities", this.hasReputationEntities() ? this.reputationEntities() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReputationEntities": {
                return Optional.ofNullable(clazz.cast(this.reputationEntities()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReputationEntities", REPUTATION_ENTITIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReputationEntitiesResponse, T> g) {
        return obj -> g.apply((ListReputationEntitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private List<ReputationEntity> reputationEntities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReputationEntitiesResponse model) {
            super(model);
            this.reputationEntities(model.reputationEntities);
            this.nextToken(model.nextToken);
        }

        public final List<ReputationEntity.Builder> getReputationEntities() {
            List<ReputationEntity.Builder> result = ReputationEntitiesListCopier.copyToBuilder(this.reputationEntities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReputationEntities(Collection<ReputationEntity.BuilderImpl> reputationEntities) {
            this.reputationEntities = ReputationEntitiesListCopier.copyFromBuilder(reputationEntities);
        }

        @Override
        public final Builder reputationEntities(Collection<ReputationEntity> reputationEntities) {
            this.reputationEntities = ReputationEntitiesListCopier.copy(reputationEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reputationEntities(ReputationEntity ... reputationEntities) {
            this.reputationEntities(Arrays.asList(reputationEntities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reputationEntities(Consumer<ReputationEntity.Builder> ... reputationEntities) {
            this.reputationEntities(Stream.of(reputationEntities).map(c -> (ReputationEntity)((ReputationEntity.Builder)ReputationEntity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReputationEntitiesResponse build() {
            return new ListReputationEntitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReputationEntitiesResponse> {
        public Builder reputationEntities(Collection<ReputationEntity> var1);

        public Builder reputationEntities(ReputationEntity ... var1);

        public Builder reputationEntities(Consumer<ReputationEntity.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

