/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.services.sesv2.model.TenantInfo;
import software.amazon.awssdk.services.sesv2.model.TenantInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTenantsResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, ListTenantsResponse> {
    private static final SdkField<List<TenantInfo>> TENANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tenants").getter(ListTenantsResponse.getter(ListTenantsResponse::tenants)).setter(ListTenantsResponse.setter(Builder::tenants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TenantInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTenantsResponse.getter(ListTenantsResponse::nextToken)).setter(ListTenantsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTenantsResponse.memberNameToFieldInitializer();
    private final List<TenantInfo> tenants;
    private final String nextToken;

    private ListTenantsResponse(BuilderImpl builder) {
        super(builder);
        this.tenants = builder.tenants;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTenants() {
        return this.tenants != null && !(this.tenants instanceof SdkAutoConstructList);
    }

    public final List<TenantInfo> tenants() {
        return this.tenants;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTenants() ? this.tenants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTenantsResponse)) {
            return false;
        }
        ListTenantsResponse other = (ListTenantsResponse)((Object)obj);
        return this.hasTenants() == other.hasTenants() && Objects.equals(this.tenants(), other.tenants()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTenantsResponse").add("Tenants", this.hasTenants() ? this.tenants() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tenants": {
                return Optional.ofNullable(clazz.cast(this.tenants()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Tenants", TENANTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTenantsResponse, T> g) {
        return obj -> g.apply((ListTenantsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private List<TenantInfo> tenants = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTenantsResponse model) {
            super(model);
            this.tenants(model.tenants);
            this.nextToken(model.nextToken);
        }

        public final List<TenantInfo.Builder> getTenants() {
            List<TenantInfo.Builder> result = TenantInfoListCopier.copyToBuilder(this.tenants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTenants(Collection<TenantInfo.BuilderImpl> tenants) {
            this.tenants = TenantInfoListCopier.copyFromBuilder(tenants);
        }

        @Override
        public final Builder tenants(Collection<TenantInfo> tenants) {
            this.tenants = TenantInfoListCopier.copy(tenants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tenants(TenantInfo ... tenants) {
            this.tenants(Arrays.asList(tenants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tenants(Consumer<TenantInfo.Builder> ... tenants) {
            this.tenants(Stream.of(tenants).map(c -> (TenantInfo)((TenantInfo.Builder)TenantInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTenantsResponse build() {
            return new ListTenantsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTenantsResponse> {
        public Builder tenants(Collection<TenantInfo> var1);

        public Builder tenants(TenantInfo ... var1);

        public Builder tenants(Consumer<TenantInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

