/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceTenantMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceTenantMetadata> {
    private static final SdkField<String> TENANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantName").getter(ResourceTenantMetadata.getter(ResourceTenantMetadata::tenantName)).setter(ResourceTenantMetadata.setter(Builder::tenantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantName").build()}).build();
    private static final SdkField<String> TENANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantId").getter(ResourceTenantMetadata.getter(ResourceTenantMetadata::tenantId)).setter(ResourceTenantMetadata.setter(Builder::tenantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(ResourceTenantMetadata.getter(ResourceTenantMetadata::resourceArn)).setter(ResourceTenantMetadata.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<Instant> ASSOCIATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AssociatedTimestamp").getter(ResourceTenantMetadata.getter(ResourceTenantMetadata::associatedTimestamp)).setter(ResourceTenantMetadata.setter(Builder::associatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_NAME_FIELD, TENANT_ID_FIELD, RESOURCE_ARN_FIELD, ASSOCIATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceTenantMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tenantName;
    private final String tenantId;
    private final String resourceArn;
    private final Instant associatedTimestamp;

    private ResourceTenantMetadata(BuilderImpl builder) {
        this.tenantName = builder.tenantName;
        this.tenantId = builder.tenantId;
        this.resourceArn = builder.resourceArn;
        this.associatedTimestamp = builder.associatedTimestamp;
    }

    public final String tenantName() {
        return this.tenantName;
    }

    public final String tenantId() {
        return this.tenantId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final Instant associatedTimestamp() {
        return this.associatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTenantMetadata)) {
            return false;
        }
        ResourceTenantMetadata other = (ResourceTenantMetadata)obj;
        return Objects.equals(this.tenantName(), other.tenantName()) && Objects.equals(this.tenantId(), other.tenantId()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.associatedTimestamp(), other.associatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceTenantMetadata").add("TenantName", (Object)this.tenantName()).add("TenantId", (Object)this.tenantId()).add("ResourceArn", (Object)this.resourceArn()).add("AssociatedTimestamp", (Object)this.associatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TenantName": {
                return Optional.ofNullable(clazz.cast(this.tenantName()));
            }
            case "TenantId": {
                return Optional.ofNullable(clazz.cast(this.tenantId()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "AssociatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.associatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TenantName", TENANT_NAME_FIELD);
        map.put("TenantId", TENANT_ID_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("AssociatedTimestamp", ASSOCIATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceTenantMetadata, T> g) {
        return obj -> g.apply((ResourceTenantMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tenantName;
        private String tenantId;
        private String resourceArn;
        private Instant associatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceTenantMetadata model) {
            this.tenantName(model.tenantName);
            this.tenantId(model.tenantId);
            this.resourceArn(model.resourceArn);
            this.associatedTimestamp(model.associatedTimestamp);
        }

        public final String getTenantName() {
            return this.tenantName;
        }

        public final void setTenantName(String tenantName) {
            this.tenantName = tenantName;
        }

        @Override
        public final Builder tenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        public final String getTenantId() {
            return this.tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Instant getAssociatedTimestamp() {
            return this.associatedTimestamp;
        }

        public final void setAssociatedTimestamp(Instant associatedTimestamp) {
            this.associatedTimestamp = associatedTimestamp;
        }

        @Override
        public final Builder associatedTimestamp(Instant associatedTimestamp) {
            this.associatedTimestamp = associatedTimestamp;
            return this;
        }

        public ResourceTenantMetadata build() {
            return new ResourceTenantMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceTenantMetadata> {
        public Builder tenantName(String var1);

        public Builder tenantId(String var1);

        public Builder resourceArn(String var1);

        public Builder associatedTimestamp(Instant var1);
    }
}

