/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of reputation entities in your account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReputationEntitiesResponse extends SesV2Response implements
        ToCopyableBuilder<ListReputationEntitiesResponse.Builder, ListReputationEntitiesResponse> {
    private static final SdkField<List<ReputationEntity>> REPUTATION_ENTITIES_FIELD = SdkField
            .<List<ReputationEntity>> builder(MarshallingType.LIST)
            .memberName("ReputationEntities")
            .getter(getter(ListReputationEntitiesResponse::reputationEntities))
            .setter(setter(Builder::reputationEntities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReputationEntities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReputationEntity> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReputationEntity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListReputationEntitiesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPUTATION_ENTITIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ReputationEntity> reputationEntities;

    private final String nextToken;

    private ListReputationEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.reputationEntities = builder.reputationEntities;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReputationEntities property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReputationEntities() {
        return reputationEntities != null && !(reputationEntities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains information about the reputation entities in your account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReputationEntities} method.
     * </p>
     * 
     * @return An array that contains information about the reputation entities in your account.
     */
    public final List<ReputationEntity> reputationEntities() {
        return reputationEntities;
    }

    /**
     * <p>
     * A token that indicates that there are additional reputation entities to list. To view additional reputation
     * entities, issue another request to <code>ListReputationEntities</code>, and pass this token in the
     * <code>NextToken</code> parameter.
     * </p>
     * 
     * @return A token that indicates that there are additional reputation entities to list. To view additional
     *         reputation entities, issue another request to <code>ListReputationEntities</code>, and pass this token in
     *         the <code>NextToken</code> parameter.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReputationEntities() ? reputationEntities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReputationEntitiesResponse)) {
            return false;
        }
        ListReputationEntitiesResponse other = (ListReputationEntitiesResponse) obj;
        return hasReputationEntities() == other.hasReputationEntities()
                && Objects.equals(reputationEntities(), other.reputationEntities())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReputationEntitiesResponse")
                .add("ReputationEntities", hasReputationEntities() ? reputationEntities() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReputationEntities":
            return Optional.ofNullable(clazz.cast(reputationEntities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReputationEntities", REPUTATION_ENTITIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReputationEntitiesResponse, T> g) {
        return obj -> g.apply((ListReputationEntitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListReputationEntitiesResponse> {
        /**
         * <p>
         * An array that contains information about the reputation entities in your account.
         * </p>
         * 
         * @param reputationEntities
         *        An array that contains information about the reputation entities in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reputationEntities(Collection<ReputationEntity> reputationEntities);

        /**
         * <p>
         * An array that contains information about the reputation entities in your account.
         * </p>
         * 
         * @param reputationEntities
         *        An array that contains information about the reputation entities in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reputationEntities(ReputationEntity... reputationEntities);

        /**
         * <p>
         * An array that contains information about the reputation entities in your account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.ReputationEntity.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.ReputationEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.ReputationEntity.Builder#build()} is called immediately
         * and its result is passed to {@link #reputationEntities(List<ReputationEntity>)}.
         * 
         * @param reputationEntities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.ReputationEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reputationEntities(java.util.Collection<ReputationEntity>)
         */
        Builder reputationEntities(Consumer<ReputationEntity.Builder>... reputationEntities);

        /**
         * <p>
         * A token that indicates that there are additional reputation entities to list. To view additional reputation
         * entities, issue another request to <code>ListReputationEntities</code>, and pass this token in the
         * <code>NextToken</code> parameter.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates that there are additional reputation entities to list. To view additional
         *        reputation entities, issue another request to <code>ListReputationEntities</code>, and pass this token
         *        in the <code>NextToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private List<ReputationEntity> reputationEntities = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReputationEntitiesResponse model) {
            super(model);
            reputationEntities(model.reputationEntities);
            nextToken(model.nextToken);
        }

        public final List<ReputationEntity.Builder> getReputationEntities() {
            List<ReputationEntity.Builder> result = ReputationEntitiesListCopier.copyToBuilder(this.reputationEntities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReputationEntities(Collection<ReputationEntity.BuilderImpl> reputationEntities) {
            this.reputationEntities = ReputationEntitiesListCopier.copyFromBuilder(reputationEntities);
        }

        @Override
        public final Builder reputationEntities(Collection<ReputationEntity> reputationEntities) {
            this.reputationEntities = ReputationEntitiesListCopier.copy(reputationEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reputationEntities(ReputationEntity... reputationEntities) {
            reputationEntities(Arrays.asList(reputationEntities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reputationEntities(Consumer<ReputationEntity.Builder>... reputationEntities) {
            reputationEntities(Stream.of(reputationEntities).map(c -> ReputationEntity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReputationEntitiesResponse build() {
            return new ListReputationEntitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
