/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to submit new account details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAccountDetailsRequest extends SesV2Request implements
        ToCopyableBuilder<PutAccountDetailsRequest.Builder, PutAccountDetailsRequest> {
    private static final SdkField<String> MAIL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MailType").getter(getter(PutAccountDetailsRequest::mailTypeAsString)).setter(setter(Builder::mailType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailType").build()).build();

    private static final SdkField<String> WEBSITE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebsiteURL").getter(getter(PutAccountDetailsRequest::websiteURL)).setter(setter(Builder::websiteURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteURL").build()).build();

    private static final SdkField<String> CONTACT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactLanguage").getter(getter(PutAccountDetailsRequest::contactLanguageAsString))
            .setter(setter(Builder::contactLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactLanguage").build()).build();

    private static final SdkField<String> USE_CASE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UseCaseDescription").getter(getter(PutAccountDetailsRequest::useCaseDescription))
            .setter(setter(Builder::useCaseDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCaseDescription").build())
            .build();

    private static final SdkField<List<String>> ADDITIONAL_CONTACT_EMAIL_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalContactEmailAddresses")
            .getter(getter(PutAccountDetailsRequest::additionalContactEmailAddresses))
            .setter(setter(Builder::additionalContactEmailAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalContactEmailAddresses")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> PRODUCTION_ACCESS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ProductionAccessEnabled").getter(getter(PutAccountDetailsRequest::productionAccessEnabled))
            .setter(setter(Builder::productionAccessEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductionAccessEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAIL_TYPE_FIELD,
            WEBSITE_URL_FIELD, CONTACT_LANGUAGE_FIELD, USE_CASE_DESCRIPTION_FIELD, ADDITIONAL_CONTACT_EMAIL_ADDRESSES_FIELD,
            PRODUCTION_ACCESS_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String mailType;

    private final String websiteURL;

    private final String contactLanguage;

    private final String useCaseDescription;

    private final List<String> additionalContactEmailAddresses;

    private final Boolean productionAccessEnabled;

    private PutAccountDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.mailType = builder.mailType;
        this.websiteURL = builder.websiteURL;
        this.contactLanguage = builder.contactLanguage;
        this.useCaseDescription = builder.useCaseDescription;
        this.additionalContactEmailAddresses = builder.additionalContactEmailAddresses;
        this.productionAccessEnabled = builder.productionAccessEnabled;
    }

    /**
     * <p>
     * The type of email your account will send.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mailType} will
     * return {@link MailType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mailTypeAsString}.
     * </p>
     * 
     * @return The type of email your account will send.
     * @see MailType
     */
    public final MailType mailType() {
        return MailType.fromValue(mailType);
    }

    /**
     * <p>
     * The type of email your account will send.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mailType} will
     * return {@link MailType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mailTypeAsString}.
     * </p>
     * 
     * @return The type of email your account will send.
     * @see MailType
     */
    public final String mailTypeAsString() {
        return mailType;
    }

    /**
     * <p>
     * The URL of your website. This information helps us better understand the type of content that you plan to send.
     * </p>
     * 
     * @return The URL of your website. This information helps us better understand the type of content that you plan to
     *         send.
     */
    public final String websiteURL() {
        return websiteURL;
    }

    /**
     * <p>
     * The language you would prefer to be contacted with.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactLanguage}
     * will return {@link ContactLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contactLanguageAsString}.
     * </p>
     * 
     * @return The language you would prefer to be contacted with.
     * @see ContactLanguage
     */
    public final ContactLanguage contactLanguage() {
        return ContactLanguage.fromValue(contactLanguage);
    }

    /**
     * <p>
     * The language you would prefer to be contacted with.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactLanguage}
     * will return {@link ContactLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contactLanguageAsString}.
     * </p>
     * 
     * @return The language you would prefer to be contacted with.
     * @see ContactLanguage
     */
    public final String contactLanguageAsString() {
        return contactLanguage;
    }

    /**
     * <p>
     * A description of the types of email that you plan to send.
     * </p>
     * 
     * @return A description of the types of email that you plan to send.
     */
    public final String useCaseDescription() {
        return useCaseDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalContactEmailAddresses
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAdditionalContactEmailAddresses() {
        return additionalContactEmailAddresses != null && !(additionalContactEmailAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional email addresses that you would like to be notified regarding Amazon SES matters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalContactEmailAddresses}
     * method.
     * </p>
     * 
     * @return Additional email addresses that you would like to be notified regarding Amazon SES matters.
     */
    public final List<String> additionalContactEmailAddresses() {
        return additionalContactEmailAddresses;
    }

    /**
     * <p>
     * Indicates whether or not your account should have production access in the current Amazon Web Services Region.
     * </p>
     * <p>
     * If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is in the
     * sandbox, you can only send email to verified identities.
     * </p>
     * <p>
     * If the value is <code>true</code>, then your account has production access. When your account has production
     * access, you can send email to any address. The sending quota and maximum sending rate for your account vary based
     * on your specific use case.
     * </p>
     * 
     * @return Indicates whether or not your account should have production access in the current Amazon Web Services
     *         Region.</p>
     *         <p>
     *         If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is in
     *         the sandbox, you can only send email to verified identities.
     *         </p>
     *         <p>
     *         If the value is <code>true</code>, then your account has production access. When your account has
     *         production access, you can send email to any address. The sending quota and maximum sending rate for your
     *         account vary based on your specific use case.
     */
    public final Boolean productionAccessEnabled() {
        return productionAccessEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mailTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(websiteURL());
        hashCode = 31 * hashCode + Objects.hashCode(contactLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(useCaseDescription());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAdditionalContactEmailAddresses() ? additionalContactEmailAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(productionAccessEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccountDetailsRequest)) {
            return false;
        }
        PutAccountDetailsRequest other = (PutAccountDetailsRequest) obj;
        return Objects.equals(mailTypeAsString(), other.mailTypeAsString()) && Objects.equals(websiteURL(), other.websiteURL())
                && Objects.equals(contactLanguageAsString(), other.contactLanguageAsString())
                && Objects.equals(useCaseDescription(), other.useCaseDescription())
                && hasAdditionalContactEmailAddresses() == other.hasAdditionalContactEmailAddresses()
                && Objects.equals(additionalContactEmailAddresses(), other.additionalContactEmailAddresses())
                && Objects.equals(productionAccessEnabled(), other.productionAccessEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("PutAccountDetailsRequest")
                .add("MailType", mailTypeAsString())
                .add("WebsiteURL", websiteURL() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ContactLanguage", contactLanguageAsString())
                .add("UseCaseDescription", useCaseDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AdditionalContactEmailAddresses",
                        additionalContactEmailAddresses() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProductionAccessEnabled", productionAccessEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MailType":
            return Optional.ofNullable(clazz.cast(mailTypeAsString()));
        case "WebsiteURL":
            return Optional.ofNullable(clazz.cast(websiteURL()));
        case "ContactLanguage":
            return Optional.ofNullable(clazz.cast(contactLanguageAsString()));
        case "UseCaseDescription":
            return Optional.ofNullable(clazz.cast(useCaseDescription()));
        case "AdditionalContactEmailAddresses":
            return Optional.ofNullable(clazz.cast(additionalContactEmailAddresses()));
        case "ProductionAccessEnabled":
            return Optional.ofNullable(clazz.cast(productionAccessEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MailType", MAIL_TYPE_FIELD);
        map.put("WebsiteURL", WEBSITE_URL_FIELD);
        map.put("ContactLanguage", CONTACT_LANGUAGE_FIELD);
        map.put("UseCaseDescription", USE_CASE_DESCRIPTION_FIELD);
        map.put("AdditionalContactEmailAddresses", ADDITIONAL_CONTACT_EMAIL_ADDRESSES_FIELD);
        map.put("ProductionAccessEnabled", PRODUCTION_ACCESS_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAccountDetailsRequest, T> g) {
        return obj -> g.apply((PutAccountDetailsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, PutAccountDetailsRequest> {
        /**
         * <p>
         * The type of email your account will send.
         * </p>
         * 
         * @param mailType
         *        The type of email your account will send.
         * @see MailType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MailType
         */
        Builder mailType(String mailType);

        /**
         * <p>
         * The type of email your account will send.
         * </p>
         * 
         * @param mailType
         *        The type of email your account will send.
         * @see MailType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MailType
         */
        Builder mailType(MailType mailType);

        /**
         * <p>
         * The URL of your website. This information helps us better understand the type of content that you plan to
         * send.
         * </p>
         * 
         * @param websiteURL
         *        The URL of your website. This information helps us better understand the type of content that you plan
         *        to send.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websiteURL(String websiteURL);

        /**
         * <p>
         * The language you would prefer to be contacted with.
         * </p>
         * 
         * @param contactLanguage
         *        The language you would prefer to be contacted with.
         * @see ContactLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactLanguage
         */
        Builder contactLanguage(String contactLanguage);

        /**
         * <p>
         * The language you would prefer to be contacted with.
         * </p>
         * 
         * @param contactLanguage
         *        The language you would prefer to be contacted with.
         * @see ContactLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactLanguage
         */
        Builder contactLanguage(ContactLanguage contactLanguage);

        /**
         * <p>
         * A description of the types of email that you plan to send.
         * </p>
         * 
         * @param useCaseDescription
         *        A description of the types of email that you plan to send.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useCaseDescription(String useCaseDescription);

        /**
         * <p>
         * Additional email addresses that you would like to be notified regarding Amazon SES matters.
         * </p>
         * 
         * @param additionalContactEmailAddresses
         *        Additional email addresses that you would like to be notified regarding Amazon SES matters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalContactEmailAddresses(Collection<String> additionalContactEmailAddresses);

        /**
         * <p>
         * Additional email addresses that you would like to be notified regarding Amazon SES matters.
         * </p>
         * 
         * @param additionalContactEmailAddresses
         *        Additional email addresses that you would like to be notified regarding Amazon SES matters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalContactEmailAddresses(String... additionalContactEmailAddresses);

        /**
         * <p>
         * Indicates whether or not your account should have production access in the current Amazon Web Services
         * Region.
         * </p>
         * <p>
         * If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is in the
         * sandbox, you can only send email to verified identities.
         * </p>
         * <p>
         * If the value is <code>true</code>, then your account has production access. When your account has production
         * access, you can send email to any address. The sending quota and maximum sending rate for your account vary
         * based on your specific use case.
         * </p>
         * 
         * @param productionAccessEnabled
         *        Indicates whether or not your account should have production access in the current Amazon Web Services
         *        Region.</p>
         *        <p>
         *        If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is
         *        in the sandbox, you can only send email to verified identities.
         *        </p>
         *        <p>
         *        If the value is <code>true</code>, then your account has production access. When your account has
         *        production access, you can send email to any address. The sending quota and maximum sending rate for
         *        your account vary based on your specific use case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionAccessEnabled(Boolean productionAccessEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String mailType;

        private String websiteURL;

        private String contactLanguage;

        private String useCaseDescription;

        private List<String> additionalContactEmailAddresses = DefaultSdkAutoConstructList.getInstance();

        private Boolean productionAccessEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccountDetailsRequest model) {
            super(model);
            mailType(model.mailType);
            websiteURL(model.websiteURL);
            contactLanguage(model.contactLanguage);
            useCaseDescription(model.useCaseDescription);
            additionalContactEmailAddresses(model.additionalContactEmailAddresses);
            productionAccessEnabled(model.productionAccessEnabled);
        }

        public final String getMailType() {
            return mailType;
        }

        public final void setMailType(String mailType) {
            this.mailType = mailType;
        }

        @Override
        public final Builder mailType(String mailType) {
            this.mailType = mailType;
            return this;
        }

        @Override
        public final Builder mailType(MailType mailType) {
            this.mailType(mailType == null ? null : mailType.toString());
            return this;
        }

        public final String getWebsiteURL() {
            return websiteURL;
        }

        public final void setWebsiteURL(String websiteURL) {
            this.websiteURL = websiteURL;
        }

        @Override
        public final Builder websiteURL(String websiteURL) {
            this.websiteURL = websiteURL;
            return this;
        }

        public final String getContactLanguage() {
            return contactLanguage;
        }

        public final void setContactLanguage(String contactLanguage) {
            this.contactLanguage = contactLanguage;
        }

        @Override
        public final Builder contactLanguage(String contactLanguage) {
            this.contactLanguage = contactLanguage;
            return this;
        }

        @Override
        public final Builder contactLanguage(ContactLanguage contactLanguage) {
            this.contactLanguage(contactLanguage == null ? null : contactLanguage.toString());
            return this;
        }

        public final String getUseCaseDescription() {
            return useCaseDescription;
        }

        public final void setUseCaseDescription(String useCaseDescription) {
            this.useCaseDescription = useCaseDescription;
        }

        @Override
        public final Builder useCaseDescription(String useCaseDescription) {
            this.useCaseDescription = useCaseDescription;
            return this;
        }

        public final Collection<String> getAdditionalContactEmailAddresses() {
            if (additionalContactEmailAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalContactEmailAddresses;
        }

        public final void setAdditionalContactEmailAddresses(Collection<String> additionalContactEmailAddresses) {
            this.additionalContactEmailAddresses = AdditionalContactEmailAddressesCopier.copy(additionalContactEmailAddresses);
        }

        @Override
        public final Builder additionalContactEmailAddresses(Collection<String> additionalContactEmailAddresses) {
            this.additionalContactEmailAddresses = AdditionalContactEmailAddressesCopier.copy(additionalContactEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalContactEmailAddresses(String... additionalContactEmailAddresses) {
            additionalContactEmailAddresses(Arrays.asList(additionalContactEmailAddresses));
            return this;
        }

        public final Boolean getProductionAccessEnabled() {
            return productionAccessEnabled;
        }

        public final void setProductionAccessEnabled(Boolean productionAccessEnabled) {
            this.productionAccessEnabled = productionAccessEnabled;
        }

        @Override
        public final Builder productionAccessEnabled(Boolean productionAccessEnabled) {
            this.productionAccessEnabled = productionAccessEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAccountDetailsRequest build() {
            return new PutAccountDetailsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
