/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains status information for a reputation entity, including the current status, cause description,
 * and timestamp.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatusRecord implements SdkPojo, Serializable, ToCopyableBuilder<StatusRecord.Builder, StatusRecord> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(StatusRecord::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Cause")
            .getter(getter(StatusRecord::cause)).setter(setter(Builder::cause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cause").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(StatusRecord::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CAUSE_FIELD,
            LAST_UPDATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String cause;

    private final Instant lastUpdatedTimestamp;

    private StatusRecord(BuilderImpl builder) {
        this.status = builder.status;
        this.cause = builder.cause;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The current sending status. This can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – Sending is allowed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – Sending is prevented.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REINSTATED</code> – Sending is allowed even with active reputation findings.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SendingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current sending status. This can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – Sending is allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – Sending is prevented.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REINSTATED</code> – Sending is allowed even with active reputation findings.
     *         </p>
     *         </li>
     * @see SendingStatus
     */
    public final SendingStatus status() {
        return SendingStatus.fromValue(status);
    }

    /**
     * <p>
     * The current sending status. This can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – Sending is allowed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – Sending is prevented.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REINSTATED</code> – Sending is allowed even with active reputation findings.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SendingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current sending status. This can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – Sending is allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – Sending is prevented.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REINSTATED</code> – Sending is allowed even with active reputation findings.
     *         </p>
     *         </li>
     * @see SendingStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A description of the reason for the current status, or null if no specific cause is available.
     * </p>
     * 
     * @return A description of the reason for the current status, or null if no specific cause is available.
     */
    public final String cause() {
        return cause;
    }

    /**
     * <p>
     * The timestamp when this status was last updated.
     * </p>
     * 
     * @return The timestamp when this status was last updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cause());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusRecord)) {
            return false;
        }
        StatusRecord other = (StatusRecord) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(cause(), other.cause())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatusRecord").add("Status", statusAsString()).add("Cause", cause())
                .add("LastUpdatedTimestamp", lastUpdatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Cause":
            return Optional.ofNullable(clazz.cast(cause()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("Cause", CAUSE_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StatusRecord, T> g) {
        return obj -> g.apply((StatusRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatusRecord> {
        /**
         * <p>
         * The current sending status. This can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – Sending is allowed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – Sending is prevented.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REINSTATED</code> – Sending is allowed even with active reputation findings.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current sending status. This can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – Sending is allowed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – Sending is prevented.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REINSTATED</code> – Sending is allowed even with active reputation findings.
         *        </p>
         *        </li>
         * @see SendingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SendingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current sending status. This can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – Sending is allowed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – Sending is prevented.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REINSTATED</code> – Sending is allowed even with active reputation findings.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current sending status. This can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – Sending is allowed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – Sending is prevented.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REINSTATED</code> – Sending is allowed even with active reputation findings.
         *        </p>
         *        </li>
         * @see SendingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SendingStatus
         */
        Builder status(SendingStatus status);

        /**
         * <p>
         * A description of the reason for the current status, or null if no specific cause is available.
         * </p>
         * 
         * @param cause
         *        A description of the reason for the current status, or null if no specific cause is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cause(String cause);

        /**
         * <p>
         * The timestamp when this status was last updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The timestamp when this status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String cause;

        private Instant lastUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StatusRecord model) {
            status(model.status);
            cause(model.cause);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SendingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCause() {
            return cause;
        }

        public final void setCause(String cause) {
            this.cause = cause;
        }

        @Override
        public final Builder cause(String cause) {
            this.cause = cause;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        @Override
        public StatusRecord build() {
            return new StatusRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
