/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.ReputationEntityType;
import software.amazon.awssdk.services.sesv2.model.SendingStatus;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateReputationEntityCustomerManagedStatusRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, UpdateReputationEntityCustomerManagedStatusRequest> {
    private static final SdkField<String> REPUTATION_ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReputationEntityType").getter(UpdateReputationEntityCustomerManagedStatusRequest.getter(UpdateReputationEntityCustomerManagedStatusRequest::reputationEntityTypeAsString)).setter(UpdateReputationEntityCustomerManagedStatusRequest.setter(Builder::reputationEntityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ReputationEntityType").build()}).build();
    private static final SdkField<String> REPUTATION_ENTITY_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReputationEntityReference").getter(UpdateReputationEntityCustomerManagedStatusRequest.getter(UpdateReputationEntityCustomerManagedStatusRequest::reputationEntityReference)).setter(UpdateReputationEntityCustomerManagedStatusRequest.setter(Builder::reputationEntityReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ReputationEntityReference").build()}).build();
    private static final SdkField<String> SENDING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SendingStatus").getter(UpdateReputationEntityCustomerManagedStatusRequest.getter(UpdateReputationEntityCustomerManagedStatusRequest::sendingStatusAsString)).setter(UpdateReputationEntityCustomerManagedStatusRequest.setter(Builder::sendingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPUTATION_ENTITY_TYPE_FIELD, REPUTATION_ENTITY_REFERENCE_FIELD, SENDING_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateReputationEntityCustomerManagedStatusRequest.memberNameToFieldInitializer();
    private final String reputationEntityType;
    private final String reputationEntityReference;
    private final String sendingStatus;

    private UpdateReputationEntityCustomerManagedStatusRequest(BuilderImpl builder) {
        super(builder);
        this.reputationEntityType = builder.reputationEntityType;
        this.reputationEntityReference = builder.reputationEntityReference;
        this.sendingStatus = builder.sendingStatus;
    }

    public final ReputationEntityType reputationEntityType() {
        return ReputationEntityType.fromValue(this.reputationEntityType);
    }

    public final String reputationEntityTypeAsString() {
        return this.reputationEntityType;
    }

    public final String reputationEntityReference() {
        return this.reputationEntityReference;
    }

    public final SendingStatus sendingStatus() {
        return SendingStatus.fromValue(this.sendingStatus);
    }

    public final String sendingStatusAsString() {
        return this.sendingStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reputationEntityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reputationEntityReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.sendingStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReputationEntityCustomerManagedStatusRequest)) {
            return false;
        }
        UpdateReputationEntityCustomerManagedStatusRequest other = (UpdateReputationEntityCustomerManagedStatusRequest)((Object)obj);
        return Objects.equals(this.reputationEntityTypeAsString(), other.reputationEntityTypeAsString()) && Objects.equals(this.reputationEntityReference(), other.reputationEntityReference()) && Objects.equals(this.sendingStatusAsString(), other.sendingStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateReputationEntityCustomerManagedStatusRequest").add("ReputationEntityType", (Object)this.reputationEntityTypeAsString()).add("ReputationEntityReference", (Object)this.reputationEntityReference()).add("SendingStatus", (Object)this.sendingStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReputationEntityType": {
                return Optional.ofNullable(clazz.cast(this.reputationEntityTypeAsString()));
            }
            case "ReputationEntityReference": {
                return Optional.ofNullable(clazz.cast(this.reputationEntityReference()));
            }
            case "SendingStatus": {
                return Optional.ofNullable(clazz.cast(this.sendingStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ReputationEntityType", REPUTATION_ENTITY_TYPE_FIELD);
        map.put("ReputationEntityReference", REPUTATION_ENTITY_REFERENCE_FIELD);
        map.put("SendingStatus", SENDING_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateReputationEntityCustomerManagedStatusRequest, T> g) {
        return obj -> g.apply((UpdateReputationEntityCustomerManagedStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String reputationEntityType;
        private String reputationEntityReference;
        private String sendingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReputationEntityCustomerManagedStatusRequest model) {
            super(model);
            this.reputationEntityType(model.reputationEntityType);
            this.reputationEntityReference(model.reputationEntityReference);
            this.sendingStatus(model.sendingStatus);
        }

        public final String getReputationEntityType() {
            return this.reputationEntityType;
        }

        public final void setReputationEntityType(String reputationEntityType) {
            this.reputationEntityType = reputationEntityType;
        }

        @Override
        public final Builder reputationEntityType(String reputationEntityType) {
            this.reputationEntityType = reputationEntityType;
            return this;
        }

        @Override
        public final Builder reputationEntityType(ReputationEntityType reputationEntityType) {
            this.reputationEntityType(reputationEntityType == null ? null : reputationEntityType.toString());
            return this;
        }

        public final String getReputationEntityReference() {
            return this.reputationEntityReference;
        }

        public final void setReputationEntityReference(String reputationEntityReference) {
            this.reputationEntityReference = reputationEntityReference;
        }

        @Override
        public final Builder reputationEntityReference(String reputationEntityReference) {
            this.reputationEntityReference = reputationEntityReference;
            return this;
        }

        public final String getSendingStatus() {
            return this.sendingStatus;
        }

        public final void setSendingStatus(String sendingStatus) {
            this.sendingStatus = sendingStatus;
        }

        @Override
        public final Builder sendingStatus(String sendingStatus) {
            this.sendingStatus = sendingStatus;
            return this;
        }

        @Override
        public final Builder sendingStatus(SendingStatus sendingStatus) {
            this.sendingStatus(sendingStatus == null ? null : sendingStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateReputationEntityCustomerManagedStatusRequest build() {
            return new UpdateReputationEntityCustomerManagedStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateReputationEntityCustomerManagedStatusRequest> {
        public Builder reputationEntityType(String var1);

        public Builder reputationEntityType(ReputationEntityType var1);

        public Builder reputationEntityReference(String var1);

        public Builder sendingStatus(String var1);

        public Builder sendingStatus(SendingStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

