/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that defines the VDM settings that apply to emails that you send using the configuration set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VdmOptions implements SdkPojo, Serializable, ToCopyableBuilder<VdmOptions.Builder, VdmOptions> {
    private static final SdkField<DashboardOptions> DASHBOARD_OPTIONS_FIELD = SdkField
            .<DashboardOptions> builder(MarshallingType.SDK_POJO).memberName("DashboardOptions")
            .getter(getter(VdmOptions::dashboardOptions)).setter(setter(Builder::dashboardOptions))
            .constructor(DashboardOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardOptions").build()).build();

    private static final SdkField<GuardianOptions> GUARDIAN_OPTIONS_FIELD = SdkField
            .<GuardianOptions> builder(MarshallingType.SDK_POJO).memberName("GuardianOptions")
            .getter(getter(VdmOptions::guardianOptions)).setter(setter(Builder::guardianOptions))
            .constructor(GuardianOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuardianOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_OPTIONS_FIELD,
            GUARDIAN_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DashboardOptions dashboardOptions;

    private final GuardianOptions guardianOptions;

    private VdmOptions(BuilderImpl builder) {
        this.dashboardOptions = builder.dashboardOptions;
        this.guardianOptions = builder.guardianOptions;
    }

    /**
     * <p>
     * Specifies additional settings for your VDM configuration as applicable to the Dashboard.
     * </p>
     * 
     * @return Specifies additional settings for your VDM configuration as applicable to the Dashboard.
     */
    public final DashboardOptions dashboardOptions() {
        return dashboardOptions;
    }

    /**
     * <p>
     * Specifies additional settings for your VDM configuration as applicable to the Guardian.
     * </p>
     * 
     * @return Specifies additional settings for your VDM configuration as applicable to the Guardian.
     */
    public final GuardianOptions guardianOptions() {
        return guardianOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dashboardOptions());
        hashCode = 31 * hashCode + Objects.hashCode(guardianOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VdmOptions)) {
            return false;
        }
        VdmOptions other = (VdmOptions) obj;
        return Objects.equals(dashboardOptions(), other.dashboardOptions())
                && Objects.equals(guardianOptions(), other.guardianOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VdmOptions").add("DashboardOptions", dashboardOptions())
                .add("GuardianOptions", guardianOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardOptions":
            return Optional.ofNullable(clazz.cast(dashboardOptions()));
        case "GuardianOptions":
            return Optional.ofNullable(clazz.cast(guardianOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DashboardOptions", DASHBOARD_OPTIONS_FIELD);
        map.put("GuardianOptions", GUARDIAN_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VdmOptions, T> g) {
        return obj -> g.apply((VdmOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VdmOptions> {
        /**
         * <p>
         * Specifies additional settings for your VDM configuration as applicable to the Dashboard.
         * </p>
         * 
         * @param dashboardOptions
         *        Specifies additional settings for your VDM configuration as applicable to the Dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardOptions(DashboardOptions dashboardOptions);

        /**
         * <p>
         * Specifies additional settings for your VDM configuration as applicable to the Dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link DashboardOptions.Builder} avoiding the
         * need to create one manually via {@link DashboardOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashboardOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #dashboardOptions(DashboardOptions)}.
         * 
         * @param dashboardOptions
         *        a consumer that will call methods on {@link DashboardOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboardOptions(DashboardOptions)
         */
        default Builder dashboardOptions(Consumer<DashboardOptions.Builder> dashboardOptions) {
            return dashboardOptions(DashboardOptions.builder().applyMutation(dashboardOptions).build());
        }

        /**
         * <p>
         * Specifies additional settings for your VDM configuration as applicable to the Guardian.
         * </p>
         * 
         * @param guardianOptions
         *        Specifies additional settings for your VDM configuration as applicable to the Guardian.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardianOptions(GuardianOptions guardianOptions);

        /**
         * <p>
         * Specifies additional settings for your VDM configuration as applicable to the Guardian.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardianOptions.Builder} avoiding the
         * need to create one manually via {@link GuardianOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardianOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #guardianOptions(GuardianOptions)}.
         * 
         * @param guardianOptions
         *        a consumer that will call methods on {@link GuardianOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardianOptions(GuardianOptions)
         */
        default Builder guardianOptions(Consumer<GuardianOptions.Builder> guardianOptions) {
            return guardianOptions(GuardianOptions.builder().applyMutation(guardianOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DashboardOptions dashboardOptions;

        private GuardianOptions guardianOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(VdmOptions model) {
            dashboardOptions(model.dashboardOptions);
            guardianOptions(model.guardianOptions);
        }

        public final DashboardOptions.Builder getDashboardOptions() {
            return dashboardOptions != null ? dashboardOptions.toBuilder() : null;
        }

        public final void setDashboardOptions(DashboardOptions.BuilderImpl dashboardOptions) {
            this.dashboardOptions = dashboardOptions != null ? dashboardOptions.build() : null;
        }

        @Override
        public final Builder dashboardOptions(DashboardOptions dashboardOptions) {
            this.dashboardOptions = dashboardOptions;
            return this;
        }

        public final GuardianOptions.Builder getGuardianOptions() {
            return guardianOptions != null ? guardianOptions.toBuilder() : null;
        }

        public final void setGuardianOptions(GuardianOptions.BuilderImpl guardianOptions) {
            this.guardianOptions = guardianOptions != null ? guardianOptions.build() : null;
        }

        @Override
        public final Builder guardianOptions(GuardianOptions guardianOptions) {
            this.guardianOptions = guardianOptions;
            return this;
        }

        @Override
        public VdmOptions build() {
            return new VdmOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
