/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.ResourceTenantMetadata;
import software.amazon.awssdk.services.sesv2.model.ResourceTenantMetadataListCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceTenantsResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, ListResourceTenantsResponse> {
    private static final SdkField<List<ResourceTenantMetadata>> RESOURCE_TENANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTenants").getter(ListResourceTenantsResponse.getter(ListResourceTenantsResponse::resourceTenants)).setter(ListResourceTenantsResponse.setter(Builder::resourceTenants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTenants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTenantMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourceTenantsResponse.getter(ListResourceTenantsResponse::nextToken)).setter(ListResourceTenantsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TENANTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListResourceTenantsResponse.memberNameToFieldInitializer();
    private final List<ResourceTenantMetadata> resourceTenants;
    private final String nextToken;

    private ListResourceTenantsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTenants = builder.resourceTenants;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResourceTenants() {
        return this.resourceTenants != null && !(this.resourceTenants instanceof SdkAutoConstructList);
    }

    public final List<ResourceTenantMetadata> resourceTenants() {
        return this.resourceTenants;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTenants() ? this.resourceTenants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceTenantsResponse)) {
            return false;
        }
        ListResourceTenantsResponse other = (ListResourceTenantsResponse)((Object)obj);
        return this.hasResourceTenants() == other.hasResourceTenants() && Objects.equals(this.resourceTenants(), other.resourceTenants()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceTenantsResponse").add("ResourceTenants", this.hasResourceTenants() ? this.resourceTenants() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceTenants": {
                return Optional.ofNullable(clazz.cast(this.resourceTenants()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceTenants", RESOURCE_TENANTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceTenantsResponse, T> g) {
        return obj -> g.apply((ListResourceTenantsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private List<ResourceTenantMetadata> resourceTenants = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceTenantsResponse model) {
            super(model);
            this.resourceTenants(model.resourceTenants);
            this.nextToken(model.nextToken);
        }

        public final List<ResourceTenantMetadata.Builder> getResourceTenants() {
            List<ResourceTenantMetadata.Builder> result = ResourceTenantMetadataListCopier.copyToBuilder(this.resourceTenants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTenants(Collection<ResourceTenantMetadata.BuilderImpl> resourceTenants) {
            this.resourceTenants = ResourceTenantMetadataListCopier.copyFromBuilder(resourceTenants);
        }

        @Override
        public final Builder resourceTenants(Collection<ResourceTenantMetadata> resourceTenants) {
            this.resourceTenants = ResourceTenantMetadataListCopier.copy(resourceTenants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTenants(ResourceTenantMetadata ... resourceTenants) {
            this.resourceTenants(Arrays.asList(resourceTenants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTenants(Consumer<ResourceTenantMetadata.Builder> ... resourceTenants) {
            this.resourceTenants(Stream.of(resourceTenants).map(c -> (ResourceTenantMetadata)((ResourceTenantMetadata.Builder)ResourceTenantMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceTenantsResponse build() {
            return new ListResourceTenantsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceTenantsResponse> {
        public Builder resourceTenants(Collection<ResourceTenantMetadata> var1);

        public Builder resourceTenants(ResourceTenantMetadata ... var1);

        public Builder resourceTenants(Consumer<ResourceTenantMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

