/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStateMachineRequest extends SfnRequest implements
        ToCopyableBuilder<CreateStateMachineRequest.Builder, CreateStateMachineRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStateMachineRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStateMachineRequest::definition)).setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStateMachineRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DEFINITION_FIELD,
            ROLE_ARN_FIELD));

    private final String name;

    private final String definition;

    private final String roleArn;

    private CreateStateMachineRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.definition = builder.definition;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name of the state machine. This name must be unique for your AWS account and region for 90 days. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions">
     * Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.
     * </p>
     * <p>
     * A name must <i>not</i> contain:
     * </p>
     * <ul>
     * <li>
     * <p>
     * whitespace
     * </p>
     * </li>
     * <li>
     * <p>
     * brackets <code>&lt; &gt; { } [ ]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * wildcard characters <code>? *</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the state machine. This name must be unique for your AWS account and region for 90 days. For
     *         more information, see <a href=
     *         "http://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions"
     *         > Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
     *         <p>
     *         A name must <i>not</i> contain:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         whitespace
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         brackets <code>&lt; &gt; { } [ ]</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         wildcard characters <code>? *</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
     *         </p>
     *         </li>
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon States Language definition of the state machine.
     * </p>
     * 
     * @return The Amazon States Language definition of the state machine.
     */
    public String definition() {
        return definition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStateMachineRequest)) {
            return false;
        }
        CreateStateMachineRequest other = (CreateStateMachineRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(definition(), other.definition())
                && Objects.equals(roleArn(), other.roleArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateStateMachineRequest").add("Name", name()).add("Definition", definition())
                .add("RoleArn", roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStateMachineRequest, T> g) {
        return obj -> g.apply((CreateStateMachineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStateMachineRequest> {
        /**
         * <p>
         * The name of the state machine. This name must be unique for your AWS account and region for 90 days. For more
         * information, see <a href=
         * "http://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions">
         * Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.
         * </p>
         * <p>
         * A name must <i>not</i> contain:
         * </p>
         * <ul>
         * <li>
         * <p>
         * whitespace
         * </p>
         * </li>
         * <li>
         * <p>
         * brackets <code>&lt; &gt; { } [ ]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * wildcard characters <code>? *</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The name of the state machine. This name must be unique for your AWS account and region for 90 days.
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions"
         *        > Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
         *        <p>
         *        A name must <i>not</i> contain:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        whitespace
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        brackets <code>&lt; &gt; { } [ ]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        wildcard characters <code>? *</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon States Language definition of the state machine.
         * </p>
         * 
         * @param definition
         *        The Amazon States Language definition of the state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SfnRequest.BuilderImpl implements Builder {
        private String name;

        private String definition;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStateMachineRequest model) {
            super(model);
            name(model.name);
            definition(model.definition);
            roleArn(model.roleArn);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDefinition() {
            return definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStateMachineRequest build() {
            return new CreateStateMachineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
