/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStateMachineResponse extends SfnResponse implements
        ToCopyableBuilder<DescribeStateMachineResponse.Builder, DescribeStateMachineResponse> {
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStateMachineResponse::stateMachineArn)).setter(setter(Builder::stateMachineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStateMachineResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStateMachineResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStateMachineResponse::definition)).setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStateMachineResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeStateMachineResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ARN_FIELD,
            NAME_FIELD, STATUS_FIELD, DEFINITION_FIELD, ROLE_ARN_FIELD, CREATION_DATE_FIELD));

    private final String stateMachineArn;

    private final String name;

    private final String status;

    private final String definition;

    private final String roleArn;

    private final Instant creationDate;

    private DescribeStateMachineResponse(BuilderImpl builder) {
        super(builder);
        this.stateMachineArn = builder.stateMachineArn;
        this.name = builder.name;
        this.status = builder.status;
        this.definition = builder.definition;
        this.roleArn = builder.roleArn;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the state machine.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the state machine.
     */
    public String stateMachineArn() {
        return stateMachineArn;
    }

    /**
     * <p>
     * The name of the state machine.
     * </p>
     * <p>
     * A name must <i>not</i> contain:
     * </p>
     * <ul>
     * <li>
     * <p>
     * whitespace
     * </p>
     * </li>
     * <li>
     * <p>
     * brackets <code>&lt; &gt; { } [ ]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * wildcard characters <code>? *</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the state machine.</p>
     *         <p>
     *         A name must <i>not</i> contain:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         whitespace
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         brackets <code>&lt; &gt; { } [ ]</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         wildcard characters <code>? *</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
     *         </p>
     *         </li>
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the state machine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StateMachineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the state machine.
     * @see StateMachineStatus
     */
    public StateMachineStatus status() {
        return StateMachineStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the state machine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StateMachineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the state machine.
     * @see StateMachineStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon States Language definition of the state machine.
     * </p>
     * 
     * @return The Amazon States Language definition of the state machine.
     */
    public String definition() {
        return definition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role maintains
     * security by granting Step Functions access to AWS resources.)
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role
     *         maintains security by granting Step Functions access to AWS resources.)
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The date the state machine is created.
     * </p>
     * 
     * @return The date the state machine is created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStateMachineResponse)) {
            return false;
        }
        DescribeStateMachineResponse other = (DescribeStateMachineResponse) obj;
        return Objects.equals(stateMachineArn(), other.stateMachineArn()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(definition(), other.definition())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(creationDate(), other.creationDate());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeStateMachineResponse").add("StateMachineArn", stateMachineArn()).add("Name", name())
                .add("Status", statusAsString()).add("Definition", definition()).add("RoleArn", roleArn())
                .add("CreationDate", creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateMachineArn":
            return Optional.ofNullable(clazz.cast(stateMachineArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStateMachineResponse, T> g) {
        return obj -> g.apply((DescribeStateMachineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStateMachineResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the state machine.
         * </p>
         * 
         * @param stateMachineArn
         *        The Amazon Resource Name (ARN) that identifies the state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineArn(String stateMachineArn);

        /**
         * <p>
         * The name of the state machine.
         * </p>
         * <p>
         * A name must <i>not</i> contain:
         * </p>
         * <ul>
         * <li>
         * <p>
         * whitespace
         * </p>
         * </li>
         * <li>
         * <p>
         * brackets <code>&lt; &gt; { } [ ]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * wildcard characters <code>? *</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The name of the state machine.</p>
         *        <p>
         *        A name must <i>not</i> contain:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        whitespace
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        brackets <code>&lt; &gt; { } [ ]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        wildcard characters <code>? *</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the state machine.
         * </p>
         * 
         * @param status
         *        The current status of the state machine.
         * @see StateMachineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateMachineStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the state machine.
         * </p>
         * 
         * @param status
         *        The current status of the state machine.
         * @see StateMachineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateMachineStatus
         */
        Builder status(StateMachineStatus status);

        /**
         * <p>
         * The Amazon States Language definition of the state machine.
         * </p>
         * 
         * @param definition
         *        The Amazon States Language definition of the state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role maintains
         * security by granting Step Functions access to AWS resources.)
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role
         *        maintains security by granting Step Functions access to AWS resources.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The date the state machine is created.
         * </p>
         * 
         * @param creationDate
         *        The date the state machine is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private String stateMachineArn;

        private String name;

        private String status;

        private String definition;

        private String roleArn;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStateMachineResponse model) {
            super(model);
            stateMachineArn(model.stateMachineArn);
            name(model.name);
            status(model.status);
            definition(model.definition);
            roleArn(model.roleArn);
            creationDate(model.creationDate);
        }

        public final String getStateMachineArn() {
            return stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StateMachineStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDefinition() {
            return definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public DescribeStateMachineResponse build() {
            return new DescribeStateMachineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
