/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListExecutionsResponse extends SfnResponse implements
        ToCopyableBuilder<ListExecutionsResponse.Builder, ListExecutionsResponse> {
    private static final SdkField<List<ExecutionListItem>> EXECUTIONS_FIELD = SdkField
            .<List<ExecutionListItem>> builder(MarshallingType.LIST)
            .getter(getter(ListExecutionsResponse::executions))
            .setter(setter(Builder::executions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExecutionListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExecutionListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListExecutionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ExecutionListItem> executions;

    private final String nextToken;

    private ListExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.executions = builder.executions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of matching executions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of matching executions.
     */
    public List<ExecutionListItem> executions() {
        return executions;
    }

    /**
     * <p>
     * If a <code>nextToken</code> is returned by a previous call, there are more results available. To retrieve the
     * next page of results, make the call again using the returned token in <code>nextToken</code>. Keep all other
     * arguments unchanged.
     * </p>
     * <p>
     * The configured <code>maxResults</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If a <code>nextToken</code> is returned by a previous call, there are more results available. To retrieve
     *         the next page of results, make the call again using the returned token in <code>nextToken</code>. Keep
     *         all other arguments unchanged.</p>
     *         <p>
     *         The configured <code>maxResults</code> determines how many results can be returned in a single call.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExecutionsResponse)) {
            return false;
        }
        ListExecutionsResponse other = (ListExecutionsResponse) obj;
        return Objects.equals(executions(), other.executions()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListExecutionsResponse").add("Executions", executions()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executions":
            return Optional.ofNullable(clazz.cast(executions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExecutionsResponse, T> g) {
        return obj -> g.apply((ListExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListExecutionsResponse> {
        /**
         * <p>
         * The list of matching executions.
         * </p>
         * 
         * @param executions
         *        The list of matching executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executions(Collection<ExecutionListItem> executions);

        /**
         * <p>
         * The list of matching executions.
         * </p>
         * 
         * @param executions
         *        The list of matching executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executions(ExecutionListItem... executions);

        /**
         * <p>
         * The list of matching executions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ExecutionListItem>.Builder} avoiding the
         * need to create one manually via {@link List<ExecutionListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExecutionListItem>.Builder#build()} is called immediately
         * and its result is passed to {@link #executions(List<ExecutionListItem>)}.
         * 
         * @param executions
         *        a consumer that will call methods on {@link List<ExecutionListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executions(List<ExecutionListItem>)
         */
        Builder executions(Consumer<ExecutionListItem.Builder>... executions);

        /**
         * <p>
         * If a <code>nextToken</code> is returned by a previous call, there are more results available. To retrieve the
         * next page of results, make the call again using the returned token in <code>nextToken</code>. Keep all other
         * arguments unchanged.
         * </p>
         * <p>
         * The configured <code>maxResults</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextToken
         *        If a <code>nextToken</code> is returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>nextToken</code>. Keep all other arguments unchanged.</p>
         *        <p>
         *        The configured <code>maxResults</code> determines how many results can be returned in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private List<ExecutionListItem> executions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExecutionsResponse model) {
            super(model);
            executions(model.executions);
            nextToken(model.nextToken);
        }

        public final Collection<ExecutionListItem.Builder> getExecutions() {
            return executions != null ? executions.stream().map(ExecutionListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder executions(Collection<ExecutionListItem> executions) {
            this.executions = ExecutionListCopier.copy(executions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executions(ExecutionListItem... executions) {
            executions(Arrays.asList(executions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executions(Consumer<ExecutionListItem.Builder>... executions) {
            executions(Stream.of(executions).map(c -> ExecutionListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setExecutions(Collection<ExecutionListItem.BuilderImpl> executions) {
            this.executions = ExecutionListCopier.copyFromBuilder(executions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListExecutionsResponse build() {
            return new ListExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
