/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendTaskFailureRequest extends SfnRequest implements
        ToCopyableBuilder<SendTaskFailureRequest.Builder, SendTaskFailureRequest> {
    private static final SdkField<String> TASK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SendTaskFailureRequest::taskToken)).setter(setter(Builder::taskToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskToken").build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SendTaskFailureRequest::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SendTaskFailureRequest::cause)).setter(setter(Builder::cause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_TOKEN_FIELD, ERROR_FIELD,
            CAUSE_FIELD));

    private final String taskToken;

    private final String error;

    private final String cause;

    private SendTaskFailureRequest(BuilderImpl builder) {
        super(builder);
        this.taskToken = builder.taskToken;
        this.error = builder.error;
        this.cause = builder.cause;
    }

    /**
     * <p>
     * The token that represents this task. Task tokens are generated by the service when the tasks are assigned to a
     * worker (see GetActivityTask::taskToken).
     * </p>
     * 
     * @return The token that represents this task. Task tokens are generated by the service when the tasks are assigned
     *         to a worker (see GetActivityTask::taskToken).
     */
    public String taskToken() {
        return taskToken;
    }

    /**
     * <p>
     * An arbitrary error code that identifies the cause of the failure.
     * </p>
     * 
     * @return An arbitrary error code that identifies the cause of the failure.
     */
    public String error() {
        return error;
    }

    /**
     * <p>
     * A more detailed explanation of the cause of the failure.
     * </p>
     * 
     * @return A more detailed explanation of the cause of the failure.
     */
    public String cause() {
        return cause;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskToken());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(cause());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendTaskFailureRequest)) {
            return false;
        }
        SendTaskFailureRequest other = (SendTaskFailureRequest) obj;
        return Objects.equals(taskToken(), other.taskToken()) && Objects.equals(error(), other.error())
                && Objects.equals(cause(), other.cause());
    }

    @Override
    public String toString() {
        return ToString.builder("SendTaskFailureRequest").add("TaskToken", taskToken()).add("Error", error())
                .add("Cause", cause()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskToken":
            return Optional.ofNullable(clazz.cast(taskToken()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "cause":
            return Optional.ofNullable(clazz.cast(cause()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendTaskFailureRequest, T> g) {
        return obj -> g.apply((SendTaskFailureRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendTaskFailureRequest> {
        /**
         * <p>
         * The token that represents this task. Task tokens are generated by the service when the tasks are assigned to
         * a worker (see GetActivityTask::taskToken).
         * </p>
         * 
         * @param taskToken
         *        The token that represents this task. Task tokens are generated by the service when the tasks are
         *        assigned to a worker (see GetActivityTask::taskToken).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskToken(String taskToken);

        /**
         * <p>
         * An arbitrary error code that identifies the cause of the failure.
         * </p>
         * 
         * @param error
         *        An arbitrary error code that identifies the cause of the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * A more detailed explanation of the cause of the failure.
         * </p>
         * 
         * @param cause
         *        A more detailed explanation of the cause of the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cause(String cause);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SfnRequest.BuilderImpl implements Builder {
        private String taskToken;

        private String error;

        private String cause;

        private BuilderImpl() {
        }

        private BuilderImpl(SendTaskFailureRequest model) {
            super(model);
            taskToken(model.taskToken);
            error(model.error);
            cause(model.cause);
        }

        public final String getTaskToken() {
            return taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        public final String getError() {
            return error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final void setError(String error) {
            this.error = error;
        }

        public final String getCause() {
            return cause;
        }

        @Override
        public final Builder cause(String cause) {
            this.cause = cause;
            return this;
        }

        public final void setCause(String cause) {
            this.cause = cause;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendTaskFailureRequest build() {
            return new SendTaskFailureRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
