/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the execution timeout that occurred during the execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionTimedOutEventDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionTimedOutEventDetails.Builder, ExecutionTimedOutEventDetails> {
    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExecutionTimedOutEventDetails::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExecutionTimedOutEventDetails::cause)).setter(setter(Builder::cause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD, CAUSE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String error;

    private final String cause;

    private ExecutionTimedOutEventDetails(BuilderImpl builder) {
        this.error = builder.error;
        this.cause = builder.cause;
    }

    /**
     * <p>
     * The error code of the failure.
     * </p>
     * 
     * @return The error code of the failure.
     */
    public String error() {
        return error;
    }

    /**
     * <p>
     * A more detailed explanation of the cause of the timeout.
     * </p>
     * 
     * @return A more detailed explanation of the cause of the timeout.
     */
    public String cause() {
        return cause;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(cause());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionTimedOutEventDetails)) {
            return false;
        }
        ExecutionTimedOutEventDetails other = (ExecutionTimedOutEventDetails) obj;
        return Objects.equals(error(), other.error()) && Objects.equals(cause(), other.cause());
    }

    @Override
    public String toString() {
        return ToString.builder("ExecutionTimedOutEventDetails").add("Error", error()).add("Cause", cause()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "cause":
            return Optional.ofNullable(clazz.cast(cause()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionTimedOutEventDetails, T> g) {
        return obj -> g.apply((ExecutionTimedOutEventDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionTimedOutEventDetails> {
        /**
         * <p>
         * The error code of the failure.
         * </p>
         * 
         * @param error
         *        The error code of the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * A more detailed explanation of the cause of the timeout.
         * </p>
         * 
         * @param cause
         *        A more detailed explanation of the cause of the timeout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cause(String cause);
    }

    static final class BuilderImpl implements Builder {
        private String error;

        private String cause;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionTimedOutEventDetails model) {
            error(model.error);
            cause(model.cause);
        }

        public final String getError() {
            return error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final void setError(String error) {
            this.error = error;
        }

        public final String getCause() {
            return cause;
        }

        @Override
        public final Builder cause(String cause) {
            this.cause = cause;
            return this;
        }

        public final void setCause(String cause) {
            this.cause = cause;
        }

        @Override
        public ExecutionTimedOutEventDetails build() {
            return new ExecutionTimedOutEventDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
