/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum HistoryEventType {
    ACTIVITY_FAILED("ActivityFailed"),

    ACTIVITY_SCHEDULE_FAILED("ActivityScheduleFailed"),

    ACTIVITY_SCHEDULED("ActivityScheduled"),

    ACTIVITY_STARTED("ActivityStarted"),

    ACTIVITY_SUCCEEDED("ActivitySucceeded"),

    ACTIVITY_TIMED_OUT("ActivityTimedOut"),

    CHOICE_STATE_ENTERED("ChoiceStateEntered"),

    CHOICE_STATE_EXITED("ChoiceStateExited"),

    TASK_FAILED("TaskFailed"),

    TASK_SCHEDULED("TaskScheduled"),

    TASK_START_FAILED("TaskStartFailed"),

    TASK_STARTED("TaskStarted"),

    TASK_SUBMIT_FAILED("TaskSubmitFailed"),

    TASK_SUBMITTED("TaskSubmitted"),

    TASK_SUCCEEDED("TaskSucceeded"),

    TASK_TIMED_OUT("TaskTimedOut"),

    EXECUTION_FAILED("ExecutionFailed"),

    EXECUTION_STARTED("ExecutionStarted"),

    EXECUTION_SUCCEEDED("ExecutionSucceeded"),

    EXECUTION_ABORTED("ExecutionAborted"),

    EXECUTION_TIMED_OUT("ExecutionTimedOut"),

    FAIL_STATE_ENTERED("FailStateEntered"),

    LAMBDA_FUNCTION_FAILED("LambdaFunctionFailed"),

    LAMBDA_FUNCTION_SCHEDULE_FAILED("LambdaFunctionScheduleFailed"),

    LAMBDA_FUNCTION_SCHEDULED("LambdaFunctionScheduled"),

    LAMBDA_FUNCTION_START_FAILED("LambdaFunctionStartFailed"),

    LAMBDA_FUNCTION_STARTED("LambdaFunctionStarted"),

    LAMBDA_FUNCTION_SUCCEEDED("LambdaFunctionSucceeded"),

    LAMBDA_FUNCTION_TIMED_OUT("LambdaFunctionTimedOut"),

    SUCCEED_STATE_ENTERED("SucceedStateEntered"),

    SUCCEED_STATE_EXITED("SucceedStateExited"),

    TASK_STATE_ABORTED("TaskStateAborted"),

    TASK_STATE_ENTERED("TaskStateEntered"),

    TASK_STATE_EXITED("TaskStateExited"),

    PASS_STATE_ENTERED("PassStateEntered"),

    PASS_STATE_EXITED("PassStateExited"),

    PARALLEL_STATE_ABORTED("ParallelStateAborted"),

    PARALLEL_STATE_ENTERED("ParallelStateEntered"),

    PARALLEL_STATE_EXITED("ParallelStateExited"),

    PARALLEL_STATE_FAILED("ParallelStateFailed"),

    PARALLEL_STATE_STARTED("ParallelStateStarted"),

    PARALLEL_STATE_SUCCEEDED("ParallelStateSucceeded"),

    WAIT_STATE_ABORTED("WaitStateAborted"),

    WAIT_STATE_ENTERED("WaitStateEntered"),

    WAIT_STATE_EXITED("WaitStateExited"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HistoryEventType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return HistoryEventType corresponding to the value
     */
    public static HistoryEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HistoryEventType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link HistoryEventType}s
     */
    public static Set<HistoryEventType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
