/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStateMachineResponse extends SfnResponse implements
        ToCopyableBuilder<UpdateStateMachineResponse.Builder, UpdateStateMachineResponse> {
    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(UpdateStateMachineResponse::updateDate)).setter(setter(Builder::updateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_DATE_FIELD));

    private final Instant updateDate;

    private UpdateStateMachineResponse(BuilderImpl builder) {
        super(builder);
        this.updateDate = builder.updateDate;
    }

    /**
     * <p>
     * The date and time the state machine was updated.
     * </p>
     * 
     * @return The date and time the state machine was updated.
     */
    public Instant updateDate() {
        return updateDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(updateDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStateMachineResponse)) {
            return false;
        }
        UpdateStateMachineResponse other = (UpdateStateMachineResponse) obj;
        return Objects.equals(updateDate(), other.updateDate());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateStateMachineResponse").add("UpdateDate", updateDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "updateDate":
            return Optional.ofNullable(clazz.cast(updateDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStateMachineResponse, T> g) {
        return obj -> g.apply((UpdateStateMachineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStateMachineResponse> {
        /**
         * <p>
         * The date and time the state machine was updated.
         * </p>
         * 
         * @param updateDate
         *        The date and time the state machine was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDate(Instant updateDate);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private Instant updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStateMachineResponse model) {
            super(model);
            updateDate(model.updateDate);
        }

        public final Instant getUpdateDate() {
            return updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public UpdateStateMachineResponse build() {
            return new UpdateStateMachineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
