/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStateMachinesResponse extends SfnResponse implements
        ToCopyableBuilder<ListStateMachinesResponse.Builder, ListStateMachinesResponse> {
    private static final SdkField<List<StateMachineListItem>> STATE_MACHINES_FIELD = SdkField
            .<List<StateMachineListItem>> builder(MarshallingType.LIST)
            .getter(getter(ListStateMachinesResponse::stateMachines))
            .setter(setter(Builder::stateMachines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StateMachineListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(StateMachineListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListStateMachinesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<StateMachineListItem> stateMachines;

    private final String nextToken;

    private ListStateMachinesResponse(BuilderImpl builder) {
        super(builder);
        this.stateMachines = builder.stateMachines;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the StateMachines property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStateMachines() {
        return stateMachines != null && !(stateMachines instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the StateMachines property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStateMachines()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the StateMachines property for this object.
     */
    public List<StateMachineListItem> stateMachines() {
        return stateMachines;
    }

    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * 
     * @return If <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after
     *         24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stateMachines());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStateMachinesResponse)) {
            return false;
        }
        ListStateMachinesResponse other = (ListStateMachinesResponse) obj;
        return Objects.equals(stateMachines(), other.stateMachines()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListStateMachinesResponse").add("StateMachines", stateMachines()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateMachines":
            return Optional.ofNullable(clazz.cast(stateMachines()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStateMachinesResponse, T> g) {
        return obj -> g.apply((ListStateMachinesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStateMachinesResponse> {
        /**
         * Sets the value of the StateMachines property for this object.
         *
         * @param stateMachines
         *        The new value for the StateMachines property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachines(Collection<StateMachineListItem> stateMachines);

        /**
         * Sets the value of the StateMachines property for this object.
         *
         * @param stateMachines
         *        The new value for the StateMachines property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachines(StateMachineListItem... stateMachines);

        /**
         * Sets the value of the StateMachines property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<StateMachineListItem>.Builder} avoiding the
         * need to create one manually via {@link List<StateMachineListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StateMachineListItem>.Builder#build()} is called immediately
         * and its result is passed to {@link #stateMachines(List<StateMachineListItem>)}.
         * 
         * @param stateMachines
         *        a consumer that will call methods on {@link List<StateMachineListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateMachines(List<StateMachineListItem>)
         */
        Builder stateMachines(Consumer<StateMachineListItem.Builder>... stateMachines);

        /**
         * <p>
         * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired
         * pagination token will return an <i>HTTP 400 InvalidToken</i> error.
         * </p>
         * 
         * @param nextToken
         *        If <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
         *        expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i>
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private List<StateMachineListItem> stateMachines = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStateMachinesResponse model) {
            super(model);
            stateMachines(model.stateMachines);
            nextToken(model.nextToken);
        }

        public final Collection<StateMachineListItem.Builder> getStateMachines() {
            return stateMachines != null ? stateMachines.stream().map(StateMachineListItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stateMachines(Collection<StateMachineListItem> stateMachines) {
            this.stateMachines = StateMachineListCopier.copy(stateMachines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateMachines(StateMachineListItem... stateMachines) {
            stateMachines(Arrays.asList(stateMachines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateMachines(Consumer<StateMachineListItem.Builder>... stateMachines) {
            stateMachines(Stream.of(stateMachines).map(c -> StateMachineListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStateMachines(Collection<StateMachineListItem.BuilderImpl> stateMachines) {
            this.stateMachines = StateMachineListCopier.copyFromBuilder(stateMachines);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStateMachinesResponse build() {
            return new ListStateMachinesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
