/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about an iteration of a Map state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MapIterationEventDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<MapIterationEventDetails.Builder, MapIterationEventDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MapIterationEventDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(MapIterationEventDetails::index)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INDEX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer index;

    private MapIterationEventDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.index = builder.index;
    }

    /**
     * <p>
     * The name of the iteration’s parent Map state.
     * </p>
     * 
     * @return The name of the iteration’s parent Map state.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The index of the array belonging to the Map state iteration.
     * </p>
     * 
     * @return The index of the array belonging to the Map state iteration.
     */
    public Integer index() {
        return index;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(index());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapIterationEventDetails)) {
            return false;
        }
        MapIterationEventDetails other = (MapIterationEventDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(index(), other.index());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MapIterationEventDetails").add("Name", name()).add("Index", index()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "index":
            return Optional.ofNullable(clazz.cast(index()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MapIterationEventDetails, T> g) {
        return obj -> g.apply((MapIterationEventDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MapIterationEventDetails> {
        /**
         * <p>
         * The name of the iteration’s parent Map state.
         * </p>
         * 
         * @param name
         *        The name of the iteration’s parent Map state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The index of the array belonging to the Map state iteration.
         * </p>
         * 
         * @param index
         *        The index of the array belonging to the Map state iteration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(Integer index);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer index;

        private BuilderImpl() {
        }

        private BuilderImpl(MapIterationEventDetails model) {
            name(model.name);
            index(model.index);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getIndex() {
            return index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public MapIterationEventDetails build() {
            return new MapIterationEventDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
