/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about an activity scheduled during an execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivityScheduledEventDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ActivityScheduledEventDetails.Builder, ActivityScheduledEventDetails> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivityScheduledEventDetails::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivityScheduledEventDetails::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<HistoryEventExecutionDataDetails> INPUT_DETAILS_FIELD = SdkField
            .<HistoryEventExecutionDataDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(ActivityScheduledEventDetails::inputDetails)).setter(setter(Builder::inputDetails))
            .constructor(HistoryEventExecutionDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDetails").build()).build();

    private static final SdkField<Long> TIMEOUT_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ActivityScheduledEventDetails::timeoutInSeconds)).setter(setter(Builder::timeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInSeconds").build()).build();

    private static final SdkField<Long> HEARTBEAT_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ActivityScheduledEventDetails::heartbeatInSeconds)).setter(setter(Builder::heartbeatInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heartbeatInSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD, INPUT_FIELD,
            INPUT_DETAILS_FIELD, TIMEOUT_IN_SECONDS_FIELD, HEARTBEAT_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resource;

    private final String input;

    private final HistoryEventExecutionDataDetails inputDetails;

    private final Long timeoutInSeconds;

    private final Long heartbeatInSeconds;

    private ActivityScheduledEventDetails(BuilderImpl builder) {
        this.resource = builder.resource;
        this.input = builder.input;
        this.inputDetails = builder.inputDetails;
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.heartbeatInSeconds = builder.heartbeatInSeconds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the scheduled activity.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the scheduled activity.
     */
    public String resource() {
        return resource;
    }

    /**
     * <p>
     * The JSON data input to the activity task. Length constraints apply to the payload size, and are expressed as
     * bytes in UTF-8 encoding.
     * </p>
     * 
     * @return The JSON data input to the activity task. Length constraints apply to the payload size, and are expressed
     *         as bytes in UTF-8 encoding.
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * Contains details about the input for an execution history event.
     * </p>
     * 
     * @return Contains details about the input for an execution history event.
     */
    public HistoryEventExecutionDataDetails inputDetails() {
        return inputDetails;
    }

    /**
     * <p>
     * The maximum allowed duration of the activity task.
     * </p>
     * 
     * @return The maximum allowed duration of the activity task.
     */
    public Long timeoutInSeconds() {
        return timeoutInSeconds;
    }

    /**
     * <p>
     * The maximum allowed duration between two heartbeats for the activity task.
     * </p>
     * 
     * @return The maximum allowed duration between two heartbeats for the activity task.
     */
    public Long heartbeatInSeconds() {
        return heartbeatInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(inputDetails());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(heartbeatInSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityScheduledEventDetails)) {
            return false;
        }
        ActivityScheduledEventDetails other = (ActivityScheduledEventDetails) obj;
        return Objects.equals(resource(), other.resource()) && Objects.equals(input(), other.input())
                && Objects.equals(inputDetails(), other.inputDetails())
                && Objects.equals(timeoutInSeconds(), other.timeoutInSeconds())
                && Objects.equals(heartbeatInSeconds(), other.heartbeatInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ActivityScheduledEventDetails").add("Resource", resource())
                .add("Input", input() == null ? null : "*** Sensitive Data Redacted ***").add("InputDetails", inputDetails())
                .add("TimeoutInSeconds", timeoutInSeconds()).add("HeartbeatInSeconds", heartbeatInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "inputDetails":
            return Optional.ofNullable(clazz.cast(inputDetails()));
        case "timeoutInSeconds":
            return Optional.ofNullable(clazz.cast(timeoutInSeconds()));
        case "heartbeatInSeconds":
            return Optional.ofNullable(clazz.cast(heartbeatInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivityScheduledEventDetails, T> g) {
        return obj -> g.apply((ActivityScheduledEventDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActivityScheduledEventDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the scheduled activity.
         * </p>
         * 
         * @param resource
         *        The Amazon Resource Name (ARN) of the scheduled activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * The JSON data input to the activity task. Length constraints apply to the payload size, and are expressed as
         * bytes in UTF-8 encoding.
         * </p>
         * 
         * @param input
         *        The JSON data input to the activity task. Length constraints apply to the payload size, and are
         *        expressed as bytes in UTF-8 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * Contains details about the input for an execution history event.
         * </p>
         * 
         * @param inputDetails
         *        Contains details about the input for an execution history event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDetails(HistoryEventExecutionDataDetails inputDetails);

        /**
         * <p>
         * Contains details about the input for an execution history event.
         * </p>
         * This is a convenience that creates an instance of the {@link HistoryEventExecutionDataDetails.Builder}
         * avoiding the need to create one manually via {@link HistoryEventExecutionDataDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link HistoryEventExecutionDataDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #inputDetails(HistoryEventExecutionDataDetails)}.
         * 
         * @param inputDetails
         *        a consumer that will call methods on {@link HistoryEventExecutionDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDetails(HistoryEventExecutionDataDetails)
         */
        default Builder inputDetails(Consumer<HistoryEventExecutionDataDetails.Builder> inputDetails) {
            return inputDetails(HistoryEventExecutionDataDetails.builder().applyMutation(inputDetails).build());
        }

        /**
         * <p>
         * The maximum allowed duration of the activity task.
         * </p>
         * 
         * @param timeoutInSeconds
         *        The maximum allowed duration of the activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInSeconds(Long timeoutInSeconds);

        /**
         * <p>
         * The maximum allowed duration between two heartbeats for the activity task.
         * </p>
         * 
         * @param heartbeatInSeconds
         *        The maximum allowed duration between two heartbeats for the activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heartbeatInSeconds(Long heartbeatInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String resource;

        private String input;

        private HistoryEventExecutionDataDetails inputDetails;

        private Long timeoutInSeconds;

        private Long heartbeatInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityScheduledEventDetails model) {
            resource(model.resource);
            input(model.input);
            inputDetails(model.inputDetails);
            timeoutInSeconds(model.timeoutInSeconds);
            heartbeatInSeconds(model.heartbeatInSeconds);
        }

        public final String getResource() {
            return resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final HistoryEventExecutionDataDetails.Builder getInputDetails() {
            return inputDetails != null ? inputDetails.toBuilder() : null;
        }

        @Override
        public final Builder inputDetails(HistoryEventExecutionDataDetails inputDetails) {
            this.inputDetails = inputDetails;
            return this;
        }

        public final void setInputDetails(HistoryEventExecutionDataDetails.BuilderImpl inputDetails) {
            this.inputDetails = inputDetails != null ? inputDetails.build() : null;
        }

        public final Long getTimeoutInSeconds() {
            return timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final void setTimeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        public final Long getHeartbeatInSeconds() {
            return heartbeatInSeconds;
        }

        @Override
        public final Builder heartbeatInSeconds(Long heartbeatInSeconds) {
            this.heartbeatInSeconds = heartbeatInSeconds;
            return this;
        }

        public final void setHeartbeatInSeconds(Long heartbeatInSeconds) {
            this.heartbeatInSeconds = heartbeatInSeconds;
        }

        @Override
        public ActivityScheduledEventDetails build() {
            return new ActivityScheduledEventDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
