/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a state entered during an execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StateEnteredEventDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<StateEnteredEventDetails.Builder, StateEnteredEventDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StateEnteredEventDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StateEnteredEventDetails::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<HistoryEventExecutionDataDetails> INPUT_DETAILS_FIELD = SdkField
            .<HistoryEventExecutionDataDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(StateEnteredEventDetails::inputDetails)).setter(setter(Builder::inputDetails))
            .constructor(HistoryEventExecutionDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUT_FIELD,
            INPUT_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String input;

    private final HistoryEventExecutionDataDetails inputDetails;

    private StateEnteredEventDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.input = builder.input;
        this.inputDetails = builder.inputDetails;
    }

    /**
     * <p>
     * The name of the state.
     * </p>
     * 
     * @return The name of the state.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The string that contains the JSON input data for the state. Length constraints apply to the payload size, and are
     * expressed as bytes in UTF-8 encoding.
     * </p>
     * 
     * @return The string that contains the JSON input data for the state. Length constraints apply to the payload size,
     *         and are expressed as bytes in UTF-8 encoding.
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * Contains details about the input for an execution history event.
     * </p>
     * 
     * @return Contains details about the input for an execution history event.
     */
    public HistoryEventExecutionDataDetails inputDetails() {
        return inputDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(inputDetails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StateEnteredEventDetails)) {
            return false;
        }
        StateEnteredEventDetails other = (StateEnteredEventDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(input(), other.input())
                && Objects.equals(inputDetails(), other.inputDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StateEnteredEventDetails").add("Name", name())
                .add("Input", input() == null ? null : "*** Sensitive Data Redacted ***").add("InputDetails", inputDetails())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "inputDetails":
            return Optional.ofNullable(clazz.cast(inputDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StateEnteredEventDetails, T> g) {
        return obj -> g.apply((StateEnteredEventDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StateEnteredEventDetails> {
        /**
         * <p>
         * The name of the state.
         * </p>
         * 
         * @param name
         *        The name of the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The string that contains the JSON input data for the state. Length constraints apply to the payload size, and
         * are expressed as bytes in UTF-8 encoding.
         * </p>
         * 
         * @param input
         *        The string that contains the JSON input data for the state. Length constraints apply to the payload
         *        size, and are expressed as bytes in UTF-8 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * Contains details about the input for an execution history event.
         * </p>
         * 
         * @param inputDetails
         *        Contains details about the input for an execution history event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDetails(HistoryEventExecutionDataDetails inputDetails);

        /**
         * <p>
         * Contains details about the input for an execution history event.
         * </p>
         * This is a convenience that creates an instance of the {@link HistoryEventExecutionDataDetails.Builder}
         * avoiding the need to create one manually via {@link HistoryEventExecutionDataDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link HistoryEventExecutionDataDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #inputDetails(HistoryEventExecutionDataDetails)}.
         * 
         * @param inputDetails
         *        a consumer that will call methods on {@link HistoryEventExecutionDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDetails(HistoryEventExecutionDataDetails)
         */
        default Builder inputDetails(Consumer<HistoryEventExecutionDataDetails.Builder> inputDetails) {
            return inputDetails(HistoryEventExecutionDataDetails.builder().applyMutation(inputDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String input;

        private HistoryEventExecutionDataDetails inputDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(StateEnteredEventDetails model) {
            name(model.name);
            input(model.input);
            inputDetails(model.inputDetails);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final HistoryEventExecutionDataDetails.Builder getInputDetails() {
            return inputDetails != null ? inputDetails.toBuilder() : null;
        }

        @Override
        public final Builder inputDetails(HistoryEventExecutionDataDetails inputDetails) {
            this.inputDetails = inputDetails;
            return this;
        }

        public final void setInputDetails(HistoryEventExecutionDataDetails.BuilderImpl inputDetails) {
            this.inputDetails = inputDetails != null ? inputDetails.build() : null;
        }

        @Override
        public StateEnteredEventDetails build() {
            return new StateEnteredEventDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
