/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about an activity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivityListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ActivityListItem.Builder, ActivityListItem> {
    private static final SdkField<String> ACTIVITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("activityArn").getter(getter(ActivityListItem::activityArn)).setter(setter(Builder::activityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ActivityListItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(ActivityListItem::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_ARN_FIELD,
            NAME_FIELD, CREATION_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String activityArn;

    private final String name;

    private final Instant creationDate;

    private ActivityListItem(BuilderImpl builder) {
        this.activityArn = builder.activityArn;
        this.name = builder.name;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the activity.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the activity.
     */
    public String activityArn() {
        return activityArn;
    }

    /**
     * <p>
     * The name of the activity.
     * </p>
     * <p>
     * A name must <i>not</i> contain:
     * </p>
     * <ul>
     * <li>
     * <p>
     * white space
     * </p>
     * </li>
     * <li>
     * <p>
     * brackets <code>&lt; &gt; { } [ ]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * wildcard characters <code>? *</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
     * </p>
     * </li>
     * </ul>
     * <p>
     * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     * </p>
     * 
     * @return The name of the activity.</p>
     *         <p>
     *         A name must <i>not</i> contain:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         white space
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         brackets <code>&lt; &gt; { } [ ]</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         wildcard characters <code>? *</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The date the activity is created.
     * </p>
     * 
     * @return The date the activity is created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activityArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityListItem)) {
            return false;
        }
        ActivityListItem other = (ActivityListItem) obj;
        return Objects.equals(activityArn(), other.activityArn()) && Objects.equals(name(), other.name())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ActivityListItem").add("ActivityArn", activityArn()).add("Name", name())
                .add("CreationDate", creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activityArn":
            return Optional.ofNullable(clazz.cast(activityArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivityListItem, T> g) {
        return obj -> g.apply((ActivityListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActivityListItem> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the activity.
         * </p>
         * 
         * @param activityArn
         *        The Amazon Resource Name (ARN) that identifies the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityArn(String activityArn);

        /**
         * <p>
         * The name of the activity.
         * </p>
         * <p>
         * A name must <i>not</i> contain:
         * </p>
         * <ul>
         * <li>
         * <p>
         * white space
         * </p>
         * </li>
         * <li>
         * <p>
         * brackets <code>&lt; &gt; { } [ ]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * wildcard characters <code>? *</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
         * </p>
         * </li>
         * </ul>
         * <p>
         * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         * </p>
         * 
         * @param name
         *        The name of the activity.</p>
         *        <p>
         *        A name must <i>not</i> contain:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        white space
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        brackets <code>&lt; &gt; { } [ ]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        wildcard characters <code>? *</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The date the activity is created.
         * </p>
         * 
         * @param creationDate
         *        The date the activity is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String activityArn;

        private String name;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityListItem model) {
            activityArn(model.activityArn);
            name(model.name);
            creationDate(model.creationDate);
        }

        public final String getActivityArn() {
            return activityArn;
        }

        @Override
        public final Builder activityArn(String activityArn) {
            this.activityArn = activityArn;
            return this;
        }

        public final void setActivityArn(String activityArn) {
            this.activityArn = activityArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public ActivityListItem build() {
            return new ActivityListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
