/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.SfnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExecutionHistoryRequest
extends SfnRequest
implements ToCopyableBuilder<Builder, GetExecutionHistoryRequest> {
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionArn").getter(GetExecutionHistoryRequest.getter(GetExecutionHistoryRequest::executionArn)).setter(GetExecutionHistoryRequest.setter(Builder::executionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetExecutionHistoryRequest.getter(GetExecutionHistoryRequest::maxResults)).setter(GetExecutionHistoryRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("reverseOrder").getter(GetExecutionHistoryRequest.getter(GetExecutionHistoryRequest::reverseOrder)).setter(GetExecutionHistoryRequest.setter(Builder::reverseOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reverseOrder").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetExecutionHistoryRequest.getter(GetExecutionHistoryRequest::nextToken)).setter(GetExecutionHistoryRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Boolean> INCLUDE_EXECUTION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeExecutionData").getter(GetExecutionHistoryRequest.getter(GetExecutionHistoryRequest::includeExecutionData)).setter(GetExecutionHistoryRequest.setter(Builder::includeExecutionData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeExecutionData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ARN_FIELD, MAX_RESULTS_FIELD, REVERSE_ORDER_FIELD, NEXT_TOKEN_FIELD, INCLUDE_EXECUTION_DATA_FIELD));
    private final String executionArn;
    private final Integer maxResults;
    private final Boolean reverseOrder;
    private final String nextToken;
    private final Boolean includeExecutionData;

    private GetExecutionHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.executionArn = builder.executionArn;
        this.maxResults = builder.maxResults;
        this.reverseOrder = builder.reverseOrder;
        this.nextToken = builder.nextToken;
        this.includeExecutionData = builder.includeExecutionData;
    }

    public final String executionArn() {
        return this.executionArn;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Boolean reverseOrder() {
        return this.reverseOrder;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Boolean includeExecutionData() {
        return this.includeExecutionData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.reverseOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeExecutionData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExecutionHistoryRequest)) {
            return false;
        }
        GetExecutionHistoryRequest other = (GetExecutionHistoryRequest)((Object)obj);
        return Objects.equals(this.executionArn(), other.executionArn()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.reverseOrder(), other.reverseOrder()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.includeExecutionData(), other.includeExecutionData());
    }

    public final String toString() {
        return ToString.builder((String)"GetExecutionHistoryRequest").add("ExecutionArn", (Object)this.executionArn()).add("MaxResults", (Object)this.maxResults()).add("ReverseOrder", (Object)this.reverseOrder()).add("NextToken", (Object)this.nextToken()).add("IncludeExecutionData", (Object)this.includeExecutionData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionArn": {
                return Optional.ofNullable(clazz.cast(this.executionArn()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "reverseOrder": {
                return Optional.ofNullable(clazz.cast(this.reverseOrder()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "includeExecutionData": {
                return Optional.ofNullable(clazz.cast(this.includeExecutionData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExecutionHistoryRequest, T> g) {
        return obj -> g.apply((GetExecutionHistoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnRequest.BuilderImpl
    implements Builder {
        private String executionArn;
        private Integer maxResults;
        private Boolean reverseOrder;
        private String nextToken;
        private Boolean includeExecutionData;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExecutionHistoryRequest model) {
            super(model);
            this.executionArn(model.executionArn);
            this.maxResults(model.maxResults);
            this.reverseOrder(model.reverseOrder);
            this.nextToken(model.nextToken);
            this.includeExecutionData(model.includeExecutionData);
        }

        public final String getExecutionArn() {
            return this.executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Boolean getReverseOrder() {
            return this.reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Boolean getIncludeExecutionData() {
            return this.includeExecutionData;
        }

        @Override
        public final Builder includeExecutionData(Boolean includeExecutionData) {
            this.includeExecutionData = includeExecutionData;
            return this;
        }

        public final void setIncludeExecutionData(Boolean includeExecutionData) {
            this.includeExecutionData = includeExecutionData;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetExecutionHistoryRequest build() {
            return new GetExecutionHistoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SfnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExecutionHistoryRequest> {
        public Builder executionArn(String var1);

        public Builder maxResults(Integer var1);

        public Builder reverseOrder(Boolean var1);

        public Builder nextToken(String var1);

        public Builder includeExecutionData(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

