/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListActivitiesResponse extends SfnResponse implements
        ToCopyableBuilder<ListActivitiesResponse.Builder, ListActivitiesResponse> {
    private static final SdkField<List<ActivityListItem>> ACTIVITIES_FIELD = SdkField
            .<List<ActivityListItem>> builder(MarshallingType.LIST)
            .memberName("activities")
            .getter(getter(ListActivitiesResponse::activities))
            .setter(setter(Builder::activities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActivityListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActivityListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListActivitiesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ActivityListItem> activities;

    private final String nextToken;

    private ListActivitiesResponse(BuilderImpl builder) {
        super(builder);
        this.activities = builder.activities;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Activities property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasActivities() {
        return activities != null && !(activities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of activities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActivities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of activities.
     */
    public final List<ActivityListItem> activities() {
        return activities;
    }

    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * 
     * @return If <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after
     *         24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasActivities() ? activities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActivitiesResponse)) {
            return false;
        }
        ListActivitiesResponse other = (ListActivitiesResponse) obj;
        return hasActivities() == other.hasActivities() && Objects.equals(activities(), other.activities())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListActivitiesResponse").add("Activities", hasActivities() ? activities() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activities":
            return Optional.ofNullable(clazz.cast(activities()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListActivitiesResponse, T> g) {
        return obj -> g.apply((ListActivitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListActivitiesResponse> {
        /**
         * <p>
         * The list of activities.
         * </p>
         * 
         * @param activities
         *        The list of activities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activities(Collection<ActivityListItem> activities);

        /**
         * <p>
         * The list of activities.
         * </p>
         * 
         * @param activities
         *        The list of activities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activities(ActivityListItem... activities);

        /**
         * <p>
         * The list of activities.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ActivityListItem>.Builder} avoiding the
         * need to create one manually via {@link List<ActivityListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ActivityListItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #activities(List<ActivityListItem>)}.
         * 
         * @param activities
         *        a consumer that will call methods on {@link List<ActivityListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activities(List<ActivityListItem>)
         */
        Builder activities(Consumer<ActivityListItem.Builder>... activities);

        /**
         * <p>
         * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired
         * pagination token will return an <i>HTTP 400 InvalidToken</i> error.
         * </p>
         * 
         * @param nextToken
         *        If <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
         *        expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i>
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private List<ActivityListItem> activities = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActivitiesResponse model) {
            super(model);
            activities(model.activities);
            nextToken(model.nextToken);
        }

        public final List<ActivityListItem.Builder> getActivities() {
            List<ActivityListItem.Builder> result = ActivityListCopier.copyToBuilder(this.activities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder activities(Collection<ActivityListItem> activities) {
            this.activities = ActivityListCopier.copy(activities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(ActivityListItem... activities) {
            activities(Arrays.asList(activities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(Consumer<ActivityListItem.Builder>... activities) {
            activities(Stream.of(activities).map(c -> ActivityListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setActivities(Collection<ActivityListItem.BuilderImpl> activities) {
            this.activities = ActivityListCopier.copyFromBuilder(activities);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListActivitiesResponse build() {
            return new ListActivitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
